#
# This file is part of the GROMACS molecular simulation package.
#
# Copyright 2015- The GROMACS Authors
# and the project initiators Erik Lindahl, Berk Hess and David van der Spoel.
# Consult the AUTHORS/COPYING files and https://www.gromacs.org for details.
#
# GROMACS is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public License
# as published by the Free Software Foundation; either version 2.1
# of the License, or (at your option) any later version.
#
# GROMACS is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with GROMACS; if not, see
# https://www.gnu.org/licenses, or write to the Free Software Foundation,
# Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
#
# If you want to redistribute modifications to GROMACS, please
# consider that scientific software is very special. Version
# control is crucial - bugs must be traceable. We will be happy to
# consider code for inclusion in the official distribution, but
# derived work must not be called official GROMACS. Details are found
# in the README & COPYING files - if they are missing, get the
# official version at https://www.gromacs.org.
#
# To help us fund GROMACS development, we humbly ask that you cite
# the research papers on the package. Check out https://www.gromacs.org.

# -*- coding: utf-8 -*-
#
# GROMACS documentation build configuration file, created by
# sphinx-quickstart on Tue Jan 13 14:28:44 2015.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

import datetime
import os
import sys

# The following definitions are completed via CMake machinery.

gmxapi_staging_path = "@GMXAPI_PYTHON_STAGING_DIR@"
if gmxapi_staging_path and os.path.isdir(gmxapi_staging_path):
    sys.path.append(gmxapi_staging_path)

try:
    import gmxapi
except ImportError:
    gmxapi_version_string = "N/A"
else:
    gmxapi_version_string = gmxapi.__version__

gmx_admin_scripts_path = "@GMX_ADMIN_DIR@"
gmx_containers_path = "@GMX_ADMIN_DIR@/containers"
gmx_sphinx_extension_path = "@SPHINX_EXTENSION_PATH@"
releng_path = "@RELENG_PATH@"
gmx_version_string = "@GMX_VERSION_STRING@"
gmx_version_string_full = "@GMX_VERSION_STRING_FULL@"
regressiontest_version = "@REGRESSIONTEST_VERSION@"
gmx_min_sphinx = "@EXPECTED_SPHINX_VERSION@"
variables = [
    ("EXPECTED_DOXYGEN_VERSION", "@EXPECTED_DOXYGEN_VERSION@"),
    ("EXPECTED_SPHINX_VERSION", "@EXPECTED_SPHINX_VERSION@"),
    ("CMAKE_MINIMUM_REQUIRED_VERSION", "@CMAKE_MINIMUM_REQUIRED_VERSION@"),
    ("GMX_CLANG_MINIMUM_REQUIRED_VERSION", "@GMX_CLANG_MINIMUM_REQUIRED_VERSION@"),
    ("GMX_GCC_MINIMUM_REQUIRED_VERSION", "@GMX_GCC_MINIMUM_REQUIRED_VERSION@"),
    ("GMX_CUDA_MINIMUM_REQUIRED_VERSION", "@GMX_CUDA_MINIMUM_REQUIRED_VERSION@"),
    (
        "GMX_CUDA_MINIMUM_REQUIRED_COMPUTE_CAPABILITY",
        "@GMX_CUDA_MINIMUM_REQUIRED_COMPUTE_CAPABILITY@",
    ),
    ("GMX_HDF5_MINIMUM_REQUIRED_VERSION", "@GMX_HDF5_MINIMUM_REQUIRED_VERSION@"),
    ("REQUIRED_OPENCL_MIN_VERSION", "@REQUIRED_OPENCL_MIN_VERSION@"),
    ("SOURCE_MD5SUM", "@SOURCE_MD5SUM@"),
    ("REGRESSIONTEST_MD5SUM", "@REGRESSIONTEST_MD5SUM_STRING@"),
    ("GMX_TNG_MINIMUM_REQUIRED_VERSION", "@GMX_TNG_MINIMUM_REQUIRED_VERSION@"),
    ("GMX_LMFIT_REQUIRED_VERSION", "@GMX_LMFIT_REQUIRED_VERSION@"),
    ("GMX_MANUAL_DOI_STRING", "@GMX_MANUAL_DOI_STRING@"),
    ("GMX_SOURCE_DOI_STRING", "@GMX_SOURCE_DOI_STRING@"),
    ("GMX_CURRENT_CONTRIBUTORS", "@GMX_CURRENT_CONTRIBUTORS_STRING@"),
    ("GMX_PREVIOUS_CONTRIBUTORS", "@GMX_PREVIOUS_CONTRIBUTORS_STRING@"),
    ("GMX_CURRENT_PROJECT_LEADERS", "@GMX_CURRENT_PROJECT_LEADERS_STRING@"),
]
# End of build-time substitutions.

sys.path.extend(
    (gmx_admin_scripts_path, gmx_containers_path, gmx_sphinx_extension_path)
)
if releng_path and os.path.isdir(releng_path):
    sys.path.append(releng_path)

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
# sys.path.insert(0, os.path.abspath('.'))

# -- General configuration ------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
# gmx_min_sphinx is set from the expected minimum version of Sphinx
# in CMakeLists.txt
needs_sphinx = gmx_min_sphinx

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    "sphinx.ext.autodoc",
    "sphinx.ext.doctest",
    "sphinx.ext.extlinks",
    "sphinx.ext.graphviz",
    "sphinx.ext.intersphinx",
    "sphinx.ext.mathjax",
    "sphinx.ext.napoleon",
    "sphinx.ext.todo",
    # The viewcode extension requires extra configuration or consideration to
    # avoid collecting sources for external packages (through intersphninx) or
    # generating broken links for compiled extension modules that do not have
    # inspectable 'code' member data.
    # Ref: https://www.sphinx-doc.org/en/master/usage/extensions/viewcode.html
    # Please run linkchecker and inspect the generated
    # docs/html/_modules/index.html page before committing a change that enables
    # 'sphinx.ext.viewcode',
    "sphinx_copybutton",
    "sphinx_inline_tabs",
    "sphinxarg.ext",
    "sphinxcontrib.autoprogram",
    "gmxsphinx",
]
extlinks = {"issue": ("https://gitlab.com/gromacs/gromacs/-/issues/%s", "Issue %s")}

# Add any paths that contain templates here, relative to this directory.
# templates_path = ['_templates']

# The suffix of source filenames.
source_suffix = ".rst"

# The encoding of source files.
# source_encoding = 'utf-8-sig'

# General information about the project.
project = "GROMACS"
copyright = str(datetime.datetime.now().year) + ", GROMACS development team"
thisyear_string = str(datetime.datetime.now().year)
# The version info for the project you're documenting, acts as replacement for
# |version| and |release|, also used in various other places throughout the
# built documents.
#
# The short X.Y version.
version = gmx_version_string
# The full version, including alpha/beta/rc tags.
release = gmx_version_string_full
# default file extension for plots
plotext = ".eps"

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
# language = None

# There are two options for replacing |today|: either, you set today to some
# non-false value, then it is used:
# today = ''
# Else, today_fmt is used as the format for a strftime call.
# today_fmt = '%B %d, %Y'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
exclude_patterns = ["fragments"]
# Note: the automatically generated builder tags are not available until after
# conf.py is processed, so we use additional custom tags in our sphinx targets.
if not tags.has("do_man"):
    exclude_patterns += ["man"]
if tags.has("do_latex"):
    exclude_patterns.extend(
        [
            "index.rst",
        ]
    )
    # The master toctree document.
    root_doc = "texindex"
else:
    exclude_patterns += ["texindex.rst"]
    # The master toctree document.
    root_doc = "index"

# Set tag if documentation build can convert images or not
# to selectively include files in reference manual
tags.add("@IMAGE_CONVERT_STRING@")

if tags.has("gmx_image_convert_impossible"):
    exclude_patterns.extend(
        [
            "reference-manual/algorithms",
            "reference-manual/functions",
            "reference-manual/special",
            "reference-manual/analysis",
        ]
    )

# The reST default role (used for this markup: `text`) to use for all
# documents.
default_role = "any"

# If true, '()' will be appended to :func: etc. cross-reference text.
# add_function_parentheses = True

# If true, the current module name will be prepended to all description
# unit titles (such as .. function::).
# add_module_names = True

# If true, sectionauthor and moduleauthor directives will be shown in the
# output. They are ignored by default.
# show_authors = False

# The name of the Pygments (syntax highlighting) style to use.
# pygments_style = 'sphinx'

# A list of ignored prefixes for module index sorting.
# modindex_common_prefix = []

# If true, keep warnings as "system message" paragraphs in the built documents.
# keep_warnings = False

# Configure the values for all the variables that might later configure any of the .rst files.
substitutions = [".. |{0}| replace:: {1}".format(*x) for x in variables if x[1]]
substitutions.extend(
    [".. |{0}| replace:: unknown".format(x[0]) for x in variables if x[1] == ""]
)
rst_epilog = "\n".join(substitutions)
rst_epilog += """
.. |Gromacs| replace:: GROMACS
.. _gmx-manual: manual-{gmx_version_string}.pdf
.. _gmx-manual-parent-dir: ../manual-{gmx_version_string}.pdf
.. |gmx-source-package-ftp| replace:: As ftp ftp://ftp.gromacs.org/gromacs/gromacs-{gmx_version_string}.tar.gz
.. |gmx-source-package-http| replace:: As https https://ftp.gromacs.org/gromacs/gromacs-{gmx_version_string}.tar.gz
.. |gmx-regressiontests-package| replace:: https://ftp.gromacs.org/regressiontests/regressiontests-{regressiontest_version}.tar.gz
.. |gmxapi-version| replace:: {gmxapi_version_string}
.. _up-to-date installation instructions: https://manual.gromacs.org/documentation/current/install-guide/index.html
.. _developer discussion forum: https://gromacs.bioexcel.eu/c/gromacs-developers/10
.. _user discussion forum: https://gromacs.bioexcel.eu/c/gromacs-user-forum/5
.. _gmx-developers mailing list archive: https://mailman-1.sys.kth.se/pipermail/gromacs.org_gmx-developers
.. _gmx-users mailing list archive: https://mailman-1.sys.kth.se/pipermail/gromacs.org_gmx-users
.. _CUDA: https://developer.nvidia.com/cuda-zone
.. _OpenCL: https://www.khronos.org/opencl/
.. _SYCL: https://www.khronos.org/sycl/
.. _Intel oneAPI DPC++: https://www.intel.com/content/www/us/en/developer/tools/oneapi/dpc-compiler.html
.. _AdaptiveCpp: https://github.com/AdaptiveCpp/AdaptiveCpp
.. _ROCm: https://rocm.docs.amd.com/en/latest/index.html
.. _rocPrim: https://rocm.docs.amd.com/projects/rocPRIM/en/latest/index.html
.. _HDF5: https://www.hdfgroup.org/solutions/hdf5
.. _H5MD: https://h5md.nongnu.org
.. _OpenMPI: http://www.open-mpi.org
.. _MPICH: http://www.mpich.org
.. _OpenMP: http://en.wikipedia.org/wiki/OpenMP
.. _CMake installation page: http://www.cmake.org/install/
.. _Ubuntu toolchain ppa page: https://launchpad.net/~ubuntu-toolchain-r/+archive/ubuntu/test
.. _EPEL page: https://fedoraproject.org/wiki/EPEL
.. _running CMake: http://www.cmake.org/runningcmake/
.. _CMake environment variables: https://gitlab.kitware.com/cmake/community/-/wikis/doc/cmake/Useful-Variables
.. _FFTW: http://www.fftw.org
.. _FFTW installation guide: http://www.fftw.org/doc/Installation-and-Customization.html#Installation-and-Customization
.. _MKL: https://software.intel.com/en-us/intel-mkl
.. _VMD: http://www.ks.uiuc.edu/Research/vmd/
.. _PyMOL: http://www.pymol.org
.. _webpage: http://www.gromacs.org
.. _ftp site: ftp://ftp.gromacs.org/gromacs/
.. _third-party-tutorials: http://www.mdtutorials.com/gmx/
.. _tutorials: https://tutorials.gromacs.org/
.. _issue tracker: https://gitlab.com/gromacs/gromacs/-/issues/
.. _gitlab: https://gitlab.com/gromacs/gromacs/
.. _download: ../download.html
.. |thisyear| replace:: {thisyear_string}
""".format(
    gmx_version_string=gmx_version_string,
    gmxapi_version_string=gmxapi_version_string,
    regressiontest_version=regressiontest_version,
    thisyear_string=thisyear_string,
)

# -- Options for HTML output ----------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
html_theme = "furo"
# html_theme = 'alabaster'

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
html_theme_options = {
    # Hide project title in sidebar, since we are using a logo instead.
    "sidebar_hide_name": True,
    # Add an "edit" button to the rendered web pages.
    "source_repository": "https://gitlab.com/gromacs/gromacs/",
    "source_branch": "main",
    "source_directory": "docs/",
}

# Add any paths that contain custom themes here, relative to this directory.
html_theme_path = [""]

# The name for this set of Sphinx documents.  If None, it defaults to
# "<project> v<release> documentation".
html_title = "GROMACS " + release + " documentation"

# A shorter title for the navigation bar.  Default is the same as html_title.
html_short_title = "GROMACS " + version

# The name of an image file (relative to this directory) to place at the top
# of the sidebar.
html_logo = "reference-manual/plots/GMX_logos/gmx_logo_blue.svg"

# The name of an image file (within the static path) to use as favicon of the
# docs.  This file should be a Windows icon file (.ico) being 16x16 or 32x32
# pixels large.
# html_favicon = None

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
# html_static_path = ['_static']

# Add any extra paths that contain custom files (such as robots.txt or
# .htaccess) here, relative to this directory. These files are copied
# directly to the root of the documentation.
# html_extra_path = []

# If not '', a 'Last updated on:' timestamp is inserted at every page bottom,
# using the given strftime format.
# html_last_updated_fmt = '%b %d, %Y'

# If true, SmartyPants will be used to convert quotes and dashes to
# typographically correct entities.
# html_use_smartypants = True

# Custom sidebar templates, maps document names to template names.
# html_sidebars = {}

# Additional templates that should be rendered to pages, maps page names to
# template names.
# html_additional_pages = {}

# If false, no module index is generated.
# html_domain_indices = True

# If false, no index is generated.
# html_use_index = True

# If true, the index is split into individual pages for each letter.
# html_split_index = False

# If true, links to the reST sources are added to the pages.
# html_show_sourcelink = True

# If true, "Created using Sphinx" is shown in the HTML footer. Default is True.
# html_show_sphinx = True

# If true, "(C) Copyright ..." is shown in the HTML footer. Default is True.
# html_show_copyright = True

# If true, an OpenSearch description file will be output, and all pages will
# contain a <link> tag referring to it.  The value of this option must be the
# base URL from which the finished HTML is served.
# html_use_opensearch = ''

# This is the file name suffix for HTML files (e.g. ".xhtml").
# html_file_suffix = None

# Output file base name for HTML help builder.
htmlhelp_basename = "Gromacsdoc"


# -- Options for LaTeX output ---------------------------------------------
# Note: the automatically generated builder tags are not available until after
# conf.py is processed, so we use additional custom tags in our sphinx targets.
if tags.has("do_latex"):
    latex_elements = {
        # The paper size ('letterpaper' or 'a4paper').
        "papersize": "a4paper",
        # The font size ('10pt', '11pt' or '12pt').
        "pointsize": "11",
        # Additional stuff for the LaTeX preamble.
        # The tocdepth setting is needed to overwrite the default value set by Sphinx
        # to get a more detailed toctree in the pdf version of the manual.
        "preamble": r"""
        \usepackage{here}
        \usepackage{picins}
        \usepackage{underscore}
        \usepackage{tabularx}
        \usepackage{multicol}
        \usepackage{dcolumn}
        \usepackage{makeidx}
        \usepackage{times}
        \usepackage{ifthen}
        \usepackage{enumitem}
        \usepackage{longtable}
        \usepackage{pdflscape}
        \pagenumbering{roman}
        \usepackage{array}
        \setcounter{tocdepth}{2}
        """,
        # Format output to avoid empty pages
        "classoptions": ",openany,oneside",
    }

    # Grouping the document tree into LaTeX files. List of tuples
    # (source start file, target name, title,
    #  author, documentclass [howto, manual, or own class]).
    latex_documents = [
        (
            "texindex",
            "gromacs.tex",
            "GROMACS Documentation",
            "GROMACS development team",
            "manual",
        ),
    ]

    # The name of an image file (relative to this directory) to place at the top of
    # the title page.
    latex_logo = "reference-manual/plots/GMX_logos/gmx_falcon_blue.png"

    # For "manual" documents, if this is true, then toplevel headings are parts,
    # not chapters.
    latex_use_parts = True

    # If true, show page references after internal links.
    latex_show_pagerefs = True

    # If true, show URL addresses after external links.
    # latex_show_urls = False

    # Documents to append as an appendix to all manuals.
    # latex_appendices = []

    # If false, no module index is generated.
    # latex_domain_indices = True


# -- Options for manual page output ---------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
# Note: the automatically generated builder tags are not available until after
# conf.py is processed, so we use additional custom tags in our sphinx targets.
if tags.has("do_man"):
    # Note: conf-man.py is generated by the (built) command line executable.
    # Ref: gmx::CommandLineHelpModule
    exec(open("conf-man.py").read())

# If true, show URL addresses after external links.
# man_show_urls = False


# -- Options for Texinfo output -------------------------------------------
# Note: the automatically generated builder tags are not available until after
# conf.py is processed, so we use additional custom tags in our sphinx targets.
if tags.has("do_texinfo"):

    # Grouping the document tree into Texinfo files. List of tuples
    # (source start file, target name, title, author,
    #  dir menu entry, description, category)
    texinfo_documents = [
        (
            "texindex",
            "GROMACS",
            "GROMACS Documentation",
            "GROMACS development team",
            "GROMACS",
            "One line description of project.",
            "Miscellaneous",
        ),
    ]

    # Documents to append as an appendix to all manuals.
    # texinfo_appendices = []

    # If false, no module index is generated.
    # texinfo_domain_indices = True

    # How to display URL addresses: 'footnote', 'no', or 'inline'.
    # texinfo_show_urls = 'footnote'

    # If true, do not generate a @detailmenu in the "Top" node's menu.
    # texinfo_no_detailmenu = False

# Make it possible to use numbered labels for figures and tables
numfig = True

# -- Options for autodoc extension ----------------------------------------

# http://www.sphinx-doc.org/en/master/usage/extensions/autodoc.html#confval-autodoc-mock-imports
autodoc_mock_imports = ["hpccm", "hpccm.config"]

# -- Options for intersphinx extension ------------------------------------

intersphinx_mapping = {
    "python": ("https://docs.python.org/3", None),
    "mpi4py": ("https://mpi4py.readthedocs.io/en/stable/", None),
}
intersphinx_cache_limit = -1
intersphinx_timeout = 10
