#pragma once
/*
 *  $Id: menu.h 28837 2025-11-10 08:56:21Z yeti-dn $
 *  Copyright (C) 2003-2025 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWYAPP_MENU_H__
#define __GWYAPP_MENU_H__

#include <gtk/gtk.h>
#include <libgwyui/sensitivity-group.h>
#include <libgwyapp/module-loader.h>
#include <libgwyapp/file.h>

G_BEGIN_DECLS

typedef enum {
    GWY_MENU_FLAG_FILE        = 1 << 0,
    GWY_MENU_FLAG_UNDO        = 1 << 1,
    GWY_MENU_FLAG_REDO        = 1 << 2,
    GWY_MENU_FLAG_IMAGE       = 1 << 3,
    GWY_MENU_FLAG_IMAGE_SHOW  = 1 << 4,
    GWY_MENU_FLAG_IMAGE_MASK  = 1 << 5,
    GWY_MENU_FLAG_GL          = 1 << 6,
    GWY_MENU_FLAG_GRAPH       = 1 << 7,
    GWY_MENU_FLAG_GRAPH_CURVE = 1 << 8,
    GWY_MENU_FLAG_VOLUME      = 1 << 9,
    GWY_MENU_FLAG_XYZ         = 1 << 10,
    GWY_MENU_FLAG_CMAP        = 1 << 11,
} GwyMenuSensFlags;

GtkWidget*           gwy_app_image_menu                (GtkAccelGroup *accel_group,
                                                        GwySensitivityGroup *sens_group);
GtkWidget*           gwy_app_graph_menu                (GtkAccelGroup *accel_group,
                                                        GwySensitivityGroup *sens_group);
GtkWidget*           gwy_app_xyz_menu                  (GtkAccelGroup *accel_group,
                                                        GwySensitivityGroup *sens_group);
GtkWidget*           gwy_app_curve_map_menu            (GtkAccelGroup *accel_group,
                                                        GwySensitivityGroup *sens_group);
GtkWidget*           gwy_app_synth_menu                (GtkAccelGroup *accel_group,
                                                        GwySensitivityGroup *sens_group);
GtkWidget*           gwy_app_volume_menu               (GtkAccelGroup *accel_group,
                                                        GwySensitivityGroup *sens_group);
void                 gwy_app_image_menu_add_run_last   (GtkWidget *menu);
GwyRunModeFlags      gwy_app_run_process_func          (const gchar *name);
void                 gwy_app_run_process_func_in_mode  (const gchar *name,
                                                        GwyRunModeFlags run);
void                 gwy_app_run_graph_func            (const gchar *name);
GwyRunModeFlags      gwy_app_run_volume_func           (const gchar *name);
void                 gwy_app_run_volume_func_in_mode   (const gchar *name,
                                                        GwyRunModeFlags run);
GwyRunModeFlags      gwy_app_run_xyz_func              (const gchar *name);
void                 gwy_app_run_xyz_func_in_mode      (const gchar *name,
                                                        GwyRunModeFlags run);
GwyRunModeFlags      gwy_app_run_curve_map_func        (const gchar *name);
void                 gwy_app_run_curve_map_func_in_mode(const gchar *name,
                                                        GwyRunModeFlags run);
GwyRunModeFlags      gwy_app_run_synth_func            (const gchar *name);
void                 gwy_app_run_synth_func_in_mode    (const gchar *name,
                                                        GwyRunModeFlags run);
GtkWidget*           gwy_app_create_recent_func_menu   (GwyDataKind data_kind,
                                                        GtkWindow *window,
                                                        GwySensitivityGroup *sens_group);
GwySensitivityGroup* gwy_app_sensitivity_get_group     (void);
void                 gwy_app_sensitivity_add_widget    (GtkWidget *widget,
                                                        GwyMenuSensFlags mask);
void                 gwy_app_sensitivity_set_state     (GwyMenuSensFlags affected_mask,
                                                        GwyMenuSensFlags state);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
