+++
title = "hx-get"
description = """\
  The hx-get attribute in htmx will cause an element to issue a GET request to the specified URL and swap the returned \
  HTML into the DOM using a swap strategy."""
+++

The `hx-get` attribute will cause an element to issue a `GET` to the specified URL and swap
the HTML into the DOM using a swap strategy:

```html
  <button hx-get="/example">Get Some HTML</button>
```

This example will cause the `button` to issue a `GET` to `/example` and swap the returned HTML into
 the `innerHTML` of the `button`.

### Notes

* You can control the target of the swap using the [hx-target](@/attributes/hx-target.md) attribute
* You can control the swap strategy by using the [hx-swap](@/attributes/hx-swap.md) attribute
* You can control what event triggers the request with the [hx-trigger](@/attributes/hx-trigger.md) attribute
* You can control the data submitted with the request in various ways, documented here: [Parameters](@/docs.md#parameters)
* An empty `hx-get:""` will make a get request to the current url and will swap the current HTML page 
* By default, `hx-get` will _not_ include the inputs in an enclosing form.  If you wish to do so you will need to include
  them explicitly with `hx-include="closest form"`
