/*
  KeePass Password Safe - The Open-Source Password Manager
  Copyright (C) 2003-2025 Dominik Reichl <dominik.reichl@t-online.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using System.Xml.Serialization;

using KeePassLib.Cryptography.PasswordGenerator;

namespace KeePass.App.Configuration
{
	public sealed class AcePasswordGenerator
	{
		public AcePasswordGenerator()
		{
		}

		private bool m_bProfiles = true;
		[DefaultValue(true)]
		public bool ProfilesEnabled
		{
			get { return m_bProfiles; }
			set { m_bProfiles = value; }
		}

		private PwProfile m_prfAuto = new PwProfile();
		public PwProfile AutoGeneratedPasswordsProfile
		{
			get { return m_prfAuto; }
			set
			{
				if(value == null) throw new ArgumentNullException("value");
				m_prfAuto = value;
			}
		}

		private PwProfile m_prfLast = null;
		[Obsolete] // For backward compatibility with plugins only
		[XmlIgnore]
		public PwProfile LastUsedProfile
		{
			get
			{
				if(m_prfLast == null) m_prfLast = new PwProfile();
				return m_prfLast;
			}
			set
			{
				if(value == null) throw new ArgumentNullException("value");
				m_prfLast = value;
			}
		}

		private List<PwProfile> m_vUserProfiles = new List<PwProfile>();
		[XmlArrayItem("Profile")]
		public List<PwProfile> UserProfiles
		{
			get { return m_vUserProfiles; }
			set
			{
				if(value == null) throw new ArgumentNullException("value");
				m_vUserProfiles = value;
			}
		}
	}
}
