/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2026 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - MassXpert, model polymer chemistries and simulate mass spectrometric data;
 * - MineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */

#pragma once

/////////////////////// stdlib includes


/////////////////////// Qt includes
#include <QMainWindow>


/////////////////////// pappsomspp includes


/////////////////////// libXpertMass includes


/////////////////////// libXpertMassGui includes


/////////////////////// Local includes
#include "ui_MonomerCrossLinkDlg.h"
#include "AbstractSeqEdWndDependentDlg.hpp"
#include "SequenceEditorWnd.hpp"


namespace MsXpS
{
namespace MassXpert
{


class Monomer;


class MonomerCrossLinkDlg : public AbstractSeqEdWndDependentDlg
{
  Q_OBJECT
  public:
  MonomerCrossLinkDlg(SequenceEditorWnd *editorWnd,
                      /* no polymer **/
                      /* no libXpertMassCore::PolChemDef **/
                      const QString &settings_file_path,
                      const QString &application_name,
                      const QString &description);

  ~MonomerCrossLinkDlg();

  public slots:
  void crossLink();
  void uncrossLink();

  void crossLinkerListWidgetItemSelectionChanged();

  void crossLinkedMonomerListWidgetItemSelectionChanged();
  void crossLinkedMonomerListWidgetItemActivated(QListWidgetItem *);

  void crossLinkListWidgetItemSelectionChanged();
  void crossLinkListWidgetItemActivated(QListWidgetItem *);

  void displayAllCrossLinksChanged(int);
  void crossLinkChangedSlot(libXpertMassCore::Polymer *polymer_p);

  void polymerSequenceModifiedSlot();

  private:
  Ui::MonomerCrossLinkDlg m_ui;

  bool m_polymerSequenceModified = false;

  QColor m_crossLinkColor;
  int m_crossLinkPixelSize;

  bool populateAvailableCrossLinkerList();
  bool populateListOfCrossLinkedMonomers();
  bool populateListOfCrossLinks(bool all = true);

  std::vector<libXpertMassCore::MonomerSPtr> parseTargetMonomerPositionsString();

  bool initialize();

  void readSettings();
  void writeSettings();
};


} // namespace MassXpert
} // namespace MsXpS
