/**
 * @file
 * A local copy of an email
 *
 * @authors
 * Copyright (C) 2023 Richard Russon <rich@flatcap.org>
 *
 * @copyright
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MUTT_CORE_MESSAGE_H
#define MUTT_CORE_MESSAGE_H

#include <stdbool.h>
#include <stdio.h>
#include <time.h>

/**
 * struct Message - A local copy of an email
 */
struct Message
{
  FILE *fp;             ///< pointer to the message data
  char *path;           ///< path to temp file
  char *committed_path; ///< the final path generated by mx_msg_commit()
  bool write;           ///< nonzero if message is open for writing
  struct
  {
    bool read : 1;    ///< Message has been read
    bool flagged : 1; ///< Message is flagged
    bool replied : 1; ///< Message has been replied to
    bool draft : 1;   ///< Message has been read
  } flags;            ///< Flags for the Message
  time_t received;    ///< Time at which this message was received
};

void            message_free(struct Message **ptr);
struct Message *message_new (void);

#endif /* MUTT_CORE_MESSAGE_H */
