## opkssh login

Authenticate with an OpenID Provider to generate an SSH key for opkssh

### Synopsis

Login creates opkssh SSH keys

Login generates a key pair, then opens a browser to authenticate the user with the OpenID Provider. Upon successful authentication, opkssh creates an SSH public key (~/.ssh/id_ecdsa) containing the user's PK token. By default, this SSH key expires after 24 hours, after which the user must run "opkssh login" again to generate a new key.

Users can then SSH into servers configured to use opkssh as the AuthorizedKeysCommand. The server verifies the PK token and grants access if the token is valid and the user is authorized per the auth_id policy.
Arguments:
  alias      The provider alias to use. If not specified, the OPKSSH_DEFAULT provider will be used. The aliases are defined by the OPKSSH_PROVIDERS environment variable. The format is <alias>,<issuer>,<client_id>,<client_secret>,<scopes>


```
opkssh login [alias] [flags]
```

### Examples

```
  opkssh login
  opkssh login google
  opkssh login --provider=<issuer>,<client_id>,<client_secret>,<scopes>
```

### Options

```
      --auto-refresh                 Automatically refresh PK token after login
      --config-path string           Path to the client config file. Default: ~/.opk/config.yml on linux and %APPDATA%\.opk\config.yml on windows
      --configure                    Apply changes to ssh config and create ~/.ssh/opkssh directory
      --create-config                Creates a client config file if it does not exist
      --disable-browser-open         Set this flag to disable opening the browser. Useful for choosing the browser you want to use
  -h, --help                         help for login
  -t, --key-type Key Type            Type of key to generate (default ecdsa)
      --log-dir string               Directory to write output logs
      --print-id-token               Set this flag to print out the contents of the id_token. Useful for inspecting claims
  -p, --print-key                    Print private key and SSH cert instead of writing them to the filesystem
  -i, --private-key-file string      Path where private keys is written
      --provider string              OpenID Provider specification in the format: <issuer>,<client_id> or <issuer>,<client_id>,<client_secret> or <issuer>,<client_id>,<client_secret>,<scopes>
      --remote-redirect-uri string   Remote redirect URI used for non-localhost redirects. This is an advanced option for embedding opkssh in server-side logic.
      --send-access-token            Set this flag to send the Access Token as well as the PK Token in the SSH cert. The Access Token is used to call the userinfo endpoint to get claims not included in the ID Token
```

### SEE ALSO

* [opkssh](opkssh.md)	 - SSH with OpenPubkey

###### Auto generated by spf13/cobra on 21-Jan-2026
