// Copyright (C) 2025 Rivos Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Autogenerated by the ProtoZero Rust compiler plugin.
// Invoked by contrib/rust-sdk/tools/gen_rust_protos
// DO NOT EDIT.

use crate::pb_enum;
use crate::pb_msg;

pb_enum!(GpuCounterDescriptorGpuCounterGroup {
    UNCLASSIFIED: 0,
    SYSTEM: 1,
    VERTICES: 2,
    FRAGMENTS: 3,
    PRIMITIVES: 4,
    MEMORY: 5,
    COMPUTE: 6,
    RAY_TRACING: 7,
});

pb_enum!(GpuCounterDescriptorMeasureUnit {
    NONE: 0,
    BIT: 1,
    KILOBIT: 2,
    MEGABIT: 3,
    GIGABIT: 4,
    TERABIT: 5,
    PETABIT: 6,
    BYTE: 7,
    KILOBYTE: 8,
    MEGABYTE: 9,
    GIGABYTE: 10,
    TERABYTE: 11,
    PETABYTE: 12,
    HERTZ: 13,
    KILOHERTZ: 14,
    MEGAHERTZ: 15,
    GIGAHERTZ: 16,
    TERAHERTZ: 17,
    PETAHERTZ: 18,
    NANOSECOND: 19,
    MICROSECOND: 20,
    MILLISECOND: 21,
    SECOND: 22,
    MINUTE: 23,
    HOUR: 24,
    VERTEX: 25,
    PIXEL: 26,
    TRIANGLE: 27,
    PRIMITIVE: 38,
    FRAGMENT: 39,
    MILLIWATT: 28,
    WATT: 29,
    KILOWATT: 30,
    JOULE: 31,
    VOLT: 32,
    AMPERE: 33,
    CELSIUS: 34,
    FAHRENHEIT: 35,
    KELVIN: 36,
    PERCENT: 37,
    INSTRUCTION: 40,
});

pb_msg!(GpuCounterDescriptor {
    specs: GpuCounterSpec, msg, 1,
    blocks: GpuCounterBlock, msg, 2,
    min_sampling_period_ns: u64, primitive, 3,
    max_sampling_period_ns: u64, primitive, 4,
    supports_instrumented_sampling: bool, primitive, 5,
});

pb_msg!(GpuCounterBlock {
    block_id: u32, primitive, 1,
    block_capacity: u32, primitive, 2,
    name: String, primitive, 3,
    description: String, primitive, 4,
    counter_ids: u32, primitive, 5,
});

pb_msg!(GpuCounterSpec {
    counter_id: u32, primitive, 1,
    name: String, primitive, 2,
    description: String, primitive, 3,
    int_peak_value: i64, primitive, 5,
    double_peak_value: f64, primitive, 6,
    numerator_units: GpuCounterDescriptorMeasureUnit, enum, 7,
    denominator_units: GpuCounterDescriptorMeasureUnit, enum, 8,
    select_by_default: bool, primitive, 9,
    groups: GpuCounterDescriptorGpuCounterGroup, enum, 10,
});
