# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.recoveryservicessiterecovery import SiteRecoveryManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSiteRecoveryManagementReplicationFabricsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SiteRecoveryManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_fabrics_list(self, resource_group):
        response = self.client.replication_fabrics.list(
            api_version="2025-01-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_fabrics_get(self, resource_group):
        response = self.client.replication_fabrics.get(
            fabric_name="str",
            api_version="2025-01-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_fabrics_begin_create(self, resource_group):
        response = self.client.replication_fabrics.begin_create(
            fabric_name="str",
            input={"properties": {"customDetails": "fabric_specific_creation_input"}},
            api_version="2025-01-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_fabrics_begin_purge(self, resource_group):
        response = self.client.replication_fabrics.begin_purge(
            fabric_name="str",
            api_version="2025-01-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_fabrics_begin_check_consistency(self, resource_group):
        response = self.client.replication_fabrics.begin_check_consistency(
            fabric_name="str",
            api_version="2025-01-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_fabrics_begin_migrate_to_aad(self, resource_group):
        response = self.client.replication_fabrics.begin_migrate_to_aad(
            fabric_name="str",
            api_version="2025-01-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_fabrics_begin_reassociate_gateway(self, resource_group):
        response = self.client.replication_fabrics.begin_reassociate_gateway(
            fabric_name="str",
            failover_process_server_request={
                "properties": {
                    "containerName": "str",
                    "sourceProcessServerId": "str",
                    "targetProcessServerId": "str",
                    "updateType": "str",
                    "vmsToMigrate": ["str"],
                }
            },
            api_version="2025-01-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_fabrics_begin_delete(self, resource_group):
        response = self.client.replication_fabrics.begin_delete(
            fabric_name="str",
            api_version="2025-01-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_fabrics_begin_renew_certificate(self, resource_group):
        response = self.client.replication_fabrics.begin_renew_certificate(
            fabric_name="str",
            renew_certificate={"properties": {"renewCertificateType": "str"}},
            api_version="2025-01-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_replication_fabrics_begin_remove_infra(self, resource_group):
        response = self.client.replication_fabrics.begin_remove_infra(
            resource_name="str",
            fabric_name="str",
            api_version="2025-01-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
