# get_call_entries / returns an empty string for packages with .Call entries and NAMESPACE files

    Code
      call_entries
    Output
      [1] "/* .Call calls */"                             
      [2] "extern SEXP bar(void);"                        
      [3] ""                                              
      [4] "static const R_CallMethodDef CallEntries[] = {"
      [5] "    {\"bar\", (DL_FUNC) &bar, 0},"             
      [6] "    {NULL, NULL, 0}"                           
      [7] "};"                                            

# get_call_entries / works with multiple register functions.

    Code
      cat(read_file(cpp_bindings))
    Output
      // Generated by cpp11: do not edit by hand
      // clang-format off
      
      
      #include "cpp11/declarations.hpp"
      #include <R_ext/Visibility.h>
      
      // multiple.cpp
      int foo();
      extern "C" SEXP _testPkg_foo() {
        BEGIN_CPP11
          return cpp11::as_sexp(foo());
        END_CPP11
      }
      // multiple.cpp
      double bar(bool run);
      extern "C" SEXP _testPkg_bar(SEXP run) {
        BEGIN_CPP11
          return cpp11::as_sexp(bar(cpp11::as_cpp<cpp11::decay_t<bool>>(run)));
        END_CPP11
      }
      // multiple.cpp
      bool baz(bool run, int value);
      extern "C" SEXP _testPkg_baz(SEXP run, SEXP value) {
        BEGIN_CPP11
          return cpp11::as_sexp(baz(cpp11::as_cpp<cpp11::decay_t<bool>>(run), cpp11::as_cpp<cpp11::decay_t<int>>(value)));
        END_CPP11
      }
      
      extern "C" {
      static const R_CallMethodDef CallEntries[] = {
          {"_testPkg_bar", (DL_FUNC) &_testPkg_bar, 1},
          {"_testPkg_baz", (DL_FUNC) &_testPkg_baz, 2},
          {"_testPkg_foo", (DL_FUNC) &_testPkg_foo, 0},
          {NULL, NULL, 0}
      };
      }
      
      extern "C" attribute_visible void R_init_testPkg(DllInfo* dll){
        R_registerRoutines(dll, NULL, CallEntries, NULL, NULL);
        R_useDynamicSymbols(dll, FALSE);
        R_forceSymbols(dll, TRUE);
      }

# cpp_register / works with a package that registers a single c++ function

    Code
      cat(read_file(r_bindings))
    Output
      # Generated by cpp11: do not edit by hand
      
      foo <- function() {
        .Call(`_testPkg_foo`)
      }

---

    Code
      cat(read_file(cpp_bindings))
    Output
      // Generated by cpp11: do not edit by hand
      // clang-format off
      
      
      #include "cpp11/declarations.hpp"
      #include <R_ext/Visibility.h>
      
      // single.cpp
      int foo();
      extern "C" SEXP _testPkg_foo() {
        BEGIN_CPP11
          return cpp11::as_sexp(foo());
        END_CPP11
      }
      
      extern "C" {
      static const R_CallMethodDef CallEntries[] = {
          {"_testPkg_foo", (DL_FUNC) &_testPkg_foo, 0},
          {NULL, NULL, 0}
      };
      }
      
      extern "C" attribute_visible void R_init_testPkg(DllInfo* dll){
        R_registerRoutines(dll, NULL, CallEntries, NULL, NULL);
        R_useDynamicSymbols(dll, FALSE);
        R_forceSymbols(dll, TRUE);
      }

# cpp_register / can be run with messages

    Code
      cpp_register(p, quiet = FALSE)
    Message
      i 1 functions decorated with [[cpp11::register]]
      v generated file 'cpp11.R'
      v generated file 'cpp11.cpp'

