% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ma.R
\name{Ma}
\alias{Ma}
\title{Moving average (MA) model}
\usage{
Ma(b)
}
\arguments{
\item{b}{moving average (MA) polynomial coefficients.}
}
\value{
A list of class \code{Ma} with the polynomial coefficients
}
\description{
Create an MA model representing a filter or system model
}
\examples{
f <- Ma(b = c(1, 2, 1) / 3)
freqz(f)
zplane(f)

}
\seealso{
See also \code{\link{Arma}}
}
\author{
Tom Short, \email{tshort@eprisolutions.com}
}
