% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RLum.Data.Image-class.R
\docType{class}
\name{RLum.Data.Image-class}
\alias{RLum.Data.Image-class}
\title{Class \code{"RLum.Data.Image"}}
\description{
Class for representing luminescence image data (TL/OSL/RF). Such data are
for example produced by function \link{read_SPE2R}.
}
\section{Slots}{

\describe{
\item{\code{recordType}}{Object of class \link{character} containing the type of the curve (e.g.
"OSL image", "TL image").}

\item{\code{curveType}}{Object of class \link{character} containing curve type, allowed values
are measured or predefined}

\item{\code{data}}{Object of class \link{array} containing image data.}

\item{\code{info}}{Object of class \link{list} containing further meta information objects}
}}

\note{
The class should only contain data for a set of images. For additional
elements the slot \code{info} can be used.
}
\section{Objects from the class}{

Objects can be created by calls of the form \code{set_RLum("RLum.Data.Image", ...)}.
}

\section{Class version}{
 0.5.1
}

\examples{

showClass("RLum.Data.Image")

##create empty RLum.Data.Image object
set_RLum(class = "RLum.Data.Image")

}
\seealso{
\linkS4class{RLum}, \linkS4class{RLum.Data}, \link{plot_RLum}, \link{read_SPE2R}, \link{read_TIFF2R}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team}
\keyword{classes}
