% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{user_cache_dir}
\alias{user_cache_dir}
\title{Path to user cache directory}
\usage{
user_cache_dir(
  appname = NULL,
  appauthor = appname,
  version = NULL,
  opinion = TRUE,
  expand = TRUE,
  os = NULL
)
}
\arguments{
\item{appname}{is the name of application. If NULL, just the system
directory is returned.}

\item{appauthor}{(only required and used on Windows) is the name of the
appauthor or distributing body for this application. Typically
it is the owning company name. This falls back to appname.}

\item{version}{is an optional version path element to append to the
path. You might want to use this if you want multiple versions
of your app to be able to run independently. If used, this
would typically be \code{"<major>.<minor>"}. Only applied when appname
is not NULL.}

\item{opinion}{(logical) Use \code{FALSE} to disable the appending of
\code{Cache} on Windows. See discussion below.}

\item{expand}{If TRUE (the default) will expand the \code{R_LIBS} specifiers with their equivalents.
See \code{\link[=R_LIBS]{R_LIBS()}} for list of all possibly specifiers.}

\item{os}{Operating system whose conventions are used to construct the
requested directory. Possible values are "win", "mac", "unix". If \code{NULL}
(the default) then the current OS will be used.}
}
\description{
This functions uses \code{R_USER_CACHE_DIR} if set. Otherwise, they follow
platform conventions. Typical user cache directories are:
\itemize{
\item Mac OS X: \verb{~/Library/Caches/<AppName>}
\item Linux: \verb{~/.cache/<AppName>}
\item Win XP: \verb{C:\\\\Documents and Settings\\\\<username>\\\\Local Settings\\\\Application Data\\\\<AppAuthor>\\\\<AppName>\\\\Cache}
\item Vista: \verb{C:\\\\Users\\\\<username>\\\\AppData\\\\Local\\\\<AppAuthor>\\\\<AppName>\\\\Cache}
}
}
\section{Opinion}{

On Windows the only suggestion in the MSDN docs is that local settings go
in the \code{CSIDL_LOCAL_APPDATA} directory. This is identical to the
non-roaming app data dir (i.e. \code{\link[=user_data_dir]{user_data_dir()}}). But apps typically put
cache data somewhere \emph{under} this directory so \code{user_cache_dir()} appends
\code{Cache} to the \code{CSIDL_LOCAL_APPDATA} value, unless \code{opinion = FALSE}.
}

\examples{
user_cache_dir("rappdirs")
}
\seealso{
\code{\link[=tempdir]{tempdir()}} for a non-persistent temporary directory.
}
