### Bug fixes

* [#13676](https://github.com/rubocop/rubocop/issues/13676): Allow RuboCop to inspect hidden directories if they are explicitly provided. ([@viralpraxis][])
* [#14080](https://github.com/rubocop/rubocop/pull/14080): Allow writing RBS::Inline annotation `#:` after end keyword in `Style/CommentedKeyword`. ([@dak2][])
* [#14075](https://github.com/rubocop/rubocop/issues/14075): Fix an error for `Layout/EmptyLineAfterGuardClause` when calling a method on the result of a single-line `if` with `return`. ([@koic][])
* [#14067](https://github.com/rubocop/rubocop/pull/14067): Fix false negatives for `Style/RedundantParentheses` when using parens around singleton method body. ([@koic][])
* [#14070](https://github.com/rubocop/rubocop/issues/14070): Fix false positives for `EnforcedStyleForMultiline: diff_comma` of `Style/TrailingCommaInArrayLiteral` and `Style/TrailingCommaInHashLiteral` when trailing comma with comment. ([@koic][])
* [#14092](https://github.com/rubocop/rubocop/pull/14092): Fix false negative for `Style/RedundantParentheses` when using some operator methods with a parenthesized argument. ([@koic][])
* [#14103](https://github.com/rubocop/rubocop/pull/14103): Fix `Layout/MultilineOperationIndentation` cop error on `indexasgn` node without arguments. ([@viralpraxis][])
* [#14089](https://github.com/rubocop/rubocop/pull/14089): Fix redundant current directory prefix regexp. ([@sferik][])
* [#14099](https://github.com/rubocop/rubocop/pull/14099): Fix `Style/ClassAndModuleChildren` cop error on one-liner class definition and nested enforced style. ([@viralpraxis][])
* [#14083](https://github.com/rubocop/rubocop/pull/14083): Fix `Style/ConditionalAssignment` cop error on one-line if-then-else. ([@viralpraxis][])
* [#14104](https://github.com/rubocop/rubocop/pull/14104): Fix `Style/ConditionalAssignment` cop error on indexed assignment without arguments. ([@viralpraxis][])
* [#14084](https://github.com/rubocop/rubocop/pull/14084): Fix `Style/RedundantLineContinuation` cop error on multiline assignment with line continuation. ([@viralpraxis][])
* [#14096](https://github.com/rubocop/rubocop/pull/14096): Fix error for `Style/SafeNavigation` with longer `&&` chain (e.g. `a && a.b && a.b.c`). ([@lovro-bikic][])
* [#14068](https://github.com/rubocop/rubocop/pull/14068): Fix wrong autocorrection for `Style/MapIntoArray` when using `push` or `append` with hash argument without braces. ([@lovro-bikic][])

### Changes

* [#14093](https://github.com/rubocop/rubocop/pull/14093): Register offenses for redundant parens around method arguments for `Style/RedundantParentheses`. ([@lovro-bikic][])
* [#14064](https://github.com/rubocop/rubocop/pull/14064): Prefer `References` over `Reference` in cop configs. ([@sambostock][])

[@viralpraxis]: https://github.com/viralpraxis
[@dak2]: https://github.com/dak2
[@koic]: https://github.com/koic
[@sferik]: https://github.com/sferik
[@lovro-bikic]: https://github.com/lovro-bikic
[@sambostock]: https://github.com/sambostock
