---
title: Strawberry Django docs
---

# Strawberry Django docs

## Getting Started

- [Quick Start](./index.md)

## Core Concepts

- [Types](./guide/types.md)
- [Fields](./guide/fields.md)
- [Queries](./guide/queries.md)
- [Mutations](./guide/mutations.md)
- [Subscriptions](./guide/subscriptions.md)
- [Views](./guide/views.md)

## Data Management

- [Filters](./guide/filters.md)
- [Ordering](./guide/ordering.md)
- [Legacy Ordering](./guide/legacy-ordering.md)
- [Pagination](./guide/pagination.md)
- [Relay](./guide/relay.md)

## Advanced Features

- [Query Optimizer](./guide/optimizer.md)
- [Performance](./guide/performance.md)
- [DataLoaders](./guide/dataloaders.md)
- [Model Properties](./guide/model-properties.md)
- [Nested Mutations](./guide/nested-mutations.md)
- [Resolvers](./guide/resolvers.md)

## Security & Validation

- [Permissions](./guide/permissions.md)
- [Authentication](./guide/authentication.md)
- [Validation](./guide/validation.md)
- [Error Handling](./guide/error-handling.md)

## Development & Testing

- [Unit Testing](./guide/unit-testing.md)
- [Export Schema](./guide/export-schema.md)
- [Settings](./guide/settings.md)
- [Troubleshooting](./guide/troubleshooting.md)

## Integrations

- [Federation](./integrations/federation.md)
- [Channels](./integrations/channels.md)
- [Choices Field](./integrations/choices-field.md)
- [Debug Toolbar](./integrations/debug-toolbar.md)
- [Django Guardian](./integrations/guardian.md)
- [GeoDjango](./integrations/geodjango.md)

## Resources

- [FAQ](./faq.md)
- [Community Projects](./community-projects.md)
