---
myst:
  html_meta:
    keywords: LaTeX, programmation, commandes, macros, redéfinition
---
# Comment enrichir la définition d'une commande déjà existante ?

## Avec les commandes de base (de TeX)

On peut ajouter des commandes dans la définition d'une macro en combinant l'utilisation de `\let` et `\def`. Par exemple :

```{noedit}
%% Incorrect : LaTeX entre dans une boucle
\def\LaTeX{\LaTeX\xspace}
%% Correct :
\let\oldLaTeX\LaTeX
\def\LaTeX{\oldLaTeX\xspace}
```

## Avec l'extension <ctanpkg:babel>

L'extension <ctanpkg:babel> fournit une commande nommée `\addto`, qui ajoute son deuxième argument à la fin de la commande passée en premier argument.

Par exemple :

```{noedit}
\addto{\LaTeX}{\xspace}
```
