/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.tools;

import java.awt.event.MouseEvent;
import rene.zirkel.Zirkel;
import rene.zirkel.ZirkelCanvas;
import rene.zirkel.construction.Selector;
import rene.zirkel.constructors.ObjectConstructor;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.InsideObject;
import rene.zirkel.objects.PointObject;
import rene.zirkel.objects.PointonObject;

public class BinderTool
extends ObjectConstructor
implements Selector {
    ObjectConstructor OC;
    PointObject P;
    boolean Control;

    public BinderTool(ZirkelCanvas zirkelCanvas, PointObject pointObject, ObjectConstructor objectConstructor) {
        this.P = pointObject;
        this.OC = objectConstructor;
        this.P.setSelected(true);
        zirkelCanvas.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas) {
        this.Control = mouseEvent.isControlDown();
        ConstructionObject constructionObject = zirkelCanvas.selectWithSelector(mouseEvent.getX(), mouseEvent.getY(), this);
        if (constructionObject == null) {
            return;
        }
        if (this.Control && !(constructionObject instanceof InsideObject)) {
            return;
        }
        if (zirkelCanvas.getConstruction().dependsOn(constructionObject, this.P)) {
            return;
        }
        this.P.setBound(constructionObject.getName());
        if (constructionObject instanceof InsideObject) {
            if (this.Control || !(constructionObject instanceof PointonObject)) {
                this.P.setInside(true);
            }
        } else {
            this.P.setUseAlpha(!mouseEvent.isShiftDown());
        }
        zirkelCanvas.getConstruction().updateCircleDep();
        zirkelCanvas.repaint();
        this.reset(zirkelCanvas);
    }

    public void mouseMoved(MouseEvent mouseEvent, ZirkelCanvas zirkelCanvas, boolean bl) {
        this.Control = mouseEvent.isControlDown();
        zirkelCanvas.indicateWithSelector(mouseEvent.getX(), mouseEvent.getY(), this);
    }

    public boolean isAdmissible(ZirkelCanvas zirkelCanvas, ConstructionObject constructionObject) {
        return (constructionObject instanceof InsideObject || constructionObject instanceof PointonObject) && !zirkelCanvas.getConstruction().dependsOn(constructionObject, this.P);
    }

    public void showStatus(ZirkelCanvas zirkelCanvas) {
        zirkelCanvas.showStatus(Zirkel.name("message.bindpoint"));
    }

    public void reset(ZirkelCanvas zirkelCanvas) {
        super.reset(zirkelCanvas);
        zirkelCanvas.setTool(this.OC);
        zirkelCanvas.validate();
        zirkelCanvas.repaint();
    }

    public boolean useSmartBoard() {
        return false;
    }
}

