#!/usr/bin/env python
#
# This file is part of pacman-mirrors.
#
# pacman-mirrors is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# pacman-mirrors is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with pacman-mirrors.  If not, see <http://www.gnu.org/licenses/>.
#
# Authors: Frede Hundewadt <echo ZmhAbWFuamFyby5vcmcK | base64 -d>

"""Pacman-Mirrors Output Functions"""

from pacman_mirrors.constants import txt
from pacman_mirrors.functions import customFn
from pacman_mirrors.functions import defaultFn
from pacman_mirrors.functions import fileFn
from pacman_mirrors.functions import jsonFn
from pacman_mirrors.functions import util


def write_static_mirror_pool(self, selected_mirrors: list) -> None:
    """
    Output enterprise setup to mirror file
    :param self:
    :param selected_mirrors:
    :return:
    """
    jsonFn.write_json_file(data=selected_mirrors, filename=self.config["mirror_file"])


def write_custom_mirrors_json(self, selected_mirrors: list) -> None:
    """
    Output selected mirrors to custom mirror file
    :param self:
    :param selected_mirrors:
    :return:
    """
    util.msg(message=f"{txt.CUSTOM_MIRROR_LIST}", urgency=txt.INF_CLR, tty=self.tty)
    util.msg(
        message="------------------------------------------------------------",
        tty=self.tty,
    )
    jsonFn.write_json_file(data=selected_mirrors, filename=self.config["custom_file"])
    util.msg(
        message=f'{txt.CUSTOM_MIRROR_FILE_SAVED}: {self.config["custom_file"]}',
        urgency=txt.INF_CLR,
        tty=self.tty,
    )


def write_pacman_mirror_list(self, selected_servers) -> None:
    """
    Outputs selected servers to mirrorlist
    :param self:
    :param selected_servers:
    """
    if self.custom:
        fileFn.write_mirror_list(
            config=self.config,
            servers=selected_servers,
            tty=self.tty,
            custom=self.custom,
            quiet=self.quiet,
            interactive=True,
        )
    else:
        fileFn.write_mirror_list(
            config=self.config, servers=selected_servers, tty=self.tty, quiet=self.quiet
        )


def tty_custom_pool(self) -> None:
    """
    List available countries from custom pool
    """
    customFn.load_custom_pool(self)
    print("{}".format("\n".join(self.mirrors.country_pool)))


def tty_default_pool(self) -> None:
    """
    List all available countries
    """
    defaultFn.load_default_mirror_pool(self)
    print("{}".format("\n".join(self.mirrors.country_pool)))
