/**
 * ./src/classes/settings.ts
 * penguins-eggs v.25.7.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import { IApp, IDistro, IRemix, IWorkDir } from '../interfaces/index.js';
import { IEggsConfig } from '../interfaces/index.js';
import Incubator from './incubation/incubator.js';
/**
 * Setting
 */
export default class Settings {
    app: IApp;
    config: IEggsConfig;
    distro: IDistro;
    efi_work: string;
    i686: boolean;
    incubator: Incubator;
    initrd_image: string;
    initrdImg: string;
    isLive: boolean;
    iso_work: string;
    isoFilename: string;
    kernel_image: string;
    remix: IRemix;
    session_excludes: string;
    vmlinuz: string;
    work_dir: IWorkDir;
    constructor(compression?: string);
    /**
     * Calculate and show free space on the disk
     * @returns {void}
     */
    listFreeSpace(): Promise<void>;
    /**
     * Load configuration from config_file
     * @returns {boolean} Success
     */
    load(): Promise<boolean>;
    /**
     *
     * @param basename
     * @param theme
     */
    loadRemix(theme?: string): Promise<void>;
    /**
     *
     * @param config
     */
    save(config: IEggsConfig): Promise<void>;
}
