/**
 * ./src/classes/diversions.ts
 * penguins-eggs v.26.1.x / ecmascript 2020
 * author: Piero Proietti (modified by Hossein Seilani)
 * license: MIT
 */
import { IDistro } from '../interfaces/index.js';
export default class Diversions {
    /**
     * bootloaders
     * return pathBootloaders
     */
    static bootloaders(familyId: string): string;
    /**
     * deluser
     * return userdel/deluser
     */
    static deluser(familyId: string): string;
    static distro(): IDistro;
    /**
     *
     * grubForce
     * return --force/empty
     */
    static grubForce(familyId: string): string;
    /**
     *
     * grubName
     * return: grub2/grub
     */
    static grubName(familyId: string): string;
    /**
     * isManjaroBased
     * returns true if Manjaro/Biglinux/Bigcommunity
     */
    static isManjaroBased(distro: string): boolean;
    /**
     * isSystemDBoot
     * return true if use systemd-boot
     */
    static isSystemDBoot(familyId: string, isEfi: boolean): boolean;
    /**
     * kernelParameters
     * return kernelParameters
     */
    static kernelParameters(familyId: string, volid: string, fullCrypt?: boolean): string;
}
