/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model.plan;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.model.plan.MySQLPlanAbstract;
import org.jkiss.dbeaver.ext.mysql.model.plan.MySQLPlanClassic;
import org.jkiss.dbeaver.ext.mysql.model.plan.MySQLPlanJSON;
import org.jkiss.dbeaver.ext.mysql.model.plan.MySQLPlanNodeJSON;
import org.jkiss.dbeaver.ext.mysql.model.plan.MySQLPlanNodePlain;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.plan.DBCPlan;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNode;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanStyle;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlannerConfiguration;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlannerSerialInfo;
import org.jkiss.dbeaver.model.impl.plan.AbstractExecutionPlanSerializer;
import org.jkiss.dbeaver.model.impl.plan.ExecutionPlanDeserializer;
import org.jkiss.utils.CommonUtils;

public class MySQLPlanAnalyser
extends AbstractExecutionPlanSerializer
implements DBCQueryPlanner {
    private MySQLDataSource dataSource;

    public MySQLPlanAnalyser(MySQLDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public MySQLPlanAbstract explain(JDBCSession session, String query) throws DBCException {
        if (this.supportsExplainJSON()) {
            return new MySQLPlanJSON(session, query);
        }
        return new MySQLPlanClassic(session, query);
    }

    private boolean supportsExplainJSON() {
        if (this.dataSource.isMariaDB()) {
            return this.dataSource.isServerVersionAtLeast(10, 1);
        }
        return this.dataSource.isServerVersionAtLeast(5, 6);
    }

    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    @NotNull
    public DBCPlan planQueryExecution(@NotNull DBCSession session, @NotNull String query, @NotNull DBCQueryPlannerConfiguration configuration) throws DBCException {
        return this.explain((JDBCSession)session, query);
    }

    @NotNull
    public DBCPlanStyle getPlanStyle() {
        return DBCPlanStyle.PLAN;
    }

    public void serialize(@NotNull Writer writer, final @NotNull DBCPlan plan) throws IOException, InvocationTargetException {
        this.serializeJson(writer, plan, this.dataSource.getInfo().getDriverName(), new DBCQueryPlannerSerialInfo(){

            public String version() {
                return plan instanceof MySQLPlanClassic ? "classic" : "json";
            }

            public void addNodeProperties(DBCPlanNode node, JsonObject nodeJson) {
                JsonObject attributes = new JsonObject();
                if (node instanceof MySQLPlanNodePlain) {
                    MySQLPlanNodePlain plainNode = (MySQLPlanNodePlain)node;
                    attributes.add("id", (JsonElement)new JsonPrimitive((Number)plainNode.getId()));
                    attributes.add("select_type", (JsonElement)new JsonPrimitive(CommonUtils.notEmpty((String)plainNode.getSelectType())));
                    attributes.add("table", (JsonElement)new JsonPrimitive(CommonUtils.notEmpty((String)plainNode.getTable())));
                    attributes.add("type", (JsonElement)new JsonPrimitive(CommonUtils.notEmpty((String)plainNode.getNodeType())));
                    attributes.add("possible_keys", (JsonElement)new JsonPrimitive(CommonUtils.notEmpty((String)plainNode.getPossibleKeys())));
                    attributes.add("key", (JsonElement)new JsonPrimitive(CommonUtils.notEmpty((String)plainNode.getKey())));
                    attributes.add("key_len", (JsonElement)new JsonPrimitive(CommonUtils.notEmpty((String)plainNode.getKeyLength())));
                    attributes.add("ref", (JsonElement)new JsonPrimitive(CommonUtils.notEmpty((String)plainNode.getRef())));
                    attributes.add("rows", (JsonElement)new JsonPrimitive((Number)plainNode.getRowCount()));
                    attributes.add("filtered", (JsonElement)new JsonPrimitive((Number)plainNode.getFiltered()));
                    attributes.add("extra", (JsonElement)new JsonPrimitive(CommonUtils.notEmpty((String)plainNode.getExtra())));
                } else if (node instanceof MySQLPlanNodeJSON) {
                    MySQLPlanNodeJSON jsNode = (MySQLPlanNodeJSON)node;
                    for (Map.Entry<String, Object> e : jsNode.getNodeProps().entrySet()) {
                        Object value = e.getValue();
                        if (value instanceof Double) {
                            attributes.add(e.getKey(), (JsonElement)new JsonPrimitive((Number)((Double)value)));
                            continue;
                        }
                        attributes.add(e.getKey(), (JsonElement)new JsonPrimitive(value.toString()));
                    }
                }
                nodeJson.add("attributes", (JsonElement)attributes);
            }
        });
    }

    public DBCPlan deserialize(@NotNull Reader planData) throws IOException, InvocationTargetException {
        JsonObject jo = new JsonParser().parse(planData).getAsJsonObject();
        String savedVersion = this.getVersion(jo);
        String query = this.getQuery(jo);
        if (savedVersion.equals("classic")) {
            ExecutionPlanDeserializer loader = new ExecutionPlanDeserializer();
            List rootNodes = loader.loadRoot((DBPDataSource)this.dataSource, jo, (datasource, node, parent) -> new MySQLPlanNodePlain((MySQLPlanNodePlain)parent, this.getNodeAttributes(node)));
            return new MySQLPlanClassic(this.dataSource, query, rootNodes);
        }
        ExecutionPlanDeserializer loader = new ExecutionPlanDeserializer();
        List rootNodes = loader.loadRoot((DBPDataSource)this.dataSource, jo, (datasource, node, parent) -> new MySQLPlanNodeJSON((MySQLPlanNodeJSON)parent, this.getNodeAttributes(node)));
        return new MySQLPlanJSON(this.dataSource, query, rootNodes);
    }
}

