/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.ui;

import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.SwingUtilities;
import org.freeplane.core.ui.components.UITools;

public class MovedMouseEventFilter
extends WindowAdapter {
    private Window trackedWindow = null;
    private Point mousePositionAfterFocusGained = null;

    public boolean isRelevant(MouseEvent e) {
        boolean hasMoved;
        if (this.mousePositionAfterFocusGained == null) {
            return true;
        }
        Component component = e.getComponent();
        Window windowToTrack = SwingUtilities.getWindowAncestor(component);
        if (!windowToTrack.equals(this.trackedWindow)) {
            return true;
        }
        Point eventPoint = e.getPoint();
        UITools.convertPointToAncestor(component, eventPoint, this.trackedWindow);
        boolean bl = hasMoved = !eventPoint.equals(this.mousePositionAfterFocusGained);
        if (hasMoved) {
            this.mousePositionAfterFocusGained = null;
        }
        return hasMoved;
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        try {
            this.mousePositionAfterFocusGained = this.trackedWindow.getMousePosition();
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            // empty catch block
        }
    }

    public void trackWindowForComponent(Component c) {
        Window windowToTrack = SwingUtilities.getWindowAncestor(c);
        if (windowToTrack.equals(this.trackedWindow)) {
            return;
        }
        if (this.trackedWindow != null) {
            this.trackedWindow.removeWindowFocusListener(this);
        }
        this.trackedWindow = windowToTrack;
        this.trackedWindow.addWindowFocusListener(this);
        this.mousePositionAfterFocusGained = null;
    }
}

