/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.bridge.CSSFontFace;
import io.sf.carte.echosvg.bridge.FontFace;
import io.sf.carte.echosvg.bridge.FontFamilyResolver;
import io.sf.carte.echosvg.gvt.font.AWTFontFamily;
import io.sf.carte.echosvg.gvt.font.AWTGVTFont;
import io.sf.carte.echosvg.gvt.font.GVTFontFace;
import io.sf.carte.echosvg.gvt.font.GVTFontFamily;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public final class DefaultFontFamilyResolver
implements FontFamilyResolver {
    public static final DefaultFontFamilyResolver SINGLETON;
    private static final AWTFontFamily DEFAULT_FONT_FAMILY;
    protected static final Map<String, String> fonts;
    protected static final List<AWTFontFamily> awtFontFamilies;
    protected static final List<AWTGVTFont> awtFonts;
    protected static final Map<String, GVTFontFamily> resolvedFontFamilies;

    private DefaultFontFamilyResolver() {
    }

    public static DefaultFontFamilyResolver getInstance() {
        return SINGLETON;
    }

    public void registerFont(Font font) {
        String string = font.getFontName();
        String string2 = string.toLowerCase();
        fonts.putIfAbsent(string2, string);
        String string3 = font.getFamily();
        String string4 = string3.toLowerCase();
        if (!fonts.containsKey(string4)) {
            Object object;
            fonts.put(string4, string3);
            StringTokenizer stringTokenizer = new StringTokenizer(string4);
            StringBuilder stringBuilder = new StringBuilder(string4.length());
            while (stringTokenizer.hasMoreTokens()) {
                stringBuilder.append(stringTokenizer.nextToken());
            }
            if (stringBuilder.length() != string4.length()) {
                fonts.put(stringBuilder.toString(), string3);
                object = string4.replace(' ', '-');
                fonts.put((String)object, string3);
            }
            object = new AWTFontFamily(string3);
            awtFontFamilies.add((AWTFontFamily)object);
            AWTGVTFont aWTGVTFont = new AWTGVTFont(string3, 0, 12);
            awtFonts.add(aWTGVTFont);
        }
    }

    public AWTFontFamily resolve(String string, FontFace fontFace) {
        String string2 = fonts.get(fontFace.getFamilyName().toLowerCase());
        if (string2 == null) {
            return null;
        }
        CSSFontFace cSSFontFace = FontFace.createFontFace(string2, fontFace);
        return new AWTFontFamily((GVTFontFace)cSSFontFace);
    }

    @Override
    public GVTFontFamily loadFont(InputStream inputStream, FontFace fontFace) throws Exception {
        Font font = Font.createFont(0, inputStream);
        return new AWTFontFamily((GVTFontFace)fontFace, font);
    }

    @Override
    public GVTFontFamily resolve(String string) {
        GVTFontFamily gVTFontFamily = resolvedFontFamilies.get(string = string.toLowerCase());
        if (gVTFontFamily == null) {
            String string2 = fonts.get(string);
            if (string2 != null) {
                gVTFontFamily = new AWTFontFamily(string2);
            }
            resolvedFontFamilies.put(string, gVTFontFamily);
        }
        return gVTFontFamily;
    }

    @Override
    public GVTFontFamily getFamilyThatCanDisplay(char c) {
        for (int i = 0; i < awtFontFamilies.size(); ++i) {
            AWTFontFamily aWTFontFamily = awtFontFamilies.get(i);
            AWTGVTFont aWTGVTFont = awtFonts.get(i);
            if (!aWTGVTFont.canDisplay(c) || aWTFontFamily.getFamilyName().indexOf("Song") != -1) continue;
            return aWTFontFamily;
        }
        return null;
    }

    @Override
    public GVTFontFamily getDefault() {
        return DEFAULT_FONT_FAMILY;
    }

    static {
        Object object2;
        SINGLETON = new DefaultFontFamilyResolver();
        DEFAULT_FONT_FAMILY = new AWTFontFamily("SansSerif");
        fonts = new HashMap<String, String>();
        awtFontFamilies = new ArrayList<AWTFontFamily>();
        awtFonts = new ArrayList<AWTGVTFont>();
        fonts.put("sans-serif", "SansSerif");
        fonts.put("serif", "Serif");
        fonts.put("times", "Serif");
        fonts.put("times new roman", "Serif");
        fonts.put("cursive", "Dialog");
        fonts.put("fantasy", "Symbol");
        fonts.put("monospace", "Monospaced");
        fonts.put("monospaced", "Monospaced");
        fonts.put("courier", "Monospaced");
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        int n = stringArray != null ? stringArray.length : 0;
        for (int i = 0; i < n; ++i) {
            object2 = stringArray[i].toLowerCase();
            fonts.put((String)object2, stringArray[i]);
            StringTokenizer stringTokenizer = new StringTokenizer((String)object2);
            StringBuilder stringBuilder = new StringBuilder(((String)object2).length());
            while (stringTokenizer.hasMoreTokens()) {
                stringBuilder.append(stringTokenizer.nextToken());
            }
            if (stringBuilder.length() == ((String)object2).length()) continue;
            fonts.put(stringBuilder.toString(), stringArray[i]);
            String object3 = ((String)object2).replace(' ', '-');
            fonts.put(object3, stringArray[i]);
        }
        Font[] fontArray = graphicsEnvironment.getAllFonts();
        for (Font font : fontArray) {
            fonts.put(font.getFontName().toLowerCase(), font.getFontName());
        }
        awtFontFamilies.add(DEFAULT_FONT_FAMILY);
        awtFonts.add(new AWTGVTFont(DEFAULT_FONT_FAMILY.getFamilyName(), 0, 12));
        object2 = fonts.values();
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            AWTFontFamily aWTFontFamily = new AWTFontFamily(string);
            awtFontFamilies.add(aWTFontFamily);
            AWTGVTFont aWTGVTFont = new AWTGVTFont(string, 0, 12);
            awtFonts.add(aWTGVTFont);
        }
        resolvedFontFamilies = new HashMap<String, GVTFontFamily>();
    }
}

