/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt;

import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.util.Rectangle;
import com.jogamp.nativewindow.util.RectangleImmutable;
import com.jogamp.newt.Display;
import com.jogamp.newt.MonitorDevice;
import com.jogamp.newt.MonitorMode;
import com.jogamp.newt.event.MonitorModeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jogamp.newt.Debug;

public abstract class Screen {
    public static final int SCREEN_MODE_CHANGE_TIMEOUT = 10000;
    public static final boolean DEBUG = Debug.debug("Screen");
    protected static final ArrayList<WeakReference<Screen>> screenList = new ArrayList();
    protected static int screensActive = 0;

    public abstract int hashCode();

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Screen) {
            Screen screen = (Screen)object;
            return screen.getFQName().equals(this.getFQName());
        }
        return false;
    }

    public abstract void createNative() throws NativeWindowException;

    public abstract void destroy();

    public abstract boolean isNativeValid();

    public abstract int getReferenceCount();

    public abstract int addReference() throws NativeWindowException;

    public abstract int removeReference();

    public abstract AbstractGraphicsScreen getGraphicsScreen();

    public abstract int getIndex();

    public abstract int getX();

    public abstract int getY();

    public abstract int getWidth();

    public abstract int getHeight();

    public abstract RectangleImmutable getViewport();

    public abstract RectangleImmutable getViewportInWindowUnits();

    public abstract Display getDisplay();

    public abstract String getFQName();

    public abstract List<MonitorMode> getMonitorModes();

    public abstract List<MonitorDevice> getMonitorDevices();

    public abstract MonitorDevice getPrimaryMonitor();

    public final MonitorDevice getMainMonitor(RectangleImmutable rectangleImmutable) {
        MonitorDevice monitorDevice = null;
        float f = Float.MIN_VALUE;
        List<MonitorDevice> list = this.getMonitorDevices();
        for (MonitorDevice monitorDevice2 : list) {
            float f2;
            if (monitorDevice2.isClone() || !((f2 = monitorDevice2.getViewportInWindowUnits().coverage(rectangleImmutable)) > f)) continue;
            f = f2;
            monitorDevice = monitorDevice2;
        }
        if (f > 0.0f && null != monitorDevice) {
            return monitorDevice;
        }
        return list.get(0);
    }

    public final MonitorDevice getFullyEnteredMonitor(RectangleImmutable rectangleImmutable) {
        for (MonitorDevice monitorDevice : this.getMonitorDevices()) {
            if (monitorDevice.isClone() || !monitorDevice.getViewportInWindowUnits().contains(rectangleImmutable)) continue;
            return monitorDevice;
        }
        return null;
    }

    public final MonitorDevice getMonitorById(int n) {
        for (MonitorDevice monitorDevice : this.getMonitorDevices()) {
            if (monitorDevice.getId() != n) continue;
            return monitorDevice;
        }
        return null;
    }

    public final MonitorDevice getMonitorByHandle(long l) {
        for (MonitorDevice monitorDevice : this.getMonitorDevices()) {
            if (monitorDevice.getHandle() != l) continue;
            return monitorDevice;
        }
        return null;
    }

    public final MonitorDevice getMonitorByName(String string) {
        if (null == string || string.isEmpty()) {
            return null;
        }
        for (MonitorDevice monitorDevice : this.getMonitorDevices()) {
            if (!string.equals(monitorDevice.getName())) continue;
            return monitorDevice;
        }
        return null;
    }

    public final void unionOfMonitorViewports(Rectangle rectangle, Rectangle rectangle2) {
        MonitorDevice.unionOfViewports(rectangle, rectangle2, this.getMonitorDevices());
    }

    public abstract void addMonitorModeListener(MonitorModeListener var1);

    public abstract void removeMonitorModeListener(MonitorModeListener var1);

    public static Screen getFirstScreenOf(Display display, int n, int n2) {
        return Screen.getScreenOfImpl(display, n, n2, 1);
    }

    public static Screen getLastScreenOf(Display display, int n, int n2) {
        return Screen.getScreenOfImpl(display, n, n2, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Screen getScreenOfImpl(Display display, int n, int n2, int n3) {
        ArrayList<WeakReference<Screen>> arrayList = screenList;
        synchronized (arrayList) {
            int n4;
            int n5 = n4 = n2 >= 0 ? n2 : screenList.size() - 1;
            while (n3 > 0 ? n4 < screenList.size() : n4 >= 0) {
                Screen screen = (Screen)screenList.get(n4).get();
                if (null == screen) {
                    screenList.remove(n4);
                    if (n3 >= 0) continue;
                    n4 += n3;
                    continue;
                }
                if (screen.getDisplay().equals(display) && screen.getIndex() == n) {
                    return screen;
                }
                n4 += n3;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addScreen2List(Screen screen) {
        ArrayList<WeakReference<Screen>> arrayList = screenList;
        synchronized (arrayList) {
            int n = 0;
            while (n < screenList.size()) {
                if (null == screenList.get(n).get()) {
                    screenList.remove(n);
                    continue;
                }
                ++n;
            }
            screenList.add(new WeakReference<Screen>(screen));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Screen> getAllScreens() {
        ArrayList<Screen> arrayList;
        ArrayList<WeakReference<Screen>> arrayList2 = screenList;
        synchronized (arrayList2) {
            arrayList = new ArrayList<Screen>();
            int n = 0;
            while (n < screenList.size()) {
                Screen screen = (Screen)screenList.get(n).get();
                if (null == screen) {
                    screenList.remove(n);
                    continue;
                }
                arrayList.add((Screen)screenList.get(n).get());
                ++n;
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getActiveScreenNumber() {
        ArrayList<WeakReference<Screen>> arrayList = screenList;
        synchronized (arrayList) {
            return screensActive;
        }
    }
}

