/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.DeclarationFormattingContext;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandBuilder;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueList;
import io.sf.carte.util.BufferSimpleWriter;
import java.util.Iterator;
import java.util.Set;

class GridShorthandBuilder
extends ShorthandBuilder {
    GridShorthandBuilder(BaseCSSStyleDeclaration baseCSSStyleDeclaration) {
        super("grid", baseCSSStyleDeclaration);
    }

    @Override
    protected int getMinimumSetSize() {
        return 3;
    }

    @Override
    int appendShorthandSet(StringBuilder stringBuilder, Set<String> set, boolean bl) {
        if (this.hasPropertiesToExclude(set)) {
            return 1;
        }
        BaseCSSStyleDeclaration baseCSSStyleDeclaration = this.getParentStyle();
        if (!(baseCSSStyleDeclaration.isPropertySet("grid-template-rows") && baseCSSStyleDeclaration.isPropertySet("grid-template-columns") && baseCSSStyleDeclaration.isPropertySet("grid-template-areas"))) {
            return 1;
        }
        if (baseCSSStyleDeclaration.isPropertySet("grid-auto-rows") && baseCSSStyleDeclaration.isPropertySet("grid-auto-columns") && baseCSSStyleDeclaration.isPropertySet("grid-auto-flow")) {
            return new FullGridShorthandBuilder(baseCSSStyleDeclaration).appendShorthandSet(stringBuilder, set, bl);
        }
        return new GridTemplateShorthandBuilder(baseCSSStyleDeclaration).appendShorthandSet(stringBuilder, set, bl);
    }

    @Override
    protected boolean isNotInitialValue(StyleValue styleValue, String string) {
        return styleValue != null && !this.isEffectiveInitialKeyword(styleValue) && !this.valueEquals(this.getInitialPropertyValue(string), styleValue);
    }

    private void appendValueText(StringBuilder stringBuilder, StyleValue styleValue) {
        stringBuilder.append(styleValue.getMinifiedCssText(this.getShorthandName()));
    }

    private boolean isIdentifier(StyleValue styleValue) {
        return styleValue.getPrimitiveType() == CSSValue.Type.IDENT;
    }

    private boolean isIdentifier(StyleValue styleValue, String string) {
        return this.isIdentifier(styleValue) && string.equalsIgnoreCase(((CSSTypedValue)((Object)styleValue)).getStringValue());
    }

    private class FullGridShorthandBuilder
    extends GridShorthandBuilder {
        FullGridShorthandBuilder(BaseCSSStyleDeclaration baseCSSStyleDeclaration) {
            super(baseCSSStyleDeclaration);
        }

        @Override
        int appendShorthandSet(StringBuilder stringBuilder, Set<String> set, boolean bl) {
            stringBuilder.append(this.getShorthandName()).append(':');
            byte by = this.checkValuesForInherit(set);
            if (by == 1) {
                stringBuilder.append("inherit");
                this.appendPriority(stringBuilder, bl);
                return 0;
            }
            if (by == 2) {
                return 1;
            }
            by = this.checkValuesForType(CSSValue.Type.REVERT, set);
            if (by == 1) {
                stringBuilder.append("revert");
                this.appendPriority(stringBuilder, bl);
                return 0;
            }
            if (by == 2) {
                return 1;
            }
            if (this.checkValuesForType(CSSValue.Type.INTERNAL, set) != 0) {
                return 1;
            }
            String[] stringArray = this.getLonghandProperties();
            for (String string : stringArray) {
                StyleValue styleValue = this.getCSSValue(string);
                if (styleValue.getCssValueType() != CSSValue.CssType.LIST || !((ValueList)styleValue).isCommaSeparated()) continue;
                return 1;
            }
            GridValues gridValues = new GridValues(set);
            if (gridValues.isNoneValue()) {
                stringBuilder.append("none");
                this.appendPriority(stringBuilder, bl);
                return 0;
            }
            if (gridValues.defaultGridTAreas) {
                if (!gridValues.rowAFlow && gridValues.defaultGridARows && gridValues.defaultGridTColumns) {
                    if (gridValues.gridColumnAutoFlowSyntax(stringBuilder, set)) {
                        this.appendPriority(stringBuilder, bl);
                        return 0;
                    }
                } else if (gridValues.rowAFlow && gridValues.defaultGridAColumns && gridValues.defaultGridTRows && (!gridValues.defaultGridARows || gridValues.isAutoflowDense()) && gridValues.gridRowAutoFlowSyntax(stringBuilder, set)) {
                    this.appendPriority(stringBuilder, bl);
                    return 0;
                }
            } else if (!gridValues.defaultGridTAreas && gridValues.lacksRepeatInGridTRows && gridValues.gridAreasSyntax(stringBuilder, set)) {
                this.appendPriority(stringBuilder, bl);
                return 0;
            }
            gridValues.gridRowsColumnsSyntax(stringBuilder, set, bl);
            return 0;
        }
    }

    private class GridTemplateShorthandBuilder
    extends GridShorthandBuilder {
        GridTemplateShorthandBuilder(BaseCSSStyleDeclaration baseCSSStyleDeclaration) {
            super(baseCSSStyleDeclaration);
        }

        @Override
        int appendShorthandSet(StringBuilder stringBuilder, Set<String> set, boolean bl) {
            if (!(set.contains("grid-template-areas") || set.contains("grid-template-rows") || set.contains("grid-template-columns"))) {
                this.appendLeftoverProperties(stringBuilder, set, bl);
                return 0;
            }
            stringBuilder.append(this.getShorthandName()).append(':');
            byte by = this.checkValuesForInherit(set);
            if (by == 1) {
                stringBuilder.append("inherit");
                this.appendPriority(stringBuilder, bl);
                this.appendLeftoverProperties(stringBuilder, set, bl);
                return 0;
            }
            if (by == 2) {
                return 1;
            }
            by = this.checkValuesForType(CSSValue.Type.REVERT, set);
            if (by == 1) {
                stringBuilder.append("revert");
                this.appendPriority(stringBuilder, bl);
                this.appendLeftoverProperties(stringBuilder, set, bl);
                return 0;
            }
            if (by == 2) {
                return 1;
            }
            if (this.checkValuesForType(CSSValue.Type.INTERNAL, set) != 0) {
                return 1;
            }
            String[] stringArray = this.getLonghandProperties();
            for (String string : stringArray) {
                StyleValue styleValue = this.getCSSValue(string);
                if (styleValue.getCssValueType() != CSSValue.CssType.LIST || !((ValueList)styleValue).isCommaSeparated()) continue;
                return 1;
            }
            GridTemplateValues gridTemplateValues = new GridTemplateValues(set);
            if (gridTemplateValues.isNoneValue()) {
                stringBuilder.append("none");
                this.appendPriority(stringBuilder, bl);
                this.appendLeftoverProperties(stringBuilder, set, bl);
                return 0;
            }
            if (!gridTemplateValues.defaultGridTAreas && gridTemplateValues.lacksRepeatInGridTRows && gridTemplateValues.gridAreasSyntax(stringBuilder, set)) {
                this.appendPriority(stringBuilder, bl);
                this.appendLeftoverProperties(stringBuilder, set, bl);
                return 0;
            }
            gridTemplateValues.gridRowsColumnsSyntax(stringBuilder, set, bl);
            this.appendLeftoverProperties(stringBuilder, set, bl);
            return 0;
        }

        private void appendLeftoverProperties(StringBuilder stringBuilder, Set<String> set, boolean bl) {
            if (set.contains("grid-auto-rows")) {
                this.appendIndividualProperty(stringBuilder, "grid-auto-rows", bl);
            }
            if (set.contains("grid-auto-columns")) {
                this.appendIndividualProperty(stringBuilder, "grid-auto-columns", bl);
            }
            if (set.contains("grid-auto-flow")) {
                this.appendIndividualProperty(stringBuilder, "grid-auto-flow", bl);
            }
        }

        private void appendIndividualProperty(StringBuilder stringBuilder, String string, boolean bl) {
            BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter(stringBuilder);
            DeclarationFormattingContext declarationFormattingContext = this.getParentStyle().getFormattingContext();
            StyleValue styleValue = this.getCSSValue(string);
            stringBuilder.append(string).append(':');
            BaseCSSStyleDeclaration.appendMinifiedCssText(bufferSimpleWriter, declarationFormattingContext, styleValue, string);
            this.appendPriority(stringBuilder, bl);
        }

        @Override
        String getShorthandName() {
            return "grid-template";
        }

        @Override
        protected int getTotalSetSize() {
            return 3;
        }
    }

    private class GridTemplateValues {
        final StyleValue cssGridTAreas;
        final StyleValue cssGridTRows;
        final StyleValue cssGridTColumns;
        final boolean defaultGridTAreas;
        final boolean defaultGridTRows;
        final boolean defaultGridTColumns;
        boolean lacksRepeatInGridTRows;

        GridTemplateValues(Set<String> set) {
            this.cssGridTAreas = GridShorthandBuilder.this.getCSSValue("grid-template-areas");
            this.cssGridTRows = GridShorthandBuilder.this.getCSSValue("grid-template-rows");
            this.cssGridTColumns = GridShorthandBuilder.this.getCSSValue("grid-template-columns");
            this.defaultGridTAreas = GridShorthandBuilder.this.isIdentifier(this.cssGridTAreas, "none") || !set.contains("grid-template-areas") || GridShorthandBuilder.this.isEffectiveInitialKeyword(this.cssGridTAreas);
            this.defaultGridTRows = GridShorthandBuilder.this.isIdentifier(this.cssGridTRows, "none") || !set.contains("grid-template-rows") || GridShorthandBuilder.this.isEffectiveInitialKeyword(this.cssGridTRows);
            this.defaultGridTColumns = GridShorthandBuilder.this.isIdentifier(this.cssGridTColumns, "none") || !set.contains("grid-template-columns") || GridShorthandBuilder.this.isEffectiveInitialKeyword(this.cssGridTColumns);
            this.lacksRepeatInGridTRows = this.lacksRepeatFunction(this.cssGridTRows);
        }

        private boolean lacksRepeatFunction(StyleValue styleValue) {
            if (styleValue.getCssValueType() == CSSValue.CssType.LIST) {
                ValueList valueList = (ValueList)styleValue;
                for (StyleValue styleValue2 : valueList) {
                    if (this.lacksRepeatFunction(styleValue2)) continue;
                    return false;
                }
            } else if (styleValue.getCssValueType() == CSSValue.CssType.TYPED) {
                CSSTypedValue cSSTypedValue = (CSSTypedValue)((Object)styleValue);
                return cSSTypedValue.getPrimitiveType() != CSSValue.Type.FUNCTION || !"repeat".equalsIgnoreCase(cSSTypedValue.getStringValue());
            }
            return true;
        }

        boolean gridAreasSyntax(StringBuilder stringBuilder, Set<String> set) {
            int n;
            if (GridShorthandBuilder.this.isIdentifier(this.cssGridTRows, "auto") || !set.contains("grid-template-rows")) {
                StyleValue styleValue = this.getGridTemplateAreaItem(0);
                GridShorthandBuilder.this.appendValueText(stringBuilder, styleValue);
                int n2 = 1;
                while ((styleValue = this.getGridTemplateAreaItem(n2)) != null) {
                    stringBuilder.append(' ');
                    GridShorthandBuilder.this.appendValueText(stringBuilder, styleValue);
                    ++n2;
                }
            } else if (this.cssGridTRows.getCssValueType() == CSSValue.CssType.LIST) {
                if (!((ValueList)this.cssGridTRows).isBracketList()) {
                    int n3 = 0;
                    ValueList valueList = (ValueList)this.cssGridTRows;
                    Iterator<StyleValue> iterator = valueList.iterator();
                    boolean bl = false;
                    while (iterator.hasNext()) {
                        ValueList valueList2;
                        StyleValue styleValue = iterator.next();
                        if (styleValue.getCssValueType() == CSSValue.CssType.LIST && (valueList2 = (ValueList)styleValue).isBracketList()) {
                            int n4 = valueList2.getLength();
                            if (n4 < 2) {
                                GridShorthandBuilder.this.appendValueText(stringBuilder, styleValue);
                            } else if (n4 == 2) {
                                stringBuilder.append('[');
                                GridShorthandBuilder.this.appendValueText(stringBuilder, valueList2.item(0));
                                stringBuilder.append("] [");
                                GridShorthandBuilder.this.appendValueText(stringBuilder, valueList2.item(1));
                                stringBuilder.append(']');
                            } else {
                                return false;
                            }
                            StyleValue styleValue2 = this.getGridTemplateAreaItem(n3);
                            if (styleValue2 != null) {
                                stringBuilder.append(' ');
                                GridShorthandBuilder.this.appendValueText(stringBuilder, styleValue2);
                                stringBuilder.append(' ');
                                ++n3;
                                bl = true;
                                continue;
                            }
                            if (!iterator.hasNext()) continue;
                            return false;
                        }
                        StyleValue styleValue3 = this.getGridTemplateAreaItem(n3);
                        if (styleValue3 != null && !bl) {
                            GridShorthandBuilder.this.appendValueText(stringBuilder, styleValue3);
                            stringBuilder.append(' ');
                            ++n3;
                        }
                        if (!GridShorthandBuilder.this.isIdentifier(styleValue) || !"auto".equalsIgnoreCase(styleValue.getCssText())) {
                            GridShorthandBuilder.this.appendValueText(stringBuilder, styleValue);
                            stringBuilder.append(' ');
                        }
                        bl = false;
                    }
                } else {
                    StyleValue styleValue;
                    GridShorthandBuilder.this.appendValueText(stringBuilder, this.cssGridTRows);
                    int n5 = 0;
                    while ((styleValue = this.getGridTemplateAreaItem(n5)) != null) {
                        stringBuilder.append(' ');
                        GridShorthandBuilder.this.appendValueText(stringBuilder, styleValue);
                        stringBuilder.append(' ');
                        ++n5;
                    }
                }
            } else {
                StyleValue styleValue = this.getGridTemplateAreaItem(0);
                GridShorthandBuilder.this.appendValueText(stringBuilder, styleValue);
                stringBuilder.append(' ');
                GridShorthandBuilder.this.appendValueText(stringBuilder, this.cssGridTRows);
                int n6 = 1;
                while ((styleValue = this.getGridTemplateAreaItem(n6)) != null) {
                    stringBuilder.append(' ');
                    GridShorthandBuilder.this.appendValueText(stringBuilder, styleValue);
                    stringBuilder.append(' ');
                    ++n6;
                }
            }
            if (stringBuilder.charAt(n = stringBuilder.length() - 1) == ' ') {
                stringBuilder.setLength(n);
            }
            if (!this.defaultGridTColumns) {
                stringBuilder.append('/');
                GridShorthandBuilder.this.appendValueText(stringBuilder, this.cssGridTColumns);
            }
            return true;
        }

        void gridRowsColumnsSyntax(StringBuilder stringBuilder, Set<String> set, boolean bl) {
            GridShorthandBuilder.this.appendValueText(stringBuilder, this.cssGridTRows);
            if (!this.defaultGridTColumns || GridShorthandBuilder.this.isIdentifier(this.cssGridTRows, "auto")) {
                stringBuilder.append('/');
                GridShorthandBuilder.this.appendValueText(stringBuilder, this.cssGridTColumns);
            }
            GridShorthandBuilder.this.appendPriority(stringBuilder, bl);
            if (!this.defaultGridTAreas) {
                stringBuilder.append("grid-template-areas:");
                GridShorthandBuilder.this.appendValueText(stringBuilder, this.cssGridTAreas);
                GridShorthandBuilder.this.appendPriority(stringBuilder, bl);
            }
        }

        boolean isNoneValue() {
            return this.defaultGridTAreas && this.defaultGridTRows && this.defaultGridTColumns;
        }

        StyleValue getGridTemplateAreaItem(int n) {
            if (this.cssGridTAreas.getCssValueType() == CSSValue.CssType.LIST) {
                return ((ValueList)this.cssGridTAreas).item(n);
            }
            if (!this.defaultGridTAreas && n == 0) {
                return this.cssGridTAreas;
            }
            return null;
        }
    }

    private class GridValues
    extends GridTemplateValues {
        final StyleValue cssGridARows;
        final StyleValue cssGridAColumns;
        final StyleValue cssGridAFlow;
        final boolean defaultGridARows;
        final boolean defaultGridAColumns;
        final boolean defaultGridAFlow;
        final boolean rowAFlow;

        GridValues(Set<String> set) {
            super(set);
            this.cssGridARows = GridShorthandBuilder.this.getCSSValue("grid-auto-rows");
            this.cssGridAColumns = GridShorthandBuilder.this.getCSSValue("grid-auto-columns");
            this.cssGridAFlow = GridShorthandBuilder.this.getCSSValue("grid-auto-flow");
            this.defaultGridARows = GridShorthandBuilder.this.isIdentifier(this.cssGridARows, "auto") || !set.contains("grid-auto-rows") || GridShorthandBuilder.this.isEffectiveInitialKeyword(this.cssGridARows);
            this.defaultGridAColumns = GridShorthandBuilder.this.isIdentifier(this.cssGridAColumns, "auto") || !set.contains("grid-auto-columns") || GridShorthandBuilder.this.isEffectiveInitialKeyword(this.cssGridAColumns);
            this.defaultGridAFlow = GridShorthandBuilder.this.isIdentifier(this.cssGridAFlow, "row") || !set.contains("grid-auto-flow") || GridShorthandBuilder.this.isEffectiveInitialKeyword(this.cssGridAFlow);
            this.rowAFlow = this.isRowAutoflow();
        }

        @Override
        void gridRowsColumnsSyntax(StringBuilder stringBuilder, Set<String> set, boolean bl) {
            super.gridRowsColumnsSyntax(stringBuilder, set, bl);
            if (!this.defaultGridARows) {
                stringBuilder.append("grid-auto-rows:");
                GridShorthandBuilder.this.appendValueText(stringBuilder, this.cssGridARows);
                GridShorthandBuilder.this.appendPriority(stringBuilder, bl);
            }
            if (!this.defaultGridAColumns) {
                stringBuilder.append("grid-auto-columns:");
                GridShorthandBuilder.this.appendValueText(stringBuilder, this.cssGridAColumns);
                GridShorthandBuilder.this.appendPriority(stringBuilder, bl);
            }
            if (!this.defaultGridAFlow) {
                stringBuilder.append("grid-auto-flow:");
                GridShorthandBuilder.this.appendValueText(stringBuilder, this.cssGridAFlow);
                GridShorthandBuilder.this.appendPriority(stringBuilder, bl);
            }
        }

        private boolean gridRowAutoFlowSyntax(StringBuilder stringBuilder, Set<String> set) {
            if (!this.isAutoflowDense()) {
                stringBuilder.append("auto-flow ");
            } else {
                stringBuilder.append("auto-flow dense ");
            }
            GridShorthandBuilder.this.appendValueText(stringBuilder, this.cssGridARows);
            if (!this.defaultGridTColumns) {
                stringBuilder.append('/');
                GridShorthandBuilder.this.appendValueText(stringBuilder, this.cssGridTColumns);
            }
            return true;
        }

        private boolean gridColumnAutoFlowSyntax(StringBuilder stringBuilder, Set<String> set) {
            GridShorthandBuilder.this.appendValueText(stringBuilder, this.cssGridTRows);
            if (!this.defaultGridAColumns) {
                stringBuilder.append('/');
                if (!this.isAutoflowDense()) {
                    stringBuilder.append("auto-flow ");
                } else {
                    stringBuilder.append("auto-flow dense ");
                }
                GridShorthandBuilder.this.appendValueText(stringBuilder, this.cssGridAColumns);
            }
            return true;
        }

        @Override
        boolean isNoneValue() {
            return this.defaultGridTAreas && this.defaultGridTRows && this.defaultGridTColumns && this.defaultGridARows && this.defaultGridAColumns && this.defaultGridAFlow;
        }

        private boolean isRowAutoflow() {
            if (this.cssGridAFlow.getCssValueType() == CSSValue.CssType.LIST) {
                ValueList valueList = (ValueList)this.cssGridAFlow;
                if (valueList.getLength() == 2) {
                    return "row".equalsIgnoreCase(valueList.item(0).getCssText()) || "row".equalsIgnoreCase(valueList.item(1).getCssText());
                }
            } else {
                return "row".equalsIgnoreCase(this.cssGridAFlow.getCssText());
            }
            return false;
        }

        private boolean isAutoflowDense() {
            ValueList valueList;
            if (this.cssGridAFlow.getCssValueType() == CSSValue.CssType.LIST && (valueList = (ValueList)this.cssGridAFlow).getLength() == 2) {
                return "dense".equalsIgnoreCase(valueList.item(1).getCssText()) || "dense".equalsIgnoreCase(valueList.item(0).getCssText());
            }
            return false;
        }
    }
}

