/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.CSSUnit;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.UnitStringToId;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.Dimension;
import io.sf.carte.doc.style.css.parser.LexicalUnitImpl;
import io.sf.carte.doc.style.css.parser.MathFunctionUnitImpl;
import java.util.Locale;
import org.w3c.dom.DOMException;

class DimensionalAnalyzer {
    private boolean attrPending;

    public boolean isAttrPending() {
        return this.attrPending;
    }

    public Dimension expressionDimension(LexicalUnitImpl lexicalUnitImpl) throws DOMException {
        Dimension dimension = null;
        Dimension dimension2 = null;
        Ops ops = Ops.ADD;
        while (lexicalUnitImpl != null) {
            LexicalUnit.LexicalType lexicalType = lexicalUnitImpl.getLexicalUnitType();
            switch (lexicalType) {
                case DIMENSION: {
                    switch (ops.ordinal()) {
                        case 0: {
                            dimension2 = DimensionalAnalyzer.createDimension(lexicalUnitImpl.getCssUnit());
                            break;
                        }
                        case 1: {
                            dimension2 = dimension2.multiplyByUnit(lexicalUnitImpl.getCssUnit());
                            break;
                        }
                        case 2: {
                            dimension2 = dimension2.divideByUnit(lexicalUnitImpl.getCssUnit());
                        }
                    }
                    break;
                }
                case IDENT: {
                    String string = lexicalUnitImpl.getStringValue().toLowerCase(Locale.ROOT);
                    if (!"pi".equals(string) && !"e".equals(string)) {
                        throw new DOMException(15, "Invalid identifier in expression: " + lexicalUnitImpl.getCssText());
                    }
                }
                case REAL: {
                    if (ops != Ops.ADD) break;
                    dimension2 = new Dimension();
                    dimension2.category = CSSValueSyntax.Category.number;
                    break;
                }
                case INTEGER: {
                    if (ops != Ops.ADD) break;
                    dimension2 = new Dimension();
                    dimension2.category = CSSValueSyntax.Category.integer;
                    break;
                }
                case PERCENTAGE: {
                    this.attrPending = false;
                    switch (ops.ordinal()) {
                        case 0: {
                            dimension2 = DimensionalAnalyzer.createDimension((short)2);
                            break;
                        }
                        case 1: {
                            dimension2 = dimension2.multiplyByUnit((short)2);
                            break;
                        }
                        case 2: {
                            dimension2 = dimension2.divideByUnit((short)2);
                        }
                    }
                    break;
                }
                case CALC: 
                case SUB_EXPRESSION: {
                    Dimension dimension3 = this.expressionDimension(lexicalUnitImpl.parameters);
                    if (dimension3 == null) {
                        return null;
                    }
                    switch (ops.ordinal()) {
                        case 0: {
                            dimension2 = dimension3;
                            break;
                        }
                        case 1: {
                            dimension2 = dimension2.multiply(dimension3);
                            break;
                        }
                        case 2: {
                            dimension2 = dimension2.divide(dimension3);
                        }
                    }
                    break;
                }
                case VAR: {
                    return null;
                }
                case MATH_FUNCTION: {
                    Dimension dimension4 = ((MathFunctionUnitImpl)lexicalUnitImpl).dimension(this);
                    if (dimension4 == null) {
                        return null;
                    }
                    switch (ops.ordinal()) {
                        case 0: {
                            dimension2 = dimension4;
                            break;
                        }
                        case 1: {
                            dimension2 = dimension2.multiply(dimension4);
                            break;
                        }
                        case 2: {
                            dimension2 = dimension2.divide(dimension4);
                        }
                    }
                    break;
                }
                case OPERATOR_PLUS: 
                case OPERATOR_MINUS: {
                    if (dimension == null) {
                        dimension = dimension2;
                    } else {
                        dimension.sum(dimension2);
                    }
                    ops = Ops.ADD;
                    break;
                }
                case OPERATOR_MULTIPLY: {
                    ops = Ops.MULT;
                    break;
                }
                case OPERATOR_SLASH: {
                    ops = Ops.DIV;
                    break;
                }
                case ATTR: {
                    Dimension dimension5 = this.attrDimension(lexicalUnitImpl.parameters);
                    if (dimension5 == null) {
                        return null;
                    }
                    switch (ops.ordinal()) {
                        case 0: {
                            dimension2 = dimension5;
                            break;
                        }
                        case 1: {
                            dimension2 = dimension2.multiply(dimension5);
                            break;
                        }
                        case 2: {
                            dimension2 = dimension2.divide(dimension5);
                        }
                    }
                    break;
                }
                default: {
                    throw new DOMException(15, "Invalid unit in expression: " + lexicalUnitImpl.getCssText());
                }
            }
            lexicalUnitImpl = lexicalUnitImpl.nextLexicalUnit;
        }
        if (dimension != null) {
            if (!dimension.sum(dimension2)) {
                throw new DOMException(15, "Invalid attempt to sum " + dimension + " and " + dimension2);
            }
        } else {
            dimension = dimension2;
        }
        return dimension;
    }

    private Dimension attrDimension(LexicalUnitImpl lexicalUnitImpl) throws DOMException {
        LexicalUnitImpl lexicalUnitImpl2 = lexicalUnitImpl.nextLexicalUnit;
        if (lexicalUnitImpl2 != null) {
            Dimension dimension;
            Dimension dimension2 = DimensionalAnalyzer.typeSpecDimension(lexicalUnitImpl2);
            if (dimension2 == null || dimension2.category != CSSValueSyntax.Category.length && dimension2.category != CSSValueSyntax.Category.percentage || (lexicalUnitImpl2 = lexicalUnitImpl2.nextLexicalUnit) == null || lexicalUnitImpl2.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA || (lexicalUnitImpl2 = lexicalUnitImpl2.nextLexicalUnit) == null) {
                return dimension2;
            }
            try {
                dimension = this.expressionDimension(lexicalUnitImpl2);
            }
            catch (DOMException dOMException) {
                return dimension2;
            }
            if (dimension != null && dimension2.category != dimension.category) {
                this.attrPending = dimension2.sum(dimension);
                dimension2.lengthProcessed = false;
                dimension2.percentageProcessed = false;
            }
            return dimension2;
        }
        throw new DOMException(15, "Invalid attr() in expression: " + lexicalUnitImpl.getCssText());
    }

    private static Dimension typeSpecDimension(LexicalUnitImpl lexicalUnitImpl) {
        switch (lexicalUnitImpl.getLexicalUnitType()) {
            case TYPE_FUNCTION: {
                LexicalUnit lexicalUnit = lexicalUnitImpl.getParameters();
                if (lexicalUnit == null) break;
                Dimension dimension = new Dimension();
                dimension.category = lexicalUnit.getSyntax().getCategory();
                if (dimension.category != CSSValueSyntax.Category.number && dimension.category != CSSValueSyntax.Category.integer) {
                    dimension.exponent = 1;
                }
                return dimension;
            }
            case IDENT: {
                String string = lexicalUnitImpl.getStringValue().toLowerCase(Locale.ROOT);
                return DimensionalAnalyzer.createDimension(UnitStringToId.unitFromString(string));
            }
            case OPERATOR_MOD: {
                Dimension dimension = new Dimension();
                dimension.category = CSSValueSyntax.Category.percentage;
                dimension.exponent = 1;
                return dimension;
            }
            case VAR: {
                return null;
            }
        }
        throw new DOMException(15, "Invalid attr() in expression: " + lexicalUnitImpl.getCssText());
    }

    private static Dimension createDimension(short s) throws DOMException {
        Dimension dimension = new Dimension();
        if (s == 0) {
            dimension.category = CSSValueSyntax.Category.number;
            dimension.exponent = 0;
            return dimension;
        }
        dimension.exponent = 1;
        if (CSSUnit.isLengthUnitType(s)) {
            dimension.category = CSSValueSyntax.Category.length;
            dimension.lengthProcessed = true;
        } else if (s == 2) {
            dimension.category = CSSValueSyntax.Category.percentage;
            dimension.percentageProcessed = true;
        } else if (CSSUnit.isAngleUnitType(s)) {
            dimension.category = CSSValueSyntax.Category.angle;
        } else if (CSSUnit.isTimeUnitType(s)) {
            dimension.category = CSSValueSyntax.Category.time;
        } else if (CSSUnit.isResolutionUnitType(s)) {
            dimension.category = CSSValueSyntax.Category.resolution;
        } else if (s == 100 || s == 101) {
            dimension.category = CSSValueSyntax.Category.frequency;
        } else if (s == 70) {
            dimension.category = CSSValueSyntax.Category.flex;
        } else {
            throw new DOMException(15, "Invalid unit: " + s);
        }
        return dimension;
    }

    private static enum Ops {
        ADD,
        MULT,
        DIV;

    }
}

