/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.coverage.report.impl.html;

import java.util.Comparator;
import jetbrains.coverage.report.ClassInfo;
import jetbrains.coverage.report.CoverageStatistics;
import jetbrains.coverage.report.StatEntry;
import jetbrains.coverage.report.StatisticsCalculator;
import jetbrains.coverage.report.impl.html.ModuleInfo;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SortOption {
    NONE,
    SORT_BY_NAME,
    SORT_BY_NAME_DESC,
    SORT_BY_CLASS,
    SORT_BY_CLASS_DESC,
    SORT_BY_METHOD,
    SORT_BY_METHOD_DESC,
    SORT_BY_BLOCK,
    SORT_BY_BLOCK_DESC,
    SORT_BY_LINE,
    SORT_BY_LINE_DESC,
    SORT_BY_STATEMENT,
    SORT_BY_STATEMENT_DESC;


    @NotNull
    public String getIndexFileName() {
        if (this == SORT_BY_NAME || this == NONE) {
            return "index.html";
        }
        return "index_" + this.name() + ".html";
    }

    @NotNull
    public SortOption inverse() {
        switch (this) {
            default: {
                return NONE;
            }
            case SORT_BY_BLOCK: {
                return SORT_BY_BLOCK_DESC;
            }
            case SORT_BY_BLOCK_DESC: {
                return SORT_BY_BLOCK;
            }
            case SORT_BY_NAME: {
                return SORT_BY_NAME_DESC;
            }
            case SORT_BY_NAME_DESC: {
                return SORT_BY_NAME;
            }
            case SORT_BY_CLASS: {
                return SORT_BY_CLASS_DESC;
            }
            case SORT_BY_CLASS_DESC: {
                return SORT_BY_CLASS;
            }
            case SORT_BY_METHOD: {
                return SORT_BY_METHOD_DESC;
            }
            case SORT_BY_METHOD_DESC: {
                return SORT_BY_METHOD;
            }
            case SORT_BY_LINE: {
                return SORT_BY_LINE_DESC;
            }
            case SORT_BY_LINE_DESC: {
                return SORT_BY_LINE;
            }
            case SORT_BY_STATEMENT: {
                return SORT_BY_STATEMENT_DESC;
            }
            case SORT_BY_STATEMENT_DESC: 
        }
        return SORT_BY_STATEMENT;
    }

    public boolean isDescendingOrder() {
        return this.name().endsWith("_DESC");
    }

    public Comparator<ClassInfo> createClassComparator(final StatisticsCalculator covStatsCalculator) {
        final boolean desc = this.isDescendingOrder();
        Comparator<ClassInfo> nameComparator = new Comparator<ClassInfo>(){

            @Override
            public int compare(ClassInfo o1, ClassInfo o2) {
                int result = o1.getName().compareTo(o2.getName());
                return desc ? -result : result;
            }
        };
        if (this.orderByName()) {
            return nameComparator;
        }
        Comparator<ClassInfo> valueComparator = this.comparator(new Func<ClassInfo>(){

            @Override
            public CoverageStatistics compute(ClassInfo classInfo) {
                return covStatsCalculator.getForClassWithInnerClasses(classInfo);
            }
        });
        return this.addSecondaryComparator(valueComparator, nameComparator);
    }

    public Comparator<String> createNamespaceComparator(ModuleInfo module, final StatisticsCalculator covStatsCalculator) {
        final boolean desc = this.isDescendingOrder();
        final String moduleName = module.getName();
        Comparator<String> nameComparator = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int result = o1.compareTo(o2);
                return desc ? -result : result;
            }
        };
        if (this.orderByName()) {
            return nameComparator;
        }
        Comparator<String> valueComparator = this.comparator(new Func<String>(){

            @Override
            public CoverageStatistics compute(String s) {
                return covStatsCalculator.getForNamespace(moduleName, s);
            }
        });
        return this.addSecondaryComparator(valueComparator, nameComparator);
    }

    public Comparator<ModuleInfo> createModulesComparator(final StatisticsCalculator covStatsCalculator) {
        Comparator<ModuleInfo> nameComparator = new Comparator<ModuleInfo>(){

            @Override
            public int compare(ModuleInfo o1, ModuleInfo o2) {
                String n1 = o1.getName();
                String n2 = o2.getName();
                if (n1 == null && n2 == null) {
                    return 0;
                }
                if (n1 != null && n2 == null) {
                    return 1;
                }
                if (n1 == null && n2 != null) {
                    return -1;
                }
                int result = n1.compareTo(n2);
                return SortOption.this.isDescendingOrder() ? -result : result;
            }
        };
        if (this.orderByName()) {
            return nameComparator;
        }
        Comparator<ModuleInfo> valueComparator = this.comparator(new Func<ModuleInfo>(){

            @Override
            public CoverageStatistics compute(ModuleInfo moduleInfo) {
                return covStatsCalculator.getForModule(moduleInfo.getName());
            }
        });
        return this.addSecondaryComparator(valueComparator, nameComparator);
    }

    @NotNull
    private Selector getSelector() {
        if (this.orderByMethod()) {
            return new Selector(){

                public StatEntry compute(@NotNull CoverageStatistics stat) {
                    return stat.getMethodStats();
                }
            };
        }
        if (this.orderByBlock()) {
            return new Selector(){

                public StatEntry compute(@NotNull CoverageStatistics stat) {
                    return stat.getBlockStats();
                }
            };
        }
        if (this.orderByStatement()) {
            return new Selector(){

                public StatEntry compute(@NotNull CoverageStatistics stat) {
                    return stat.getStatementStats();
                }
            };
        }
        if (this.orderByLine()) {
            return new Selector(){

                public StatEntry compute(@NotNull CoverageStatistics stat) {
                    return stat.getLineStats();
                }
            };
        }
        if (this.orderByClass()) {
            return new Selector(){

                public StatEntry compute(@NotNull CoverageStatistics stat) {
                    return stat.getClassStats();
                }
            };
        }
        throw new IllegalArgumentException("Failed to get statistics selector for: " + (Object)((Object)this));
    }

    private <T> Comparator<T> addSecondaryComparator(final @NotNull Comparator<T> mainComparator, final @NotNull Comparator<T> secondaryComparator) {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                int mainResult = mainComparator.compare(o1, o2);
                if (mainResult != 0) {
                    return mainResult;
                }
                return secondaryComparator.compare(o1, o2);
            }
        };
    }

    private <T> Comparator<T> comparator(final @NotNull Func<T> fun) {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return this.compareStatEntries(SortOption.this.getSelector().compute(fun.compute(o1)), SortOption.this.getSelector().compute(fun.compute(o2)), SortOption.this.isDescendingOrder());
            }

            private int compareStatEntries(StatEntry stat1, StatEntry stat2, boolean desc) {
                int result = stat1.compareTo(stat2);
                if (desc) {
                    result = -result;
                }
                return result;
            }
        };
    }

    public boolean orderByLine() {
        return this == SORT_BY_LINE || this == SORT_BY_LINE_DESC;
    }

    public boolean orderByStatement() {
        return this == SORT_BY_STATEMENT || this == SORT_BY_STATEMENT_DESC;
    }

    public boolean orderByMethod() {
        return this == SORT_BY_METHOD || this == SORT_BY_METHOD_DESC;
    }

    public boolean orderByClass() {
        return this == SORT_BY_CLASS || this == SORT_BY_CLASS_DESC;
    }

    public boolean orderByBlock() {
        return this == SORT_BY_BLOCK || this == SORT_BY_BLOCK_DESC;
    }

    public boolean orderByName() {
        return this == SORT_BY_NAME || this == SORT_BY_NAME_DESC;
    }

    public SortOption nextOrderByClass() {
        if (this == NONE) {
            return NONE;
        }
        return this.orderByClass() ? this.inverse() : SORT_BY_CLASS;
    }

    public SortOption nextOrderByName() {
        if (this == NONE) {
            return NONE;
        }
        return this.orderByName() ? this.inverse() : SORT_BY_NAME;
    }

    public SortOption nextOrderByLine() {
        if (this == NONE) {
            return NONE;
        }
        return this.orderByLine() ? this.inverse() : SORT_BY_LINE;
    }

    public SortOption nextOrderByStatement() {
        if (this == NONE) {
            return NONE;
        }
        return this.orderByStatement() ? this.inverse() : SORT_BY_STATEMENT;
    }

    public SortOption nextOrderByMethod() {
        if (this == NONE) {
            return NONE;
        }
        return this.orderByMethod() ? this.inverse() : SORT_BY_METHOD;
    }

    public SortOption nextOrderByBlock() {
        if (this == NONE) {
            return NONE;
        }
        return this.orderByBlock() ? this.inverse() : SORT_BY_BLOCK;
    }

    private static interface Selector {
        public StatEntry compute(@NotNull CoverageStatistics var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Func<T> {
        public CoverageStatistics compute(T var1);
    }
}

