/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.indices.impl;

import com.intellij.openapi.fileTypes.impl.FileTypeAssocTable;
import com.intellij.openapi.util.io.FileFilters;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.containers.FileCollectionFactory;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.io.FileFilter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsExcludePattern;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.fileTypes.FileNameMatcherFactory;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaModuleExtension;
import org.jetbrains.jps.model.java.JpsJavaProjectExtension;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.util.JpsPathUtil;

public final class ModuleExcludeIndexImpl
implements ModuleExcludeIndex {
    private final Set<Path> myExcludedRoots = FileCollectionFactory.createCanonicalPathSet();
    private final Set<Path> myTopLevelContentRoots = FileCollectionFactory.createCanonicalPathSet();
    private final Map<JpsModule, ArrayList<Path>> myModuleToExcludesMap = new HashMap<JpsModule, ArrayList<Path>>();
    private final Map<JpsModule, List<Path>> myModuleToContentMap = new HashMap<JpsModule, List<Path>>();
    private final Map<Path, FileTypeAssocTable<Boolean>> myExcludeFromContentRootTables = FileCollectionFactory.createCanonicalPathMap();

    public ModuleExcludeIndexImpl(JpsModel model) {
        String url;
        List allModules = model.getProject().getModules();
        Map contentToModule = FileCollectionFactory.createCanonicalPathMap();
        MultiMap contentToSourceRootsWithExcludePatterns = MultiMap.createLinked();
        MultiMap excludePatterns = MultiMap.createLinked();
        for (Object module : allModules) {
            ArrayList<Path> moduleExcludes = new ArrayList<Path>();
            for (String url2 : module.getExcludeRootsList().getUrls()) {
                moduleExcludes.add(Path.of(JpsPathUtil.urlToPath((String)url2), new String[0]));
            }
            JpsJavaModuleExtension moduleExtension = JpsJavaExtensionService.getInstance().getModuleExtension((JpsModule)module);
            if (moduleExtension != null && !moduleExtension.isInheritOutput() && moduleExtension.isExcludeOutput()) {
                String string;
                String outputUrl = moduleExtension.getOutputUrl();
                if (outputUrl != null) {
                    moduleExcludes.add(Path.of(JpsPathUtil.urlToPath((String)outputUrl), new String[0]));
                }
                if ((string = moduleExtension.getTestOutputUrl()) != null) {
                    moduleExcludes.add(Path.of(JpsPathUtil.urlToPath((String)string), new String[0]));
                }
            }
            List excludePatternsList = module.getExcludePatterns();
            Iterator iterator = excludePatternsList.iterator();
            while (iterator.hasNext()) {
                JpsExcludePattern pattern = (JpsExcludePattern)iterator.next();
                excludePatterns.putValue((Object)pattern.getBaseDirUrl(), (Object)pattern.getPattern());
            }
            List list = module.getContentRootsList().getUrls();
            ArrayList<Path> moduleContent = new ArrayList<Path>(list.size());
            for (String contentUrl : list) {
                Path contentRoot = Path.of(JpsPathUtil.urlToPath((String)contentUrl), new String[0]);
                moduleContent.add(contentRoot);
                contentToModule.put(contentRoot, module);
            }
            for (JpsModuleSourceRoot root : module.getSourceRoots()) {
                Path sourceRoot = root.getPath();
                moduleContent.add(sourceRoot);
                contentToModule.put(sourceRoot, module);
                Iterator iterator2 = excludePatternsList.iterator();
                while (iterator2.hasNext()) {
                    JpsExcludePattern pattern = (JpsExcludePattern)iterator2.next();
                    if (!FileUtil.isAncestor((String)JpsPathUtil.urlToPath((String)pattern.getBaseDirUrl()), (String)sourceRoot.toString(), (boolean)true)) continue;
                    contentToSourceRootsWithExcludePatterns.putValue((Object)pattern.getBaseDirUrl(), (Object)root.getUrl());
                }
            }
            this.myModuleToExcludesMap.put((JpsModule)module, moduleExcludes);
            this.myModuleToContentMap.put((JpsModule)module, moduleContent);
            this.myExcludedRoots.addAll(moduleExcludes);
        }
        FileNameMatcherFactory factory = FileNameMatcherFactory.getInstance();
        for (Map.Entry entry : excludePatterns.entrySet()) {
            FileTypeAssocTable table = new FileTypeAssocTable();
            for (String string : (Collection)entry.getValue()) {
                table.addAssociation(factory.createMatcher(string), (Object)Boolean.TRUE);
            }
            this.myExcludeFromContentRootTables.put(Path.of(JpsPathUtil.urlToPath((String)((String)entry.getKey())), new String[0]), (FileTypeAssocTable<Boolean>)table);
            Collection sourceRootUrls = contentToSourceRootsWithExcludePatterns.get((Object)((String)entry.getKey()));
            for (String sourceRootUrl : sourceRootUrls) {
                this.myExcludeFromContentRootTables.put(Path.of(JpsPathUtil.urlToPath((String)sourceRootUrl), new String[0]), (FileTypeAssocTable<Boolean>)table);
            }
        }
        JpsJavaProjectExtension projectExtension = JpsJavaExtensionService.getInstance().getProjectExtension(model.getProject());
        if (projectExtension != null && !Strings.isEmpty((String)(url = projectExtension.getOutputUrl()))) {
            Path excluded;
            for (Path parent = excluded = Path.of(JpsPathUtil.urlToPath((String)url), new String[0]); parent != null; parent = parent.getParent()) {
                JpsModule jpsModule = (JpsModule)contentToModule.get(parent);
                if (jpsModule == null) continue;
                this.myModuleToExcludesMap.get(jpsModule).add(excluded);
            }
            this.myExcludedRoots.add(excluded);
        }
        ArrayList<Path> parents = new ArrayList<Path>();
        Set notUnderExcludedCache = FileCollectionFactory.createCanonicalPathSet();
        for (JpsModule jpsModule : allModules) {
            for (Path contentRoot : this.myModuleToContentMap.get(jpsModule)) {
                Object parentModule = null;
                parents.clear();
                for (Path parent = contentRoot.getParent(); parent != null; parent = parent.getParent()) {
                    parents.add(parent);
                    if (!contentToModule.containsKey(parent)) continue;
                    parentModule = (JpsModule)contentToModule.get(parent);
                    break;
                }
                if (parentModule != null) {
                    if (!parentModule.equals(jpsModule)) {
                        this.myModuleToExcludesMap.get(parentModule).add(contentRoot);
                    }
                    if (ModuleExcludeIndexImpl.isUnderExcluded(contentRoot, this.myExcludedRoots, notUnderExcludedCache)) {
                        this.myTopLevelContentRoots.add(contentRoot);
                    }
                } else {
                    this.myTopLevelContentRoots.add(contentRoot);
                }
                for (Path file : parents) {
                    contentToModule.put(file, parentModule);
                }
            }
        }
        for (ArrayList arrayList : this.myModuleToExcludesMap.values()) {
            arrayList.trimToSize();
        }
    }

    private static boolean isUnderExcluded(Path root, Set<? extends Path> excluded, Set<? super Path> notUnderExcludedCache) {
        ArrayList<Path> parents = new ArrayList<Path>();
        for (Path parent = root; parent != null; parent = parent.getParent()) {
            if (notUnderExcludedCache.contains(parent)) {
                return false;
            }
            if (excluded.contains(parent)) {
                return true;
            }
            parents.add(parent);
        }
        notUnderExcludedCache.addAll(parents);
        return false;
    }

    @Override
    public boolean isExcluded(File file) {
        return this.determineFileLocation(file.toPath(), this.myTopLevelContentRoots, this.myExcludedRoots) == FileLocation.EXCLUDED;
    }

    @Override
    public boolean isExcludedFromModule(@NotNull File file, @NotNull JpsModule module) {
        if (file == null) {
            ModuleExcludeIndexImpl.$$$reportNull$$$0(0);
        }
        if (module == null) {
            ModuleExcludeIndexImpl.$$$reportNull$$$0(1);
        }
        return this.determineFileLocation(file.toPath(), (Collection<Path>)this.myModuleToContentMap.get(module), (Collection<Path>)this.myModuleToExcludesMap.get(module)) == FileLocation.EXCLUDED;
    }

    @Override
    public boolean isInContent(@NotNull File file) {
        if (file == null) {
            ModuleExcludeIndexImpl.$$$reportNull$$$0(2);
        }
        return this.determineFileLocation(file.toPath(), this.myTopLevelContentRoots, this.myExcludedRoots) == FileLocation.IN_CONTENT;
    }

    private FileLocation determineFileLocation(Path file, Collection<Path> roots, Collection<Path> excluded) {
        if (roots.isEmpty() && excluded.isEmpty()) {
            return FileLocation.NOT_IN_PROJECT;
        }
        for (Path current = file; current != null; current = current.getParent()) {
            if (excluded.contains(current)) {
                return FileLocation.EXCLUDED;
            }
            FileTypeAssocTable<Boolean> table = this.myExcludeFromContentRootTables.get(current);
            if (table != null && ModuleExcludeIndexImpl.isExcludedByPattern(file, current, table)) {
                return FileLocation.EXCLUDED;
            }
            if (!roots.contains(current)) continue;
            return FileLocation.IN_CONTENT;
        }
        return FileLocation.NOT_IN_PROJECT;
    }

    private static boolean isExcludedByPattern(Path file, Path root, FileTypeAssocTable<Boolean> table) {
        for (Path current = file; current != null && !current.equals(root); current = current.getParent()) {
            if (table.findAssociatedFileType((CharSequence)current.getFileName().toString()) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public @Unmodifiable @NotNull Collection<@NotNull Path> getModuleExcludes(@NotNull JpsModule module) {
        if (module == null) {
            ModuleExcludeIndexImpl.$$$reportNull$$$0(3);
        }
        Collection collection = this.myModuleToExcludesMap.get(module);
        if (collection == null) {
            ModuleExcludeIndexImpl.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @Override
    @NotNull
    public FileFilter getModuleFileFilterHonorExclusionPatterns(@NotNull JpsModule module) {
        List<Path> contentRoots;
        if (module == null) {
            ModuleExcludeIndexImpl.$$$reportNull$$$0(5);
        }
        if ((contentRoots = this.myModuleToContentMap.get(module)) == null || contentRoots.isEmpty() || this.myExcludeFromContentRootTables.isEmpty()) {
            FileFilter fileFilter = FileFilters.EVERYTHING;
            if (fileFilter == null) {
                ModuleExcludeIndexImpl.$$$reportNull$$$0(6);
            }
            return fileFilter;
        }
        FileFilter fileFilter = file -> this.determineFileLocation(file.toPath(), contentRoots, Collections.emptyList()) == FileLocation.IN_CONTENT;
        if (fileFilter == null) {
            ModuleExcludeIndexImpl.$$$reportNull$$$0(7);
        }
        return fileFilter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/indices/impl/ModuleExcludeIndexImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/indices/impl/ModuleExcludeIndexImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleExcludes";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleFileFilterHonorExclusionPatterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isExcludedFromModule";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isInContent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getModuleExcludes";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getModuleFileFilterHonorExclusionPatterns";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum FileLocation {
        IN_CONTENT,
        EXCLUDED,
        NOT_IN_PROJECT;

    }
}

