/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdi;

import com.jetbrains.jdi.JDWP;
import com.jetbrains.jdi.JDWPException;
import com.jetbrains.jdi.ObjectReferenceImpl;
import com.jetbrains.jdi.VirtualMachineImpl;
import com.sun.jdi.StringReference;
import com.sun.jdi.VirtualMachine;
import java.util.concurrent.CompletableFuture;

public class StringReferenceImpl
extends ObjectReferenceImpl
implements StringReference {
    private volatile String value;

    StringReferenceImpl(VirtualMachine aVm, long aRef) {
        super(aVm, aRef);
    }

    public CompletableFuture<String> valueAsync() {
        if (this.value != null) {
            return CompletableFuture.completedFuture(this.value);
        }
        return JDWP.StringReference.Value.processAsync(this.vm, this).thenApply(v -> {
            this.value = v.stringValue;
            return this.value;
        });
    }

    @Override
    public String value() {
        if (this.value == null) {
            try {
                this.value = JDWP.StringReference.Value.process((VirtualMachineImpl)this.vm, (ObjectReferenceImpl)this).stringValue;
            }
            catch (JDWPException exc) {
                throw exc.toJDIException();
            }
        }
        return this.value;
    }

    @Override
    public String toString() {
        return "\"" + this.value() + "\"";
    }

    @Override
    byte typeValueKey() {
        return 115;
    }
}

