/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.exportimport.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.connections.jpa.support.EntityManagers;
import org.keycloak.exportimport.ExportProvider;
import org.keycloak.exportimport.UsersExportStrategy;
import org.keycloak.exportimport.util.ExportImportSessionTask;
import org.keycloak.exportimport.util.ExportUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.ServicesLogger;
import org.keycloak.storage.UserStoragePrivateUtil;
import org.keycloak.storage.UserStorageUtil;

public abstract class MultipleStepsExportProvider<T extends MultipleStepsExportProvider<?>>
implements ExportProvider {
    protected final Logger logger = Logger.getLogger(this.getClass());
    protected final KeycloakSessionFactory factory;
    private String realmId;
    private int usersPerFile = 50;
    private UsersExportStrategy usersExportStrategy;

    public MultipleStepsExportProvider(KeycloakSessionFactory factory) {
        this.factory = factory;
    }

    public void exportModel() {
        if (this.realmId != null) {
            ServicesLogger.LOGGER.realmExportRequested(this.realmId);
            this.exportRealmImpl(this.realmId);
        } else {
            ServicesLogger.LOGGER.fullModelExportRequested();
            final List[] realms = new List[1];
            new ExportImportSessionTask(){

                @Override
                protected void runExportImportTask(KeycloakSession session) throws IOException {
                    realms[0] = session.realms().getRealmsStream().collect(Collectors.toList());
                }
            }.runTask(this.factory);
            for (RealmModel realm : realms[0]) {
                this.exportRealmImpl(realm.getName());
            }
        }
        ServicesLogger.LOGGER.exportSuccess();
    }

    public T withRealmName(String realmName) {
        this.realmId = realmName;
        return (T)this;
    }

    public T withUsersPerFile(int usersPerFile) {
        if (usersPerFile < 1) {
            throw new IllegalArgumentException("usersPerFile must be greater than 0");
        }
        this.usersPerFile = usersPerFile;
        return (T)this;
    }

    public T withUsersExportStrategy(UsersExportStrategy usersExportStrategy) {
        this.usersExportStrategy = usersExportStrategy;
        return (T)this;
    }

    protected void exportRealmImpl(final String realmName) {
        final boolean exportUsersIntoRealmFile = this.usersExportStrategy == UsersExportStrategy.REALM_FILE;
        new ExportImportSessionTask(){

            @Override
            protected void runExportImportTask(KeycloakSession session) throws IOException {
                RealmModel realm = session.realms().getRealmByName(realmName);
                Objects.requireNonNull(realm, "realm not found by realm name '" + realmName + "'");
                session.getContext().setRealm(realm);
                RealmRepresentation rep = ExportUtils.exportRealm((KeycloakSession)session, (RealmModel)realm, (boolean)exportUsersIntoRealmFile, (boolean)true);
                MultipleStepsExportProvider.this.writeRealm(realmName + "-realm.json", rep);
                MultipleStepsExportProvider.this.logger.info((Object)("Realm '" + realmName + "' - data exported"));
                if (MultipleStepsExportProvider.this.usersExportStrategy != UsersExportStrategy.SKIP && !exportUsersIntoRealmFile) {
                    Stream users = UserStoragePrivateUtil.userLocalStorage((KeycloakSession)session).searchForUserStream(realm, Map.of());
                    this.exportUsers(realmName, session, realm, users, false);
                    if (UserStorageUtil.userFederatedStorage((KeycloakSession)session) != null) {
                        Stream federatedUsers = UserStorageUtil.userFederatedStorage((KeycloakSession)session).getStoredUsersStream(realm, null, null);
                        this.exportUsers(realmName, session, realm, federatedUsers, true);
                    }
                }
            }

            private <U> void exportUsers(String realmName2, KeycloakSession session, RealmModel realm, Stream<U> users, boolean federated) throws IOException {
                UsersHolder usersHolder = new UsersHolder();
                Integer countPerPage = MultipleStepsExportProvider.this.usersExportStrategy == UsersExportStrategy.SAME_FILE ? null : Integer.valueOf(MultipleStepsExportProvider.this.usersPerFile);
                ArrayList usersBatch = new ArrayList();
                users.forEachOrdered(user -> {
                    usersBatch.add(user);
                    if (countPerPage != null && usersBatch.size() >= countPerPage) {
                        try {
                            this.flushUsers(realmName2, session, realm, usersHolder, countPerPage, usersBatch, federated);
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Error during export/import: " + e.getMessage(), e);
                        }
                    }
                });
                if (!usersBatch.isEmpty()) {
                    this.flushUsers(realmName2, session, realm, usersHolder, countPerPage, usersBatch, federated);
                }
            }

            private <U> void flushUsers(String realmName2, KeycloakSession session, RealmModel realm, UsersHolder usersHolder, Integer countPerPage, List<U> usersBatch, boolean federated) throws IOException {
                if (federated) {
                    MultipleStepsExportProvider.this.writeFederatedUsers(realmName2 + "-federated-users-" + usersHolder.file + ".json", session, realm, usersBatch);
                } else {
                    MultipleStepsExportProvider.this.writeUsers(realmName2 + "-users-" + usersHolder.file + ".json", session, realm, usersBatch);
                }
                int start = countPerPage == null ? 0 : countPerPage * usersHolder.file;
                MultipleStepsExportProvider.this.logger.infof("%sUsers %s - %s exported", (Object)(federated ? "Federated " : ""), (Object)start, (Object)(start + usersBatch.size() - 1));
                ++usersHolder.file;
                usersBatch.clear();
                EntityManagers.flush((KeycloakSession)session, (boolean)true);
            }
        }.runTask(this.factory, ExportImportSessionTask.Mode.BATCHED);
    }

    protected abstract void writeRealm(String var1, RealmRepresentation var2) throws IOException;

    protected abstract void writeUsers(String var1, KeycloakSession var2, RealmModel var3, List<UserModel> var4) throws IOException;

    protected abstract void writeFederatedUsers(String var1, KeycloakSession var2, RealmModel var3, List<String> var4) throws IOException;

    public static class UsersHolder {
        int file;
    }
}

