/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.xml.internal;

import jakarta.persistence.ColumnResult;
import jakarta.persistence.ConstructorResult;
import jakarta.persistence.EntityResult;
import jakarta.persistence.FieldResult;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.NamedStoredProcedureQuery;
import jakarta.persistence.QueryHint;
import jakarta.persistence.StoredProcedureParameter;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.FlushMode;
import org.hibernate.annotations.FlushModeType;
import org.hibernate.annotations.NamedNativeQuery;
import org.hibernate.boot.jaxb.mapping.spi.JaxbColumnResultImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbConstructorResultImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityMappingsImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityResultImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbFieldResultImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbNamedHqlQueryImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbNamedNativeQueryImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbNamedStoredProcedureQueryImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbQueryHint;
import org.hibernate.boot.jaxb.mapping.spi.JaxbQueryHintImpl;
import org.hibernate.boot.jaxb.mapping.spi.JaxbStoredProcedureParameterImpl;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.JpaAnnotations;
import org.hibernate.boot.models.annotations.internal.ColumnResultJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.ConstructorResultJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.EntityResultJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.FieldResultJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.NamedNativeQueriesAnnotation;
import org.hibernate.boot.models.annotations.internal.NamedNativeQueriesJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.NamedNativeQueryAnnotation;
import org.hibernate.boot.models.annotations.internal.NamedNativeQueryJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.NamedQueriesAnnotation;
import org.hibernate.boot.models.annotations.internal.NamedQueriesJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.NamedQueryAnnotation;
import org.hibernate.boot.models.annotations.internal.NamedQueryJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.NamedStoredProcedureQueriesJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.NamedStoredProcedureQueryJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.QueryHintJpaAnnotation;
import org.hibernate.boot.models.annotations.internal.StoredProcedureParameterJpaAnnotation;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.models.spi.ModelsContext;
import org.hibernate.models.spi.MutableClassDetails;

public class QueryProcessing {
    public static final QueryHint[] NO_HINTS = new QueryHint[0];
    private static final ColumnResult[] NO_COLUMN_RESULTS = new ColumnResult[0];
    private static final ConstructorResult[] NO_CONSTRUCTOR_RESULTS = new ConstructorResult[0];
    private static final EntityResult[] NO_ENTITY_RESULTS = new EntityResult[0];
    private static final StoredProcedureParameter[] NO_PARAMS = new StoredProcedureParameter[0];
    private static final Class<?>[] NO_CLASSES = new Class[0];

    public static void applyNamedQueries(JaxbEntityImpl jaxbEntity, MutableClassDetails classDetails, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbEntity.getNamedQueries())) {
            return;
        }
        ModelsContext modelBuildingContext = xmlDocumentContext.getModelBuildingContext();
        ArrayList<NamedQueryAnnotation> namedHqlQueryList = null;
        ArrayList<NamedQueryJpaAnnotation> namedJpqlQueryList = null;
        for (int i = 0; i < jaxbEntity.getNamedQueries().size(); ++i) {
            JaxbNamedHqlQueryImpl jaxbNamedQuery = jaxbEntity.getNamedQueries().get(i);
            if (CollectionHelper.isNotEmpty(jaxbNamedQuery.getHints())) {
                if (namedJpqlQueryList == null) {
                    namedJpqlQueryList = new ArrayList<NamedQueryJpaAnnotation>();
                }
                NamedQueryJpaAnnotation namedJpqlQuery = (NamedQueryJpaAnnotation)((Object)JpaAnnotations.NAMED_QUERY.createUsage(modelBuildingContext));
                namedJpqlQueryList.add(namedJpqlQuery);
                namedJpqlQuery.apply(jaxbNamedQuery, xmlDocumentContext);
                continue;
            }
            if (namedHqlQueryList == null) {
                namedHqlQueryList = new ArrayList<NamedQueryAnnotation>();
            }
            NamedQueryAnnotation namedQuery = (NamedQueryAnnotation)HibernateAnnotations.NAMED_QUERY.createUsage(xmlDocumentContext.getModelBuildingContext());
            namedHqlQueryList.add(namedQuery);
            namedQuery.apply(jaxbNamedQuery, xmlDocumentContext);
        }
        if (namedJpqlQueryList != null) {
            NamedQueriesJpaAnnotation namedJpqlQueries = (NamedQueriesJpaAnnotation)classDetails.replaceAnnotationUsage(JpaAnnotations.NAMED_QUERY, JpaAnnotations.NAMED_QUERIES, modelBuildingContext);
            namedJpqlQueries.value((NamedQuery[])namedJpqlQueryList.toArray(NamedQuery[]::new));
        }
        if (namedHqlQueryList != null) {
            NamedQueriesAnnotation namedQueries = (NamedQueriesAnnotation)classDetails.replaceAnnotationUsage(HibernateAnnotations.NAMED_QUERY, HibernateAnnotations.NAMED_QUERIES, modelBuildingContext);
            namedQueries.value((org.hibernate.annotations.NamedQuery[])namedHqlQueryList.toArray(org.hibernate.annotations.NamedQuery[]::new));
        }
    }

    public static FlushModeType interpretFlushMode(FlushMode flushMode) {
        return switch (flushMode) {
            default -> throw new IncompatibleClassChangeError();
            case FlushMode.AUTO -> FlushModeType.AUTO;
            case FlushMode.ALWAYS -> FlushModeType.ALWAYS;
            case FlushMode.COMMIT -> FlushModeType.COMMIT;
            case FlushMode.MANUAL -> FlushModeType.MANUAL;
        };
    }

    public static QueryHint[] collectQueryHints(List<JaxbQueryHintImpl> jaxbHints, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbHints)) {
            return NO_HINTS;
        }
        QueryHint[] hints = new QueryHint[jaxbHints.size()];
        ModelsContext modelBuildingContext = xmlDocumentContext.getModelBuildingContext();
        for (int i = 0; i < jaxbHints.size(); ++i) {
            QueryHintJpaAnnotation queryHintUsage = (QueryHintJpaAnnotation)((Object)JpaAnnotations.QUERY_HINT.createUsage(modelBuildingContext));
            hints[i] = queryHintUsage;
            JaxbQueryHint jaxbHint = jaxbHints.get(i);
            queryHintUsage.name(jaxbHint.getName());
            queryHintUsage.value(jaxbHint.getValue());
        }
        return hints;
    }

    public static void applyNamedNativeQueries(JaxbEntityImpl jaxbEntity, MutableClassDetails classDetails, JaxbEntityMappingsImpl jaxbRoot, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbEntity.getNamedNativeQueries())) {
            return;
        }
        ModelsContext modelBuildingContext = xmlDocumentContext.getModelBuildingContext();
        ArrayList<Object> namedQueryList = null;
        ArrayList<Object> namedJpaQueryList = null;
        for (int i = 0; i < jaxbEntity.getNamedNativeQueries().size(); ++i) {
            Object namedQuery;
            JaxbNamedNativeQueryImpl jaxbNamedQuery = jaxbEntity.getNamedNativeQueries().get(i);
            if (QueryProcessing.needsJpaNativeQuery(jaxbNamedQuery)) {
                if (namedJpaQueryList == null) {
                    namedJpaQueryList = new ArrayList<Object>();
                }
                namedQuery = (NamedNativeQueryJpaAnnotation)((Object)JpaAnnotations.NAMED_NATIVE_QUERY.createUsage(modelBuildingContext));
                namedJpaQueryList.add(namedQuery);
                ((NamedNativeQueryJpaAnnotation)namedQuery).apply(jaxbNamedQuery, xmlDocumentContext);
                continue;
            }
            if (namedQueryList == null) {
                namedQueryList = new ArrayList<Object>();
            }
            namedQuery = (NamedNativeQueryAnnotation)HibernateAnnotations.NAMED_NATIVE_QUERY.createUsage(modelBuildingContext);
            namedQueryList.add(namedQuery);
            ((NamedNativeQueryAnnotation)namedQuery).apply(jaxbNamedQuery, xmlDocumentContext);
        }
        if (namedJpaQueryList != null) {
            NamedNativeQueriesJpaAnnotation namedQueriesUsage = (NamedNativeQueriesJpaAnnotation)classDetails.replaceAnnotationUsage(JpaAnnotations.NAMED_NATIVE_QUERY, JpaAnnotations.NAMED_NATIVE_QUERIES, modelBuildingContext);
            namedQueriesUsage.value((jakarta.persistence.NamedNativeQuery[])namedJpaQueryList.toArray(jakarta.persistence.NamedNativeQuery[]::new));
        }
        if (namedQueryList != null) {
            NamedNativeQueriesAnnotation namedQueriesUsage = (NamedNativeQueriesAnnotation)classDetails.replaceAnnotationUsage(HibernateAnnotations.NAMED_NATIVE_QUERY, HibernateAnnotations.NAMED_NATIVE_QUERIES, modelBuildingContext);
            namedQueriesUsage.value((NamedNativeQuery[])namedQueryList.toArray(NamedNativeQuery[]::new));
        }
    }

    private static boolean needsJpaNativeQuery(JaxbNamedNativeQueryImpl jaxbNamedQuery) {
        return CollectionHelper.isNotEmpty(jaxbNamedQuery.getHints()) || CollectionHelper.isNotEmpty(jaxbNamedQuery.getColumnResult()) || CollectionHelper.isNotEmpty(jaxbNamedQuery.getConstructorResult()) || CollectionHelper.isNotEmpty(jaxbNamedQuery.getEntityResult());
    }

    public static ColumnResult[] extractColumnResults(List<JaxbColumnResultImpl> jaxbColumnResultList, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbColumnResultList)) {
            return NO_COLUMN_RESULTS;
        }
        ModelsContext modelBuildingContext = xmlDocumentContext.getModelBuildingContext();
        ColumnResult[] columnResults = new ColumnResult[jaxbColumnResultList.size()];
        for (int i = 0; i < jaxbColumnResultList.size(); ++i) {
            ColumnResultJpaAnnotation columnResult = (ColumnResultJpaAnnotation)((Object)JpaAnnotations.COLUMN_RESULT.createUsage(modelBuildingContext));
            columnResults[i] = columnResult;
            JaxbColumnResultImpl jaxbColumnResult = jaxbColumnResultList.get(i);
            columnResult.name(jaxbColumnResult.getName());
            if (!StringHelper.isNotEmpty(jaxbColumnResult.getClazz())) continue;
            columnResult.type(xmlDocumentContext.resolveJavaType(jaxbColumnResult.getClazz()).toJavaClass());
        }
        return columnResults;
    }

    public static ConstructorResult[] extractConstructorResults(List<JaxbConstructorResultImpl> jaxbConstructorResultList, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbConstructorResultList)) {
            return NO_CONSTRUCTOR_RESULTS;
        }
        ModelsContext modelBuildingContext = xmlDocumentContext.getModelBuildingContext();
        ConstructorResult[] constructorResults = new ConstructorResult[jaxbConstructorResultList.size()];
        for (int i = 0; i < jaxbConstructorResultList.size(); ++i) {
            ColumnResult[] columnResults;
            ConstructorResultJpaAnnotation constructorResult = (ConstructorResultJpaAnnotation)((Object)JpaAnnotations.CONSTRUCTOR_RESULT.createUsage(modelBuildingContext));
            constructorResults[i] = constructorResult;
            JaxbConstructorResultImpl jaxbConstructorResult = jaxbConstructorResultList.get(i);
            constructorResult.targetClass(xmlDocumentContext.resolveJavaType(jaxbConstructorResult.getTargetClass()).toJavaClass());
            if (!CollectionHelper.isNotEmpty(jaxbConstructorResult.getColumns()) || (columnResults = QueryProcessing.extractColumnResults(jaxbConstructorResult.getColumns(), xmlDocumentContext)) == null) continue;
            constructorResult.columns(columnResults);
        }
        return constructorResults;
    }

    public static EntityResult[] extractEntityResults(List<JaxbEntityResultImpl> jaxbEntityResults, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbEntityResults)) {
            return NO_ENTITY_RESULTS;
        }
        ModelsContext modelBuildingContext = xmlDocumentContext.getModelBuildingContext();
        EntityResult[] entityResults = new EntityResult[jaxbEntityResults.size()];
        for (int i = 0; i < jaxbEntityResults.size(); ++i) {
            FieldResult[] fieldResults;
            EntityResultJpaAnnotation entityResult = (EntityResultJpaAnnotation)((Object)JpaAnnotations.ENTITY_RESULT.createUsage(modelBuildingContext));
            entityResults[i] = entityResult;
            JaxbEntityResultImpl jaxbEntityResult = jaxbEntityResults.get(i);
            entityResult.entityClass(xmlDocumentContext.resolveJavaType(jaxbEntityResult.getEntityClass()).toJavaClass());
            if (StringHelper.isNotEmpty(jaxbEntityResult.getDiscriminatorColumn())) {
                entityResult.discriminatorColumn(jaxbEntityResult.getDiscriminatorColumn());
            }
            if (jaxbEntityResult.getLockMode() != null) {
                entityResult.lockMode(jaxbEntityResult.getLockMode());
            }
            if ((fieldResults = QueryProcessing.extractFieldResults(jaxbEntityResult.getFieldResult(), xmlDocumentContext)) == null) continue;
            entityResult.fields(fieldResults);
        }
        return entityResults;
    }

    private static FieldResult[] extractFieldResults(List<JaxbFieldResultImpl> jaxbFieldResults, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbFieldResults)) {
            return null;
        }
        ModelsContext modelBuildingContext = xmlDocumentContext.getModelBuildingContext();
        FieldResult[] fieldResults = new FieldResult[jaxbFieldResults.size()];
        for (int i = 0; i < jaxbFieldResults.size(); ++i) {
            FieldResultJpaAnnotation fieldResult = (FieldResultJpaAnnotation)((Object)JpaAnnotations.FIELD_RESULT.createUsage(modelBuildingContext));
            fieldResults[i] = fieldResult;
            JaxbFieldResultImpl jaxbFieldResult = jaxbFieldResults.get(i);
            fieldResult.name(jaxbFieldResult.getName());
            fieldResult.column(jaxbFieldResult.getColumn());
        }
        return fieldResults;
    }

    public static void applyNamedProcedureQueries(JaxbEntityImpl jaxbEntity, MutableClassDetails classDetails, XmlDocumentContext xmlDocumentContext) {
        List<JaxbNamedStoredProcedureQueryImpl> jaxbQueries = jaxbEntity.getNamedStoredProcedureQueries();
        if (CollectionHelper.isEmpty(jaxbQueries)) {
            return;
        }
        ModelsContext modelBuildingContext = xmlDocumentContext.getModelBuildingContext();
        NamedStoredProcedureQueriesJpaAnnotation namedQueriesUsage = (NamedStoredProcedureQueriesJpaAnnotation)classDetails.replaceAnnotationUsage(JpaAnnotations.NAMED_STORED_PROCEDURE_QUERY, JpaAnnotations.NAMED_STORED_PROCEDURE_QUERIES, modelBuildingContext);
        NamedStoredProcedureQuery[] namedQueries = new NamedStoredProcedureQuery[jaxbQueries.size()];
        namedQueriesUsage.value(namedQueries);
        for (int i = 0; i < jaxbQueries.size(); ++i) {
            NamedStoredProcedureQueryJpaAnnotation namedQuery = (NamedStoredProcedureQueryJpaAnnotation)((Object)JpaAnnotations.NAMED_STORED_PROCEDURE_QUERY.createUsage(modelBuildingContext));
            namedQueries[i] = namedQuery;
            JaxbNamedStoredProcedureQueryImpl jaxbQuery = jaxbQueries.get(i);
            namedQuery.apply(jaxbQuery, xmlDocumentContext);
        }
    }

    public static StoredProcedureParameter[] collectParameters(List<JaxbStoredProcedureParameterImpl> jaxbParameters, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(jaxbParameters)) {
            return NO_PARAMS;
        }
        ModelsContext ModelsContext2 = xmlDocumentContext.getModelBuildingContext();
        StoredProcedureParameter[] result = new StoredProcedureParameter[jaxbParameters.size()];
        for (int i = 0; i < jaxbParameters.size(); ++i) {
            StoredProcedureParameterJpaAnnotation param = (StoredProcedureParameterJpaAnnotation)((Object)JpaAnnotations.STORED_PROCEDURE_PARAMETER.createUsage(ModelsContext2));
            result[i] = param;
            JaxbStoredProcedureParameterImpl jaxbParam = jaxbParameters.get(i);
            param.apply(jaxbParam, xmlDocumentContext);
        }
        return result;
    }

    public static Class<?>[] collectResultClasses(List<String> resultClasses, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(resultClasses)) {
            return NO_CLASSES;
        }
        Class[] result = new Class[resultClasses.size()];
        for (int i = 0; i < resultClasses.size(); ++i) {
            result[i] = xmlDocumentContext.resolveJavaType(resultClasses.get(i)).toJavaClass();
        }
        return result;
    }

    public static String[] collectResultMappings(List<String> resultClasses, XmlDocumentContext xmlDocumentContext) {
        if (CollectionHelper.isEmpty(resultClasses)) {
            return ArrayHelper.EMPTY_STRING_ARRAY;
        }
        return (String[])resultClasses.toArray(String[]::new);
    }
}

