/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.range;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import java.util.Objects;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.query.range.Range;

record LowerBound<U extends Comparable<U>>(U bound, boolean open) implements Range<U>
{
    LowerBound {
        Objects.requireNonNull(bound, "bound is null");
    }

    @Override
    public Predicate toPredicate(Path<? extends U> path, CriteriaBuilder builder) {
        return this.open ? builder.greaterThan(path, this.bound) : builder.greaterThanOrEqualTo(path, this.bound);
    }

    @Override
    public Class<? extends U> getType() {
        return ReflectHelper.getClass(this.bound);
    }
}

