/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.from;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.from.SqmCrossJoin;
import org.hibernate.query.sqm.tree.from.SqmEntityJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;

public class SqmFromClause
implements Serializable {
    private List<SqmRoot<?>> domainRoots;

    public SqmFromClause() {
    }

    public SqmFromClause(int expectedNumberOfRoots) {
        this.domainRoots = CollectionHelper.arrayList(expectedNumberOfRoots);
    }

    private SqmFromClause(SqmFromClause original, SqmCopyContext context) {
        if (original.domainRoots != null) {
            this.domainRoots = new ArrayList(original.domainRoots.size());
            for (SqmRoot<?> domainRoot : original.domainRoots) {
                this.domainRoots.add((SqmRoot<?>)domainRoot.copy(context));
            }
        }
    }

    public SqmFromClause copy(SqmCopyContext context) {
        return new SqmFromClause(this, context);
    }

    public List<SqmRoot<?>> getRoots() {
        return this.domainRoots == null ? Collections.emptyList() : Collections.unmodifiableList(this.domainRoots);
    }

    public void setRoots(List<SqmRoot<?>> domainRoots) {
        this.domainRoots = domainRoots;
    }

    public void addRoot(SqmRoot<?> root) {
        if (this.domainRoots == null) {
            this.domainRoots = new ArrayList();
        }
        this.domainRoots.add(root);
    }

    public void visitRoots(Consumer<SqmRoot<?>> consumer) {
        if (this.domainRoots != null) {
            this.domainRoots.forEach(consumer);
        }
    }

    public int getNumberOfRoots() {
        return this.domainRoots == null ? 0 : this.domainRoots.size();
    }

    public void appendHqlString(StringBuilder sb, SqmRenderContext context) {
        String separator = " ";
        for (SqmRoot<?> root : this.getRoots()) {
            sb.append(separator);
            if (root.isCorrelated()) {
                if (root.containsOnlyInnerJoins()) {
                    this.appendJoins(root, root.getCorrelationParent().resolveAlias(context), sb, context);
                } else {
                    sb.append(root.getCorrelationParent().resolveAlias(context));
                    sb.append(' ').append(root.resolveAlias(context));
                    SqmFromClause.appendJoins(root, sb, context);
                    SqmFromClause.appendTreatJoins(root, sb, context);
                }
            } else {
                sb.append(root.getEntityName());
                sb.append(' ').append(root.resolveAlias(context));
                SqmFromClause.appendJoins(root, sb, context);
                SqmFromClause.appendTreatJoins(root, sb, context);
            }
            separator = ", ";
        }
    }

    public static void appendJoins(SqmFrom<?, ?> sqmFrom, StringBuilder sb, SqmRenderContext context) {
        for (SqmJoin<?, ?> sqmJoin : sqmFrom.getSqmJoins()) {
            switch (sqmJoin.getSqmJoinType()) {
                case LEFT: {
                    sb.append(" left join ");
                    break;
                }
                case RIGHT: {
                    sb.append(" right join ");
                    break;
                }
                case INNER: {
                    sb.append(" join ");
                    break;
                }
                case FULL: {
                    sb.append(" full join ");
                    break;
                }
                case CROSS: {
                    sb.append(" cross join ");
                }
            }
            if (sqmJoin instanceof SqmAttributeJoin) {
                SqmAttributeJoin attributeJoin = (SqmAttributeJoin)sqmJoin;
                if (sqmFrom instanceof SqmTreatedPath) {
                    SqmTreatedPath treatedPath = (SqmTreatedPath)((Object)sqmFrom);
                    sb.append("treat(");
                    treatedPath.getWrappedPath().appendHqlString(sb, context);
                    sb.append(" as ").append(treatedPath.getTreatTarget().getTypeName()).append(')');
                } else {
                    sb.append(sqmFrom.resolveAlias(context));
                }
                sb.append('.').append(attributeJoin.getAttribute().getName());
                sb.append(' ').append(sqmJoin.resolveAlias(context));
                if (attributeJoin.getJoinPredicate() != null) {
                    sb.append(" on ");
                    attributeJoin.getJoinPredicate().appendHqlString(sb, context);
                }
                SqmFromClause.appendJoins(sqmJoin, sb, context);
                continue;
            }
            if (sqmJoin instanceof SqmCrossJoin) {
                SqmCrossJoin sqmCrossJoin = (SqmCrossJoin)sqmJoin;
                sb.append(sqmCrossJoin.getEntityName());
                sb.append(' ').append(sqmCrossJoin.resolveAlias(context));
                SqmFromClause.appendJoins(sqmJoin, sb, context);
                continue;
            }
            if (sqmJoin instanceof SqmEntityJoin) {
                SqmEntityJoin sqmEntityJoin = (SqmEntityJoin)sqmJoin;
                sb.append(sqmEntityJoin.getEntityName());
                sb.append(' ').append(sqmJoin.resolveAlias(context));
                if (sqmEntityJoin.getJoinPredicate() != null) {
                    sb.append(" on ");
                    sqmEntityJoin.getJoinPredicate().appendHqlString(sb, context);
                }
                SqmFromClause.appendJoins(sqmJoin, sb, context);
                continue;
            }
            throw new UnsupportedOperationException("Unsupported join: " + String.valueOf(sqmJoin));
        }
    }

    private void appendJoins(SqmFrom<?, ?> sqmFrom, String correlationPrefix, StringBuilder sb, SqmRenderContext context) {
        String separator = "";
        for (SqmJoin<?, ?> sqmJoin : sqmFrom.getSqmJoins()) {
            assert (sqmJoin instanceof SqmAttributeJoin);
            sb.append(separator);
            sb.append(correlationPrefix).append('.');
            sb.append(((SqmAttributeJoin)sqmJoin).getAttribute().getName());
            sb.append(' ').append(sqmJoin.resolveAlias(context));
            SqmFromClause.appendJoins(sqmJoin, sb, context);
            separator = ", ";
        }
    }

    public static void appendTreatJoins(SqmFrom<?, ?> sqmFrom, StringBuilder sb, SqmRenderContext context) {
        for (SqmFrom sqmFrom2 : sqmFrom.getSqmTreats()) {
            SqmFromClause.appendJoins(sqmFrom2, sb, context);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof SqmFromClause)) return false;
        SqmFromClause that = (SqmFromClause)object;
        if (this.getNumberOfRoots() != that.getNumberOfRoots()) return false;
        if (!this.equalRoots(this.getRoots(), that.getRoots())) return false;
        return true;
    }

    private boolean equalRoots(List<SqmRoot<?>> theseRoots, List<SqmRoot<?>> thoseRoots) {
        for (int i = 0; i < theseRoots.size(); ++i) {
            SqmRoot<?> thisRoot = theseRoots.get(i);
            SqmRoot<?> thatRoot = thoseRoots.get(i);
            if (Objects.equals(thisRoot.getEntityName(), thatRoot.getEntityName()) && Objects.equals(thisRoot.getExplicitAlias(), thatRoot.getExplicitAlias()) && Objects.equals(thisRoot, thatRoot) && thisRoot.getNumberOfJoins() == thatRoot.getNumberOfJoins() && this.equalsJoins(thisRoot.getSqmJoins(), thatRoot.getSqmJoins())) continue;
            return false;
        }
        return true;
    }

    private boolean equalsJoins(List<? extends SqmJoin<?, ?>> theseJoins, List<? extends SqmJoin<?, ?>> thoseJoins) {
        for (int i = 0; i < theseJoins.size(); ++i) {
            SqmJoin<?, ?> thisJoin = theseJoins.get(i);
            SqmJoin<?, ?> thatJoin = thoseJoins.get(i);
            if (Objects.equals(thisJoin.getNavigablePath(), thatJoin.getNavigablePath()) && Objects.equals(thisJoin.getExplicitAlias(), thatJoin.getExplicitAlias()) && Objects.equals(thisJoin.getJoinType(), thatJoin.getJoinType()) && Objects.equals(thisJoin, thatJoin) && thisJoin.getNumberOfJoins() == thatJoin.getNumberOfJoins() && Objects.equals(thisJoin.getOn(), thatJoin.getOn()) && this.equalsJoins(thisJoin.getSqmJoins(), thatJoin.getSqmJoins())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.getNumberOfRoots();
    }
}

