/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.workflow;

import org.keycloak.events.Event;
import org.keycloak.events.EventListenerProvider;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.workflow.ResourceType;
import org.keycloak.models.workflow.WorkflowEvent;
import org.keycloak.models.workflow.WorkflowsManager;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.provider.ProviderEventListener;

public class WorkflowEventListener
implements EventListenerProvider,
ProviderEventListener {
    private final KeycloakSession session;

    public WorkflowEventListener(KeycloakSession session) {
        this.session = session;
    }

    public void onEvent(Event event) {
        WorkflowEvent workflowEvent = ResourceType.USERS.toEvent(event);
        this.trySchedule(workflowEvent);
    }

    public void onEvent(AdminEvent event, boolean includeRepresentation) {
        WorkflowEvent workflowEvent = ResourceType.USERS.toEvent(event);
        this.trySchedule(workflowEvent);
    }

    public void onEvent(ProviderEvent event) {
        RealmModel realm = this.session.getContext().getRealm();
        if (realm == null) {
            return;
        }
        this.trySchedule(ResourceType.USERS.toEvent(event));
    }

    private void trySchedule(WorkflowEvent event) {
        if (event != null) {
            WorkflowsManager manager = new WorkflowsManager(this.session);
            manager.processEvent(event);
        }
    }

    public void close() {
    }
}

