/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.classpathDiff.impl;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.classpathDiff.impl.ClassFileWithContentsProvider;
import org.jetbrains.kotlin.incremental.classpathDiff.impl.PrefixBasedSnapshotter;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\f\u001a\u00020\rJ(\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bJ\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u00112\u0006\u0010\u0012\u001a\u00020\rH\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/incremental/classpathDiff/impl/PrefixBasedSnapshotter;", "", "classNameToClassFileMap", "", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "Lorg/jetbrains/kotlin/incremental/classpathDiff/impl/ClassFileWithContentsProvider;", "<init>", "(Ljava/util/Map;)V", "sortedInternalNames", "", "getSetOfClasses", "", "classPrefix", "", "addedClasses", "processedClasses", "getRangeByPredicate", "", "prefix", "incremental-compilation-impl"})
@SourceDebugExtension(value={"SMAP\nInlinedClassSnapshotter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlinedClassSnapshotter.kt\norg/jetbrains/kotlin/incremental/classpathDiff/impl/PrefixBasedSnapshotter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,210:1\n1068#2:211\n1480#2,5:212\n*S KotlinDebug\n*F\n+ 1 InlinedClassSnapshotter.kt\norg/jetbrains/kotlin/incremental/classpathDiff/impl/PrefixBasedSnapshotter\n*L\n122#1:211\n130#1:212,5\n*E\n"})
final class PrefixBasedSnapshotter {
    @NotNull
    private final List<JvmClassName> sortedInternalNames;

    public PrefixBasedSnapshotter(@NotNull Map<JvmClassName, ClassFileWithContentsProvider> classNameToClassFileMap) {
        Intrinsics.checkNotNullParameter(classNameToClassFileMap, "classNameToClassFileMap");
        Iterable $this$sortedBy$iv = classNameToClassFileMap.keySet();
        boolean $i$f$sortedBy = false;
        this.sortedInternalNames = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a2, T b2) {
                JvmClassName it = (JvmClassName)a2;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getInternalName());
                it = (JvmClassName)b2;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getInternalName()));
            }
        });
    }

    @NotNull
    public final Set<JvmClassName> getSetOfClasses(@NotNull String classPrefix) {
        Intrinsics.checkNotNullParameter(classPrefix, "classPrefix");
        return CollectionsKt.toSet(this.getRangeByPredicate(classPrefix));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<JvmClassName> getSetOfClasses(@NotNull Set<? extends JvmClassName> addedClasses, @NotNull Set<? extends JvmClassName> processedClasses) {
        void $this$flatMapTo$iv;
        Intrinsics.checkNotNullParameter(addedClasses, "addedClasses");
        Intrinsics.checkNotNullParameter(processedClasses, "processedClasses");
        Set accumulator = new LinkedHashSet();
        Iterable iterable = addedClasses;
        Collection destination$iv = accumulator;
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            JvmClassName addedClass = (JvmClassName)element$iv;
            boolean bl = false;
            String string = addedClass.getInternalName();
            Intrinsics.checkNotNullExpressionValue(string, "getInternalName(...)");
            Iterable<JvmClassName> list$iv = this.getRangeByPredicate(string);
            CollectionsKt.addAll(destination$iv, list$iv);
        }
        CollectionsKt.retainAll(destination$iv, arg_0 -> PrefixBasedSnapshotter.getSetOfClasses$lambda$1(processedClasses, arg_0));
        return accumulator;
    }

    private final Iterable<JvmClassName> getRangeByPredicate(String prefix) {
        return new Iterable<JvmClassName>(this, prefix){
            final /* synthetic */ PrefixBasedSnapshotter this$0;
            final /* synthetic */ String $prefix;
            {
                this.this$0 = $receiver;
                this.$prefix = $prefix;
            }

            public getRangeByPredicate.iterator.1 iterator() {
                return new Iterator<JvmClassName>(this.this$0, this.$prefix){
                    private int position;
                    final /* synthetic */ PrefixBasedSnapshotter this$0;
                    final /* synthetic */ String $prefix;
                    {
                        void $this$binarySearchBy_u24default$iv2;
                        this.this$0 = $receiver;
                        this.$prefix = $prefix;
                        List list = PrefixBasedSnapshotter.access$getSortedInternalNames$p($receiver);
                        Comparable key$iv = (Comparable)((Object)$prefix);
                        int fromIndex$iv = 0;
                        int toIndex$iv = $this$binarySearchBy_u24default$iv2.size();
                        boolean $i$f$binarySearchBy = false;
                        this.position = CollectionsKt.binarySearch($this$binarySearchBy_u24default$iv2, fromIndex$iv, toIndex$iv, (Function1)new Function1<JvmClassName, Integer>(key$iv){
                            final /* synthetic */ Comparable $key;
                            {
                                this.$key = $key;
                            }

                            /*
                             * Ignored method signature, as it can't be verified against descriptor
                             */
                            public final Integer invoke(Object it) {
                                JvmClassName it2 = (JvmClassName)it;
                                boolean bl = false;
                                return ComparisonsKt.compareValues((Comparable)((Object)it2.getInternalName()), this.$key);
                            }
                        });
                        if (this.position >= 0) {
                            int $this$binarySearchBy_u24default$iv2 = this.position;
                            this.position = $this$binarySearchBy_u24default$iv2 + 1;
                        } else {
                            int trueInsertionPoint;
                            this.position = trueInsertionPoint = -(this.position + 1);
                        }
                    }

                    public final int getPosition() {
                        return this.position;
                    }

                    public final void setPosition(int n2) {
                        this.position = n2;
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public boolean hasNext() {
                        if (this.position >= PrefixBasedSnapshotter.access$getSortedInternalNames$p(this.this$0).size()) return false;
                        String string = ((JvmClassName)PrefixBasedSnapshotter.access$getSortedInternalNames$p(this.this$0).get(this.position)).getInternalName();
                        Intrinsics.checkNotNullExpressionValue(string, "getInternalName(...)");
                        if (!StringsKt.startsWith$default(string, this.$prefix, false, 2, null)) return false;
                        return true;
                    }

                    public JvmClassName next() {
                        int n2 = this.position;
                        this.position = n2 + 1;
                        return (JvmClassName)PrefixBasedSnapshotter.access$getSortedInternalNames$p(this.this$0).get(this.position - 1);
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                    }
                };
            }
        };
    }

    private static final boolean getSetOfClasses$lambda$1(Set $processedClasses, JvmClassName it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return !$processedClasses.contains(it);
    }

    public static final /* synthetic */ List access$getSortedInternalNames$p(PrefixBasedSnapshotter $this) {
        return $this.sortedInternalNames;
    }
}

