
# Device configuration file


## Terminology

__AM__ - SHARP aggregation manager
__AN__ - SHARP aggregation node

## Overview

The device configuration feature enables changing AN configurations by the AM.
The device configurations are loaded to the AM from a configuration file specified by *device_configuration_file* parameter.

## Configuration file format

The configuration file consists of a configuration table block.
The table has a header and a footer, the header is the text: START_AN_PORT_RESOURCES, followed by a line that describes the meaning of each column.
The footer is the text: END_AN_PORT_RESOURCES.

For example:

START_AN_PORT_RESOURCES
NodeGUID,    PortNum, ResponderBufferCap, ResponderPackets, NumFlows
0x001,       2,       10,                 10,               1
0x002,       2,       10                  10,               1
END_AN_PORT_RESOURCES


## AN port resources table

AN port resources table allows configuring credits and number of streaming aggregation flows for AN port.

### Supported fields
- NodeGUID - Node GUID of the Aggregation Node (not the switch)
- PortNum  - Port number on the switch of the Aggregation node of the specified GUID
- ResponderPackets - Number of packets from the AN.
- ResponderBufferCap - Buffer size in AN port.
- NumFlows - Number of flows allowed for the port (must be the same for all records of same AN)

### Special values
- NodeGUID set to 0, means that the configuration in this line will be default configuration for all the ANs that are not specified in this table.
- PortNum set to 255, means that the configuration in this line will be the default for all ports of the AN specified in this line.


Notes:
1. Quantum switches do not support different number of flows for different ports.
2. All values should be configured according to the device capabilities.


### Example
The following table will result with the following configuration

START_AN_PORT_RESOURCES
NodeGUID,   PortNum,    ResponderBufferCap, ResponderPackets, NumFlows
0x0000,     0,          1,                  1,                1
0x0001,     255,        2,                  2,                1
0x0001,     3,          3,                  3,                1
END_AN_PORT_RESOURCES


The above example sets the default configuration to:
- ResponderBufferCap = 1
- ResponderPackets = 1
- NumFlows = 1

Default for all ports of AN with Node GUID 0x0001:
- ResponderBufferCap = 2
- ResponderPackets = 2
- NumFlows = 1

Port 3 of AN with Node GUID 0x0001
- ResponderBufferCap = 3
- ResponderPackets = 3
- NumFlows = 1

