/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.forecast.rest;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.forecast.settings.ForecastEnabledSetting;
import org.opensearch.forecast.stats.ForecastStats;
import org.opensearch.forecast.transport.StatsForecasterAction;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.timeseries.rest.RestStatsAction;
import org.opensearch.timeseries.transport.StatsRequest;
import org.opensearch.timeseries.util.DiscoveryNodeFilterer;
import org.opensearch.transport.client.node.NodeClient;
import org.owasp.encoder.Encode;

public class RestStatsForecasterAction
extends RestStatsAction {
    private static final String STATS_FORECASTER_ACTION = "stats_forecaster";

    public RestStatsForecasterAction(ForecastStats timeSeriesStats, DiscoveryNodeFilterer nodeFilter) {
        super(timeSeriesStats, nodeFilter);
    }

    public String getName() {
        return STATS_FORECASTER_ACTION;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        if (!ForecastEnabledSetting.isForecastEnabled()) {
            throw new IllegalStateException("Forecast functionality is disabled. To enable update plugins.forecast.enabled to true");
        }
        try {
            StatsRequest forecastStatsRequest = this.getRequest(request);
            return channel -> client.execute((ActionType)StatsForecasterAction.INSTANCE, (ActionRequest)forecastStatsRequest, (ActionListener)new RestToXContentListener(channel));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(Encode.forHtml((String)e.getMessage()));
        }
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_forecast/{nodeId}/stats/"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_forecast/{nodeId}/stats/{stat}"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_forecast/stats/"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_forecast/stats/{stat}"));
    }
}

