/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.retrying.BasicResultRetryAlgorithm;
import com.google.api.gax.retrying.ResultRetryAlgorithm;
import com.google.api.gax.rpc.AbortedException;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.storage.BidiAppendableWrite;
import com.google.cloud.storage.BidiBlobWriteSessionConfig;
import com.google.cloud.storage.BlobAppendableUpload;
import com.google.cloud.storage.BlobAppendableUploadImpl;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.ByteStringStrategy;
import com.google.cloud.storage.DefaultBlobWriteSessionConfig;
import com.google.cloud.storage.FlushPolicy;
import com.google.cloud.storage.GrpcStorageImpl;
import com.google.cloud.storage.Hasher;
import com.google.cloud.storage.ResumableMedia;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.TransportCompatibility;
import com.google.cloud.storage.UnifiedOpts;
import com.google.cloud.storage.WritableByteChannelSession;
import com.google.storage.v2.BidiWriteObjectRequest;
import com.google.storage.v2.BidiWriteObjectResponse;
import com.google.storage.v2.GetObjectRequest;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@BetaApi
@TransportCompatibility(value={TransportCompatibility.Transport.GRPC})
@Immutable
public final class BlobAppendableUploadConfig {
    private static final BlobAppendableUploadConfig INSTANCE = new BlobAppendableUploadConfig(FlushPolicy.minFlushSize(262144), Hasher.enabled(), CloseAction.CLOSE_WITHOUT_FINALIZING);
    private final FlushPolicy flushPolicy;
    private final Hasher hasher;
    private final CloseAction closeAction;

    private BlobAppendableUploadConfig(FlushPolicy flushPolicy, Hasher hasher, CloseAction closeAction) {
        this.flushPolicy = flushPolicy;
        this.hasher = hasher;
        this.closeAction = closeAction;
    }

    @BetaApi
    public FlushPolicy getFlushPolicy() {
        return this.flushPolicy;
    }

    @BetaApi
    public BlobAppendableUploadConfig withFlushPolicy(FlushPolicy flushPolicy) {
        Objects.requireNonNull(flushPolicy, "flushPolicy must be non null");
        if (this.flushPolicy.equals(flushPolicy)) {
            return this;
        }
        return new BlobAppendableUploadConfig(flushPolicy, this.hasher, this.closeAction);
    }

    @BetaApi
    public CloseAction getCloseAction() {
        return this.closeAction;
    }

    @BetaApi
    public BlobAppendableUploadConfig withCloseAction(CloseAction closeAction) {
        Objects.requireNonNull(closeAction, "closeAction must be non null");
        if (this.closeAction == closeAction) {
            return this;
        }
        return new BlobAppendableUploadConfig(this.flushPolicy, this.hasher, closeAction);
    }

    @BetaApi
    boolean getCrc32cValidationEnabled() {
        return Hasher.enabled().equals(this.hasher);
    }

    @BetaApi
    BlobAppendableUploadConfig withCrc32cValidationEnabled(boolean enabled) {
        if (enabled && Hasher.enabled().equals(this.hasher)) {
            return this;
        }
        if (!enabled && Hasher.noop().equals(this.hasher)) {
            return this;
        }
        return new BlobAppendableUploadConfig(this.flushPolicy, enabled ? Hasher.enabled() : Hasher.noop(), this.closeAction);
    }

    @InternalApi
    Hasher getHasher() {
        return this.hasher;
    }

    @BetaApi
    public static BlobAppendableUploadConfig of() {
        return INSTANCE;
    }

    BlobAppendableUpload create(final GrpcStorageImpl storage, BlobInfo info, UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> opts) {
        boolean takeOver = info.getGeneration() != null;
        BidiWriteObjectRequest req = takeOver ? storage.getBidiWriteObjectRequestForTakeover(info, opts) : storage.getBidiWriteObjectRequest(info, opts);
        BidiAppendableWrite baw = new BidiAppendableWrite(req, takeOver);
        WritableByteChannelSession<BlobAppendableUploadImpl.AppendableObjectBufferedWritableByteChannel, BidiWriteObjectResponse> build = ResumableMedia.gapic().write().bidiByteChannel((BidiStreamingCallable<BidiWriteObjectRequest, BidiWriteObjectResponse>)storage.storageClient.bidiWriteObjectCallable()).setHasher(this.getHasher()).setByteStringStrategy(ByteStringStrategy.copy()).appendable().withRetryConfig(storage.retrier.withAlg((ResultRetryAlgorithm<?>)new BasicResultRetryAlgorithm<com.google.storage.v2.Object>(){

            public boolean shouldRetry(Throwable previousThrowable, com.google.storage.v2.Object previousResponse) {
                StorageException se;
                Throwable cause;
                ApiException apiEx = null;
                if (previousThrowable instanceof StorageException && (cause = (se = (StorageException)((Object)previousThrowable)).getCause()) instanceof ApiException) {
                    apiEx = (ApiException)cause;
                }
                if (apiEx instanceof AbortedException) {
                    return true;
                }
                return storage.retryAlgorithmManager.idempotent().shouldRetry(previousThrowable, null);
            }
        })).buffered(this.getFlushPolicy()).setStartAsync((ApiFuture<BidiAppendableWrite>)ApiFutures.immediateFuture((Object)baw)).setGetCallable((UnaryCallable<GetObjectRequest, com.google.storage.v2.Object>)storage.storageClient.getObjectCallable()).setFinalizeOnClose(this.closeAction == CloseAction.FINALIZE_WHEN_CLOSING).build();
        return new BlobAppendableUploadImpl(new DefaultBlobWriteSessionConfig.DecoratedWritableByteChannelSession<BlobAppendableUploadImpl.AppendableObjectBufferedWritableByteChannel, BidiWriteObjectResponse>(build, BidiBlobWriteSessionConfig.Factory.WRITE_OBJECT_RESPONSE_BLOB_INFO_DECODER));
    }

    @BetaApi
    public static enum CloseAction {
        FINALIZE_WHEN_CLOSING,
        CLOSE_WITHOUT_FINALIZING;

    }
}

