/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.lang.reflect.Executable;
import java.util.logging.Logger;
import oracle.net.ns.BreakNetException;
import oracle.net.ns.ControlPacket;
import oracle.net.ns.DataDescriptorPacket;
import oracle.net.ns.DataPacket;
import oracle.net.ns.MarkerPacket;
import oracle.net.ns.NetException;
import oracle.net.ns.Packet;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

public class NetInputStream
extends InputStream
implements SQLnetDef {
    protected DataPacket daPkt;
    protected DataDescriptorPacket ddPkt;
    protected MarkerPacket mkPkt;
    protected SessionAtts sAtts;
    private ControlPacket controlPkt;
    private byte[] tmpBuf = new byte[1];
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;

    public NetInputStream() {
    }

    public NetInputStream(SessionAtts sAtts) {
        this.sAtts = sAtts;
        this.daPkt = new DataPacket(sAtts);
        this.ddPkt = new DataDescriptorPacket(this.daPkt, sAtts);
        this.controlPkt = new ControlPacket(sAtts);
    }

    @Override
    public int read() throws IOException, NetException, BreakNetException {
        return this.read(this.tmpBuf) < 0 ? -1 : this.tmpBuf[0] & 0xFF;
    }

    public int readB1() throws IOException, NetException, BreakNetException {
        return this.read();
    }

    public long readLongLSB(int bufSize) throws BreakNetException, NetException, IOException {
        long returnValue = 0L;
        boolean negative = false;
        if ((bufSize & 0x80) > 0) {
            bufSize &= 0x7F;
            negative = true;
        }
        if (this.sAtts.anoActive || this.daPkt.availableBytesToRead < bufSize) {
            int i2 = bufSize;
            int j2 = 0;
            while (i2 > 0) {
                returnValue |= ((long)this.read() & 0xFFL) << 8 * j2;
                --i2;
                ++j2;
            }
        } else {
            returnValue = this.daPkt.readLongLSB(bufSize);
        }
        return (long)(negative ? -1 : 1) * returnValue;
    }

    public long readLongMSB(int bufSize) throws BreakNetException, NetException, IOException {
        long returnValue = 0L;
        boolean negative = false;
        if ((bufSize & 0x80) > 0) {
            bufSize &= 0x7F;
            negative = true;
        }
        if (this.sAtts.anoActive || this.daPkt.availableBytesToRead < bufSize) {
            for (int i2 = bufSize; i2 > 0; --i2) {
                returnValue |= ((long)this.read() & 0xFFL) << 8 * (i2 - 1);
            }
        } else {
            returnValue = this.daPkt.readLongMSB(bufSize);
        }
        return (long)(negative ? -1 : 1) * returnValue;
    }

    @Override
    public int read(byte[] userBuffer) throws IOException, NetException, BreakNetException {
        return this.read(userBuffer, 0, userBuffer.length);
    }

    public boolean readZeroCopyIO(byte[] userBuffer, int offset, int[] bytesRead) throws IOException, NetException, BreakNetException {
        boolean markIsPresent = false;
        if (this.sAtts.nsOutputStream.available() > 0) {
            this.sAtts.nsOutputStream.flush();
        }
        this.ddPkt.receive();
        int nbOfBytes = this.ddPkt.totalDataLength;
        if ((this.ddPkt.descriptorFLaG & 1) != 0) {
            markIsPresent = true;
        }
        if (userBuffer.length < offset + nbOfBytes) {
            throw new IOException("Assertion Failed");
        }
        int bytesReadSoFar = this.ddPkt.packet.readLocal(userBuffer, offset, nbOfBytes);
        while (bytesReadSoFar < nbOfBytes) {
            try {
                if ((bytesReadSoFar += this.sAtts.ntInputStream.read(userBuffer, bytesReadSoFar + offset, nbOfBytes - bytesReadSoFar)) > 0) continue;
                throw new NetException(0);
            }
            catch (InterruptedIOException exp) {
                try {
                    this.sAtts.cOption.nt.sendUrgentByte(33);
                    this.sAtts.cOption.nt.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new NetException(504);
            }
        }
        bytesRead[0] = bytesReadSoFar;
        return markIsPresent;
    }

    @Override
    public int read(byte[] userBuffer, int off, int len) throws IOException, NetException, BreakNetException {
        int bytesRead = 0;
        try {
            while (true) {
                if (this.daPkt == null || this.daPkt.availableBytesToRead <= 0 || this.daPkt.type == 7) {
                    this.getNextPacket();
                    continue;
                }
                if ((bytesRead += this.daPkt.getDataFromBuffer(userBuffer, off + bytesRead, len - bytesRead)) >= len) break;
            }
        }
        catch (NetException ne) {
            if (ne.getErrorNumber() == 0) {
                return -1;
            }
            throw ne;
        }
        return bytesRead;
    }

    @Override
    public int available() throws IOException {
        return this.daPkt.availableBytesToRead;
    }

    protected void getNextPacket() throws IOException, NetException, BreakNetException {
        if (this.sAtts.dataEOF) {
            throw new NetException(202);
        }
        if (this.sAtts.nsOutputStream.available() > 0) {
            this.sAtts.nsOutputStream.flush();
        }
        this.daPkt.receive();
        switch (this.daPkt.type) {
            case 6: {
                this.daPkt.availableBytesToRead = this.daPkt.dataLen;
                break;
            }
            case 12: {
                this.mkPkt = new MarkerPacket(this.daPkt);
                this.daPkt.availableBytesToRead = 0;
                this.sAtts.onBreakReset = this.mkPkt.isBreakPkt();
                this.processMarker();
                throw new BreakNetException(500);
            }
            case 14: {
                this.daPkt.availableBytesToRead = 0;
                this.controlPkt.read(this.daPkt.buffer);
                break;
            }
            case 7: {
                this.daPkt.availableBytesToRead = this.daPkt.dataLen;
                break;
            }
            default: {
                throw new NetException(205);
            }
        }
    }

    protected void processMarker() throws IOException, NetException, BreakNetException {
    }

    void poolEnabled(boolean value) throws IOException, NetException, BreakNetException {
        if (value) {
            this.daPkt.setFlags(1);
        }
    }

    void reinitialize(SessionAtts _sAtts) throws NetException {
        this.sAtts = _sAtts;
    }

    Packet getCurrentPacket() throws IOException, NetException {
        return this.daPkt;
    }

    static {
        try {
            $$$methodRef$$$14 = NetInputStream.class.getDeclaredConstructor(SessionAtts.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = NetInputStream.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = NetInputStream.class.getDeclaredMethod("getCurrentPacket", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = NetInputStream.class.getDeclaredMethod("reinitialize", SessionAtts.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = NetInputStream.class.getDeclaredMethod("poolEnabled", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = NetInputStream.class.getDeclaredMethod("processMarker", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = NetInputStream.class.getDeclaredMethod("getNextPacket", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = NetInputStream.class.getDeclaredMethod("available", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = NetInputStream.class.getDeclaredMethod("read", byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = NetInputStream.class.getDeclaredMethod("readZeroCopyIO", byte[].class, Integer.TYPE, int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = NetInputStream.class.getDeclaredMethod("read", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = NetInputStream.class.getDeclaredMethod("readLongMSB", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = NetInputStream.class.getDeclaredMethod("readLongLSB", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = NetInputStream.class.getDeclaredMethod("readB1", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = NetInputStream.class.getDeclaredMethod("read", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

