/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Executable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.ROWSET})
public class OracleRow
implements Serializable,
Cloneable {
    private Object[] column;
    private Object[] changedColumn;
    private boolean[] isOriginalNull;
    private byte[] columnChangeFlag;
    private int noColumn;
    private int noColumnsInserted;
    private boolean rowDeleted;
    private boolean rowInserted;
    private static final byte COLUMN_CHANGED = 17;
    private boolean rowUpdated;
    long[][] columnTypeInfo;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;

    public OracleRow(int noColumn) {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$25, Level.FINEST, OracleRow.class, $$$methodRef$$$25, null, noColumn);
            }
            this.noColumn = 0;
            this.rowDeleted = false;
            this.rowInserted = false;
            this.rowUpdated = false;
            this.noColumn = noColumn;
            this.column = new Object[noColumn];
            this.changedColumn = new Object[noColumn];
            this.columnChangeFlag = new byte[noColumn];
            this.isOriginalNull = new boolean[noColumn];
            this.columnTypeInfo = new long[noColumn][];
            for (int i2 = 0; i2 < noColumn; ++i2) {
                this.columnChangeFlag[i2] = 0;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$25, Level.FINEST, OracleRow.class, $$$methodRef$$$25, null);
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, OracleRow.class, $$$methodRef$$$25, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$25, Level.FINEST, OracleRow.class, $$$methodRef$$$25, null, throwable2);
            }
            throw throwable;
        }
    }

    public OracleRow(int noColumn, boolean inserted) {
        this(noColumn);
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$26, Level.FINEST, OracleRow.class, $$$methodRef$$$26, null, noColumn, inserted);
            }
            this.rowInserted = inserted;
            this.noColumnsInserted = 0;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$26, Level.FINEST, OracleRow.class, $$$methodRef$$$26, null);
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, OracleRow.class, $$$methodRef$$$26, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$26, Level.FINEST, OracleRow.class, $$$methodRef$$$26, null, throwable2);
            }
            throw throwable;
        }
    }

    public OracleRow(int noColumn, Object[] obj) {
        this(noColumn);
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$27, Level.FINEST, OracleRow.class, $$$methodRef$$$27, null, noColumn, obj);
            }
            System.arraycopy(obj, 0, this.column, 0, noColumn);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$27, Level.FINEST, OracleRow.class, $$$methodRef$$$27, null);
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, OracleRow.class, $$$methodRef$$$27, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$27, Level.FINEST, OracleRow.class, $$$methodRef$$$27, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setColumnValue(int n2, Object object) {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, OracleRow.class, $$$methodRef$$$0, this, n2, object);
            }
            if (this.rowInserted) {
                ++this.noColumnsInserted;
            }
            this.column[columnIndex - true] = value;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, OracleRow.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleRow.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, OracleRow.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void markOriginalNull(int n2, boolean bl) throws SQLException {
        boolean bl2 = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, OracleRow.class, $$$methodRef$$$1, this, n2, bl);
            }
            this.isOriginalNull[columnIndex - true] = value;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, OracleRow.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleRow.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, OracleRow.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    boolean isOriginalNull(int n2) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void columnIndex;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, OracleRow.class, $$$methodRef$$$2, this, n2);
            }
            boolean bl2 = this.isOriginalNull[columnIndex - true];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, OracleRow.class, $$$methodRef$$$2, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleRow.class, $$$methodRef$$$2, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, OracleRow.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void updateObject(int n2, Object object) {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            void columnIndex;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, OracleRow.class, $$$methodRef$$$3, this, n2, object);
            }
            this.updateObject((int)columnIndex, value, null);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, OracleRow.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleRow.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, OracleRow.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void updateObject(int n2, Object object, long[] lArray) {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void typeInfo;
            void value;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, OracleRow.class, $$$methodRef$$$4, this, n2, object, lArray);
            }
            if (this.rowInserted) {
                ++this.noColumnsInserted;
            }
            this.columnChangeFlag[columnIndex - true] = 17;
            this.changedColumn[columnIndex - true] = value;
            this.columnTypeInfo[columnIndex - true] = typeInfo;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, OracleRow.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleRow.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, OracleRow.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    public void cancelRowUpdates() {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, OracleRow.class, $$$methodRef$$$5, this, new Object[0]);
            }
            this.noColumnsInserted = 0;
            for (int i2 = 0; i2 < this.noColumn; ++i2) {
                this.columnChangeFlag[i2] = 0;
            }
            this.changedColumn = null;
            this.changedColumn = new Object[this.noColumn];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, OracleRow.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleRow.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, OracleRow.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Object getColumn(int n2) {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void columnIndex;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, OracleRow.class, $$$methodRef$$$6, this, n2);
            }
            Object object = this.column[columnIndex - true];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, OracleRow.class, $$$methodRef$$$6, this, object);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleRow.class, $$$methodRef$$$6, this, null);
            }
            return object;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, OracleRow.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Object getModifiedColumn(int n2) {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void columnIndex;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, OracleRow.class, $$$methodRef$$$7, this, n2);
            }
            Object object = this.changedColumn[columnIndex - true];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, OracleRow.class, $$$methodRef$$$7, this, object);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleRow.class, $$$methodRef$$$7, this, null);
            }
            return object;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, OracleRow.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean isColumnChanged(int n2) {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void columnIndex;
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, OracleRow.class, $$$methodRef$$$8, this, n2);
            }
            boolean bl3 = bl2 = this.columnChangeFlag[columnIndex - true] == 17;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, OracleRow.class, $$$methodRef$$$8, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleRow.class, $$$methodRef$$$8, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, OracleRow.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    public boolean isRowUpdated() {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, OracleRow.class, $$$methodRef$$$9, this, new Object[0]);
            }
            if (bl) {
                this.debug($$$loggerRef$$$9, Level.FINEST, $$$methodRef$$$9, "OracleRow.isRowUpdated(), rowInserted=" + this.rowInserted + ", rowDeleted=" + this.rowDeleted);
            }
            if (this.rowInserted || this.rowDeleted) {
                boolean bl2 = false;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleRow.class, $$$methodRef$$$9, this, bl2);
                    ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleRow.class, $$$methodRef$$$9, this, null);
                }
                return false;
            }
            for (int i2 = 0; i2 < this.noColumn; ++i2) {
                if (this.columnChangeFlag[i2] != 17) continue;
                boolean bl3 = true;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleRow.class, $$$methodRef$$$9, this, bl3);
                    ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleRow.class, $$$methodRef$$$9, this, null);
                }
                return true;
            }
            boolean bl4 = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, OracleRow.class, $$$methodRef$$$9, this, bl4);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleRow.class, $$$methodRef$$$9, this, null);
            }
            return false;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, OracleRow.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setRowUpdated(boolean bl) {
        boolean bl2 = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, OracleRow.class, $$$methodRef$$$10, this, bl);
            }
            this.rowUpdated = value;
            if (value == false) {
                this.cancelRowUpdates();
            }
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, OracleRow.class, $$$methodRef$$$10, this);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleRow.class, $$$methodRef$$$10, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, OracleRow.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    public boolean isRowInserted() {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, OracleRow.class, $$$methodRef$$$11, this, new Object[0]);
            }
            boolean bl2 = this.rowInserted;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, OracleRow.class, $$$methodRef$$$11, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleRow.class, $$$methodRef$$$11, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, OracleRow.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    public void cancelRowDeletion() {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, OracleRow.class, $$$methodRef$$$12, this, new Object[0]);
            }
            this.rowDeleted = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, OracleRow.class, $$$methodRef$$$12, this);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleRow.class, $$$methodRef$$$12, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, OracleRow.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setRowDeleted(boolean bl) {
        boolean bl2 = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, OracleRow.class, $$$methodRef$$$13, this, bl);
            }
            this.rowDeleted = value;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, OracleRow.class, $$$methodRef$$$13, this);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleRow.class, $$$methodRef$$$13, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, OracleRow.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    public boolean isRowDeleted() {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, OracleRow.class, $$$methodRef$$$14, this, new Object[0]);
            }
            boolean bl2 = this.rowDeleted;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, OracleRow.class, $$$methodRef$$$14, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleRow.class, $$$methodRef$$$14, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, OracleRow.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    public Object[] getOriginalRow() {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, OracleRow.class, $$$methodRef$$$15, this, new Object[0]);
            }
            Object[] objectArray = this.column;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, OracleRow.class, $$$methodRef$$$15, this, objectArray);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleRow.class, $$$methodRef$$$15, this, null);
            }
            return this.column;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, OracleRow.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    public boolean isRowFullyPopulated() {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, OracleRow.class, $$$methodRef$$$16, this, new Object[0]);
            }
            if (!this.rowInserted) {
                boolean bl3 = false;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, OracleRow.class, $$$methodRef$$$16, this, bl3);
                    ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleRow.class, $$$methodRef$$$16, this, null);
                }
                return false;
            }
            boolean bl4 = bl2 = this.noColumnsInserted == this.noColumn;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, OracleRow.class, $$$methodRef$$$16, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleRow.class, $$$methodRef$$$16, this, null);
            }
            return bl4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, OracleRow.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setInsertedFlag(boolean bl) {
        boolean bl2 = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            void value;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, OracleRow.class, $$$methodRef$$$17, this, bl);
            }
            this.rowInserted = value;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, OracleRow.class, $$$methodRef$$$17, this);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleRow.class, $$$methodRef$$$17, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, OracleRow.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    void makeUpdatesOriginal() {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, OracleRow.class, $$$methodRef$$$18, this, new Object[0]);
            }
            for (int col = 0; col < this.noColumn; ++col) {
                if (this.columnChangeFlag[col] != 17) continue;
                this.column[col] = this.changedColumn[col];
                this.changedColumn[col] = null;
                this.columnChangeFlag[col] = 0;
            }
            this.rowUpdated = false;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, OracleRow.class, $$$methodRef$$$18, this);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OracleRow.class, $$$methodRef$$$18, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, OracleRow.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    public void insertRow() {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, OracleRow.class, $$$methodRef$$$19, this, new Object[0]);
            }
            this.columnChangeFlag = null;
            this.columnChangeFlag = new byte[this.noColumn];
            System.arraycopy(this.changedColumn, 0, this.column, 0, this.noColumn);
            this.changedColumn = null;
            this.changedColumn = new Object[this.noColumn];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, OracleRow.class, $$$methodRef$$$19, this);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OracleRow.class, $$$methodRef$$$19, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, OracleRow.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    public Collection toCollection() {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, OracleRow.class, $$$methodRef$$$20, this, new Object[0]);
            }
            Vector<Object> collection = new Vector<Object>(this.noColumn);
            for (int i2 = 1; i2 <= this.noColumn; ++i2) {
                collection.add(this.isColumnChanged(i2) ? this.getModifiedColumn(i2) : this.getColumn(i2));
            }
            Vector<Object> vector = collection;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, OracleRow.class, $$$methodRef$$$20, this, vector);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, OracleRow.class, $$$methodRef$$$20, this, null);
            }
            return vector;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, OracleRow.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    public OracleRow createCopy() throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, OracleRow.class, $$$methodRef$$$21, this, new Object[0]);
            }
            OracleRow or = new OracleRow(this.noColumn);
            for (int i2 = 0; i2 < this.noColumn; ++i2) {
                or.column[i2] = this.getCopy(this.column[i2]);
                or.changedColumn[i2] = this.getCopy(this.changedColumn[i2]);
            }
            System.arraycopy(this.columnChangeFlag, 0, or.columnChangeFlag, 0, this.noColumn);
            or.noColumnsInserted = this.noColumnsInserted;
            or.rowDeleted = this.rowDeleted;
            or.rowInserted = this.rowInserted;
            or.rowUpdated = this.rowUpdated;
            OracleRow oracleRow = or;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, OracleRow.class, $$$methodRef$$$21, this, oracleRow);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, OracleRow.class, $$$methodRef$$$21, this, null);
            }
            return oracleRow;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, OracleRow.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Object getCopy(Object object) throws SQLException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            Object objectCopy;
            block18: {
                void obj;
                block16: {
                    Object v0;
                    block17: {
                        Object var5_4;
                        if (bl) {
                            ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, OracleRow.class, $$$methodRef$$$22, this, object);
                        }
                        objectCopy = null;
                        try {
                            if (obj != null) break block16;
                            v0 = var5_4 = null;
                            if (!bl) break block17;
                        }
                        catch (Exception ea) {
                            SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 349, obj.getClass().getName() + ea.getMessage()).fillInStackTrace();
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$22, Level.FINEST, OracleRow.class, $$$methodRef$$$22, this, sQLException);
                            }
                            throw sQLException;
                        }
                        ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, OracleRow.class, $$$methodRef$$$22, this, var5_4);
                        ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, OracleRow.class, $$$methodRef$$$22, this, null);
                    }
                    return v0;
                }
                if (obj instanceof String) {
                    objectCopy = (String)obj;
                    break block18;
                }
                if (obj instanceof Number) {
                    objectCopy = new BigDecimal(((Number)obj).toString());
                    break block18;
                }
                if (obj instanceof Date) {
                    objectCopy = new Date(((Date)obj).getTime());
                    break block18;
                }
                if (obj instanceof Timestamp) {
                    objectCopy = new Timestamp(((Timestamp)obj).getTime());
                    break block18;
                }
                if (obj instanceof InputStream) {
                    objectCopy = new DataInputStream((InputStream)obj);
                    break block18;
                }
                if (obj instanceof OutputStream) {
                    objectCopy = new DataOutputStream((OutputStream)obj);
                    break block18;
                }
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 348, obj.getClass().getName()).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$22, Level.FINEST, OracleRow.class, $$$methodRef$$$22, this, sQLException);
                }
                throw sQLException;
            }
            String string = objectCopy;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, OracleRow.class, $$$methodRef$$$22, this, string);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, OracleRow.class, $$$methodRef$$$22, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, OracleRow.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            OracleRow oracleRow;
            block7: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, OracleRow.class, $$$methodRef$$$23, this, new Object[0]);
                }
                try {
                    oracleRow = this.createCopy();
                    if (!bl) break block7;
                }
                catch (SQLException ea) {
                    CloneNotSupportedException cloneNotSupportedException = new CloneNotSupportedException("Error while cloning\n" + ea.getMessage());
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$23, Level.FINEST, OracleRow.class, $$$methodRef$$$23, this, cloneNotSupportedException);
                    }
                    throw cloneNotSupportedException;
                }
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, OracleRow.class, $$$methodRef$$$23, this, oracleRow);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, OracleRow.class, $$$methodRef$$$23, this, null);
            }
            return oracleRow;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, OracleRow.class, $$$methodRef$$$23, this, throwable2);
            }
            throw throwable;
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x1000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, OracleRow.class, $$$methodRef$$$24, this, new Object[0]);
            }
            OracleConnection oracleConnection = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, OracleRow.class, $$$methodRef$$$24, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, OracleRow.class, $$$methodRef$$$24, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, OracleRow.class, $$$methodRef$$$24, this, throwable2);
            }
            throw throwable;
        }
    }

    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    static {
        try {
            $$$methodRef$$$27 = OracleRow.class.getDeclaredConstructor(Integer.TYPE, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = OracleRow.class.getDeclaredConstructor(Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = OracleRow.class.getDeclaredConstructor(Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = OracleRow.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = OracleRow.class.getDeclaredMethod("clone", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = OracleRow.class.getDeclaredMethod("getCopy", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = OracleRow.class.getDeclaredMethod("createCopy", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = OracleRow.class.getDeclaredMethod("toCollection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = OracleRow.class.getDeclaredMethod("insertRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OracleRow.class.getDeclaredMethod("makeUpdatesOriginal", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OracleRow.class.getDeclaredMethod("setInsertedFlag", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OracleRow.class.getDeclaredMethod("isRowFullyPopulated", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleRow.class.getDeclaredMethod("getOriginalRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleRow.class.getDeclaredMethod("isRowDeleted", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleRow.class.getDeclaredMethod("setRowDeleted", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleRow.class.getDeclaredMethod("cancelRowDeletion", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleRow.class.getDeclaredMethod("isRowInserted", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleRow.class.getDeclaredMethod("setRowUpdated", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleRow.class.getDeclaredMethod("isRowUpdated", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleRow.class.getDeclaredMethod("isColumnChanged", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleRow.class.getDeclaredMethod("getModifiedColumn", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleRow.class.getDeclaredMethod("getColumn", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleRow.class.getDeclaredMethod("cancelRowUpdates", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleRow.class.getDeclaredMethod("updateObject", Integer.TYPE, Object.class, long[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleRow.class.getDeclaredMethod("updateObject", Integer.TYPE, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleRow.class.getDeclaredMethod("isOriginalNull", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleRow.class.getDeclaredMethod("markOriginalNull", Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleRow.class.getDeclaredMethod("setColumnValue", Integer.TYPE, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

