/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.strings;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedIntValueProfile;
import com.oracle.truffle.api.strings.DecodingErrorHandler;
import com.oracle.truffle.api.strings.TStringGuards;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringIterator;
import java.lang.invoke.MethodHandles;

@GeneratedBy(value=TruffleStringIterator.class)
public final class TruffleStringIteratorFactory {

    @GeneratedBy(value=TruffleStringIterator.InternalPreviousNode.class)
    static final class InternalPreviousNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        InternalPreviousNodeGen() {
        }

        @NeverDefault
        public static TruffleStringIterator.InternalPreviousNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TruffleStringIterator.InternalPreviousNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=22, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(value=InlineSupport.IntField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TruffleStringIterator.InternalPreviousNode.class)
        @DenyReplace
        private static final class Uncached
        extends TruffleStringIterator.InternalPreviousNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            int executeInternal(Node arg0Value, TruffleStringIterator arg1Value, TruffleString.Encoding arg2Value, DecodingErrorHandler arg3Value) {
                if (TStringGuards.isUTF8(arg2Value)) {
                    return TruffleStringIterator.InternalPreviousNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached());
                }
                if (TStringGuards.isUTF16(arg2Value)) {
                    return TruffleStringIterator.InternalPreviousNode.utf16(arg0Value, arg1Value, arg2Value, arg3Value, InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached());
                }
                if (TStringGuards.isUTF32(arg2Value)) {
                    return TruffleStringIterator.InternalPreviousNode.utf32(arg0Value, arg1Value, arg2Value, arg3Value, InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached());
                }
                return TruffleStringIterator.InternalPreviousNode.unlikelyCases(arg0Value, arg1Value, arg2Value, arg3Value, InlinedIntValueProfile.getUncached());
            }
        }

        @GeneratedBy(value=TruffleStringIterator.InternalPreviousNode.class)
        @DenyReplace
        private static final class Inlined
        extends TruffleStringIterator.InternalPreviousNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.IntField fallback_encodingProfile__field1_;
            private final InlinedConditionProfile utf8_asciiProfile_;
            private final InlinedConditionProfile utf8_validProfile_;
            private final InlinedConditionProfile utf16_fixedProfile_;
            private final InlinedConditionProfile utf16_compressedProfile_;
            private final InlinedConditionProfile utf16_validProfile_;
            private final InlinedConditionProfile utf32_oneByteProfile_;
            private final InlinedConditionProfile utf32_twoByteProfile_;
            private final InlinedConditionProfile utf32_validProfile_;
            private final InlinedIntValueProfile fallback_encodingProfile_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TruffleStringIterator.InternalPreviousNode.class));
                this.state_0_ = target.getState(0, 22);
                this.fallback_encodingProfile__field1_ = target.getPrimitive(1, InlineSupport.IntField.class);
                this.utf8_asciiProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(4, 2)));
                this.utf8_validProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(6, 2)));
                this.utf16_fixedProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(8, 2)));
                this.utf16_compressedProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(10, 2)));
                this.utf16_validProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(12, 2)));
                this.utf32_oneByteProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(14, 2)));
                this.utf32_twoByteProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(16, 2)));
                this.utf32_validProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(18, 2)));
                this.fallback_encodingProfile_ = InlinedIntValueProfile.inline(InlineSupport.InlineTarget.create(InlinedIntValueProfile.class, this.state_0_.subUpdater(20, 2), this.fallback_encodingProfile__field1_));
            }

            private boolean fallbackGuard_(int state_0, Node arg0Value, TruffleStringIterator arg1Value, TruffleString.Encoding arg2Value, DecodingErrorHandler arg3Value) {
                if ((state_0 & 1) == 0 && TStringGuards.isUTF8(arg2Value)) {
                    return false;
                }
                if ((state_0 & 2) == 0 && TStringGuards.isUTF16(arg2Value)) {
                    return false;
                }
                return (state_0 & 4) != 0 || !TStringGuards.isUTF32(arg2Value);
            }

            @Override
            int executeInternal(Node arg0Value, TruffleStringIterator arg1Value, TruffleString.Encoding arg2Value, DecodingErrorHandler arg3Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0xF) != 0) {
                    if ((state_0 & 1) != 0 && TStringGuards.isUTF8(arg2Value)) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_, this.state_0_));
                        return TruffleStringIterator.InternalPreviousNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, this.utf8_asciiProfile_, this.utf8_validProfile_);
                    }
                    if ((state_0 & 2) != 0 && TStringGuards.isUTF16(arg2Value)) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.state_0_));
                        return TruffleStringIterator.InternalPreviousNode.utf16(arg0Value, arg1Value, arg2Value, arg3Value, this.utf16_fixedProfile_, this.utf16_compressedProfile_, this.utf16_validProfile_);
                    }
                    if ((state_0 & 4) != 0 && TStringGuards.isUTF32(arg2Value)) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.state_0_));
                        return TruffleStringIterator.InternalPreviousNode.utf32(arg0Value, arg1Value, arg2Value, arg3Value, this.utf32_oneByteProfile_, this.utf32_twoByteProfile_, this.utf32_validProfile_);
                    }
                    if ((state_0 & 8) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value, arg2Value, arg3Value)) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_, this.fallback_encodingProfile__field1_));
                        return TruffleStringIterator.InternalPreviousNode.unlikelyCases(arg0Value, arg1Value, arg2Value, arg3Value, this.fallback_encodingProfile_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
            }

            private int executeAndSpecialize(Node arg0Value, TruffleStringIterator arg1Value, TruffleString.Encoding arg2Value, DecodingErrorHandler arg3Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (TStringGuards.isUTF8(arg2Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    assert (InlineSupport.validate(arg0Value, this.state_0_, this.state_0_));
                    return TruffleStringIterator.InternalPreviousNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, this.utf8_asciiProfile_, this.utf8_validProfile_);
                }
                if (TStringGuards.isUTF16(arg2Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    assert (InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.state_0_));
                    return TruffleStringIterator.InternalPreviousNode.utf16(arg0Value, arg1Value, arg2Value, arg3Value, this.utf16_fixedProfile_, this.utf16_compressedProfile_, this.utf16_validProfile_);
                }
                if (TStringGuards.isUTF32(arg2Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 4);
                    assert (InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.state_0_));
                    return TruffleStringIterator.InternalPreviousNode.utf32(arg0Value, arg1Value, arg2Value, arg3Value, this.utf32_oneByteProfile_, this.utf32_twoByteProfile_, this.utf32_validProfile_);
                }
                this.state_0_.set(arg0Value, state_0 |= 8);
                assert (InlineSupport.validate(arg0Value, this.state_0_, this.fallback_encodingProfile__field1_));
                return TruffleStringIterator.InternalPreviousNode.unlikelyCases(arg0Value, arg1Value, arg2Value, arg3Value, this.fallback_encodingProfile_);
            }
        }
    }

    @GeneratedBy(value=TruffleStringIterator.PreviousNode.class)
    static final class PreviousNodeGen
    extends TruffleStringIterator.PreviousNode {
        private static final InlineSupport.StateField STATE_0_PreviousNode_UPDATER = InlineSupport.StateField.create(MethodHandles.lookup(), "state_0_");
        private static final TruffleStringIterator.InternalPreviousNode INLINED_PREVIOUS_NODE_ = InternalPreviousNodeGen.inline(InlineSupport.InlineTarget.create(TruffleStringIterator.InternalPreviousNode.class, STATE_0_PreviousNode_UPDATER.subUpdater(0, 22), InlineSupport.IntField.create(MethodHandles.lookup(), "previousNode__field1_")));
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        @InlineSupport.UnsafeAccessedField
        private int state_0_;
        @CompilerDirectives.CompilationFinal
        @InlineSupport.UnsafeAccessedField
        private int previousNode__field1_;

        private PreviousNodeGen() {
        }

        @Override
        public int execute(TruffleStringIterator arg0Value, TruffleString.Encoding arg1Value) {
            return this.doDefault(arg0Value, arg1Value, INLINED_PREVIOUS_NODE_);
        }

        @NeverDefault
        public static TruffleStringIterator.PreviousNode create() {
            return new PreviousNodeGen();
        }

        @NeverDefault
        public static TruffleStringIterator.PreviousNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=TruffleStringIterator.PreviousNode.class)
        @DenyReplace
        private static final class Uncached
        extends TruffleStringIterator.PreviousNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int execute(TruffleStringIterator arg0Value, TruffleString.Encoding arg1Value) {
                return this.doDefault(arg0Value, arg1Value, TruffleStringIterator.InternalPreviousNode.getUncached());
            }
        }
    }

    @GeneratedBy(value=TruffleStringIterator.NextNode.class)
    static final class NextNodeGen
    extends TruffleStringIterator.NextNode {
        private static final InlineSupport.StateField STATE_0_NextNode_UPDATER = InlineSupport.StateField.create(MethodHandles.lookup(), "state_0_");
        private static final TruffleStringIterator.InternalNextNode INLINED_NEXT_NODE_ = InternalNextNodeGen.inline(InlineSupport.InlineTarget.create(TruffleStringIterator.InternalNextNode.class, STATE_0_NextNode_UPDATER.subUpdater(0, 22), InlineSupport.IntField.create(MethodHandles.lookup(), "nextNode__field1_")));
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        @InlineSupport.UnsafeAccessedField
        private int state_0_;
        @CompilerDirectives.CompilationFinal
        @InlineSupport.UnsafeAccessedField
        private int nextNode__field1_;

        private NextNodeGen() {
        }

        @Override
        public int execute(TruffleStringIterator arg0Value, TruffleString.Encoding arg1Value) {
            return this.doDefault(arg0Value, arg1Value, INLINED_NEXT_NODE_);
        }

        @NeverDefault
        public static TruffleStringIterator.NextNode create() {
            return new NextNodeGen();
        }

        @NeverDefault
        public static TruffleStringIterator.NextNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=TruffleStringIterator.NextNode.class)
        @DenyReplace
        private static final class Uncached
        extends TruffleStringIterator.NextNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int execute(TruffleStringIterator arg0Value, TruffleString.Encoding arg1Value) {
                return this.doDefault(arg0Value, arg1Value, TruffleStringIterator.InternalNextNode.getUncached());
            }
        }
    }

    @GeneratedBy(value=TruffleStringIterator.InternalNextNode.class)
    static final class InternalNextNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        InternalNextNodeGen() {
        }

        @NeverDefault
        public static TruffleStringIterator.InternalNextNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TruffleStringIterator.InternalNextNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=22, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(value=InlineSupport.IntField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TruffleStringIterator.InternalNextNode.class)
        @DenyReplace
        private static final class Uncached
        extends TruffleStringIterator.InternalNextNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            int executeInternal(Node arg0Value, TruffleStringIterator arg1Value, TruffleString.Encoding arg2Value, DecodingErrorHandler arg3Value) {
                if (TStringGuards.isUTF8(arg2Value)) {
                    return TruffleStringIterator.InternalNextNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached());
                }
                if (TStringGuards.isUTF16(arg2Value)) {
                    return TruffleStringIterator.InternalNextNode.utf16(arg0Value, arg1Value, arg2Value, arg3Value, InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached());
                }
                if (TStringGuards.isUTF32(arg2Value)) {
                    return TruffleStringIterator.InternalNextNode.utf32(arg0Value, arg1Value, arg2Value, arg3Value, InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached());
                }
                return TruffleStringIterator.InternalNextNode.unlikelyCases(arg0Value, arg1Value, arg2Value, arg3Value, InlinedIntValueProfile.getUncached());
            }
        }

        @GeneratedBy(value=TruffleStringIterator.InternalNextNode.class)
        @DenyReplace
        private static final class Inlined
        extends TruffleStringIterator.InternalNextNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.IntField fallback_encodingProfile__field1_;
            private final InlinedConditionProfile utf8_asciiProfile_;
            private final InlinedConditionProfile utf8_validProfile_;
            private final InlinedConditionProfile utf16_fixedProfile_;
            private final InlinedConditionProfile utf16_compressedProfile_;
            private final InlinedConditionProfile utf16_validProfile_;
            private final InlinedConditionProfile utf32_oneByteProfile_;
            private final InlinedConditionProfile utf32_twoByteProfile_;
            private final InlinedConditionProfile utf32_validProfile_;
            private final InlinedIntValueProfile fallback_encodingProfile_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TruffleStringIterator.InternalNextNode.class));
                this.state_0_ = target.getState(0, 22);
                this.fallback_encodingProfile__field1_ = target.getPrimitive(1, InlineSupport.IntField.class);
                this.utf8_asciiProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(4, 2)));
                this.utf8_validProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(6, 2)));
                this.utf16_fixedProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(8, 2)));
                this.utf16_compressedProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(10, 2)));
                this.utf16_validProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(12, 2)));
                this.utf32_oneByteProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(14, 2)));
                this.utf32_twoByteProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(16, 2)));
                this.utf32_validProfile_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, this.state_0_.subUpdater(18, 2)));
                this.fallback_encodingProfile_ = InlinedIntValueProfile.inline(InlineSupport.InlineTarget.create(InlinedIntValueProfile.class, this.state_0_.subUpdater(20, 2), this.fallback_encodingProfile__field1_));
            }

            private boolean fallbackGuard_(int state_0, Node arg0Value, TruffleStringIterator arg1Value, TruffleString.Encoding arg2Value, DecodingErrorHandler arg3Value) {
                if ((state_0 & 1) == 0 && TStringGuards.isUTF8(arg2Value)) {
                    return false;
                }
                if ((state_0 & 2) == 0 && TStringGuards.isUTF16(arg2Value)) {
                    return false;
                }
                return (state_0 & 4) != 0 || !TStringGuards.isUTF32(arg2Value);
            }

            @Override
            int executeInternal(Node arg0Value, TruffleStringIterator arg1Value, TruffleString.Encoding arg2Value, DecodingErrorHandler arg3Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0xF) != 0) {
                    if ((state_0 & 1) != 0 && TStringGuards.isUTF8(arg2Value)) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_, this.state_0_));
                        return TruffleStringIterator.InternalNextNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, this.utf8_asciiProfile_, this.utf8_validProfile_);
                    }
                    if ((state_0 & 2) != 0 && TStringGuards.isUTF16(arg2Value)) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.state_0_));
                        return TruffleStringIterator.InternalNextNode.utf16(arg0Value, arg1Value, arg2Value, arg3Value, this.utf16_fixedProfile_, this.utf16_compressedProfile_, this.utf16_validProfile_);
                    }
                    if ((state_0 & 4) != 0 && TStringGuards.isUTF32(arg2Value)) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.state_0_));
                        return TruffleStringIterator.InternalNextNode.utf32(arg0Value, arg1Value, arg2Value, arg3Value, this.utf32_oneByteProfile_, this.utf32_twoByteProfile_, this.utf32_validProfile_);
                    }
                    if ((state_0 & 8) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value, arg2Value, arg3Value)) {
                        assert (InlineSupport.validate(arg0Value, this.state_0_, this.fallback_encodingProfile__field1_));
                        return TruffleStringIterator.InternalNextNode.unlikelyCases(arg0Value, arg1Value, arg2Value, arg3Value, this.fallback_encodingProfile_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
            }

            private int executeAndSpecialize(Node arg0Value, TruffleStringIterator arg1Value, TruffleString.Encoding arg2Value, DecodingErrorHandler arg3Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (TStringGuards.isUTF8(arg2Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    assert (InlineSupport.validate(arg0Value, this.state_0_, this.state_0_));
                    return TruffleStringIterator.InternalNextNode.utf8(arg0Value, arg1Value, arg2Value, arg3Value, this.utf8_asciiProfile_, this.utf8_validProfile_);
                }
                if (TStringGuards.isUTF16(arg2Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    assert (InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.state_0_));
                    return TruffleStringIterator.InternalNextNode.utf16(arg0Value, arg1Value, arg2Value, arg3Value, this.utf16_fixedProfile_, this.utf16_compressedProfile_, this.utf16_validProfile_);
                }
                if (TStringGuards.isUTF32(arg2Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 4);
                    assert (InlineSupport.validate(arg0Value, this.state_0_, this.state_0_, this.state_0_));
                    return TruffleStringIterator.InternalNextNode.utf32(arg0Value, arg1Value, arg2Value, arg3Value, this.utf32_oneByteProfile_, this.utf32_twoByteProfile_, this.utf32_validProfile_);
                }
                this.state_0_.set(arg0Value, state_0 |= 8);
                assert (InlineSupport.validate(arg0Value, this.state_0_, this.fallback_encodingProfile__field1_));
                return TruffleStringIterator.InternalNextNode.unlikelyCases(arg0Value, arg1Value, arg2Value, arg3Value, this.fallback_encodingProfile_);
            }
        }
    }
}

