/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version10;

import java.io.IOException;
import java.sql.SQLException;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.ng.AbstractFbTransaction;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.gds.ng.TransactionState;
import org.firebirdsql.gds.ng.wire.FbWireDatabase;
import org.firebirdsql.gds.ng.wire.FbWireTransaction;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public class V10Transaction
extends AbstractFbTransaction
implements FbWireTransaction {
    private static final Logger log = LoggerFactory.getLogger(V10Transaction.class);
    private final int handle;

    public V10Transaction(FbWireDatabase database, int transactionHandle, TransactionState initialState) {
        super(initialState, database);
        this.handle = transactionHandle;
    }

    protected final XdrOutputStream getXdrOut() throws SQLException {
        return this.getDatabase().getXdrStreamAccess().getXdrOut();
    }

    @Override
    protected FbWireDatabase getDatabase() {
        return (FbWireDatabase)super.getDatabase();
    }

    @Override
    public int getHandle() {
        return this.handle;
    }

    @Override
    public void commit() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.switchState(TransactionState.COMMITTING);
            this.finishTransaction(30);
            this.switchState(TransactionState.COMMITTED);
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
        finally {
            TransactionState transactionState = this.getState();
            if (transactionState != TransactionState.COMMITTED && log.isWarnEnabled()) {
                String message = "Commit not completed, state was " + (Object)((Object)transactionState);
                if (log.isDebugEnabled()) {
                    log.warnDebug(message, new RuntimeException("Commit not completed"));
                } else {
                    log.warn(message + "; see debug level for stacktrace");
                }
            }
        }
    }

    @Override
    public void rollback() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.switchState(TransactionState.ROLLING_BACK);
            this.finishTransaction(31);
            this.switchState(TransactionState.ROLLED_BACK);
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
        finally {
            TransactionState transactionState = this.getState();
            if (transactionState != TransactionState.ROLLED_BACK && log.isWarnEnabled()) {
                String message = "Rollback not completed, state was " + (Object)((Object)transactionState);
                if (log.isDebugEnabled()) {
                    log.warnDebug(message, new RuntimeException("Rollback not completed"));
                } else {
                    log.warn(message + "; see debug level for stacktrace");
                }
            }
        }
    }

    private void finishTransaction(int commitOrRollback) throws SQLException {
        assert (commitOrRollback == 30 || commitOrRollback == 31) : "Unsupported operation code " + commitOrRollback;
        try {
            XdrOutputStream xdrOut = this.getXdrOut();
            xdrOut.writeInt(commitOrRollback);
            xdrOut.writeInt(this.handle);
            xdrOut.flush();
        }
        catch (IOException ioex) {
            throw new FbExceptionBuilder().exception(335544727).cause(ioex).toSQLException();
        }
        try {
            this.getDatabase().readResponse(null);
        }
        catch (IOException ioex) {
            throw new FbExceptionBuilder().exception(335544726).cause(ioex).toSQLException();
        }
    }

    @Override
    public void prepare(byte[] recoveryInformation) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.switchState(TransactionState.PREPARING);
            try {
                XdrOutputStream xdrOut = this.getXdrOut();
                if (recoveryInformation != null) {
                    xdrOut.writeInt(51);
                    xdrOut.writeInt(this.handle);
                    xdrOut.writeBuffer(recoveryInformation);
                } else {
                    xdrOut.writeInt(32);
                    xdrOut.writeInt(this.handle);
                }
                xdrOut.flush();
            }
            catch (IOException ioex) {
                throw new FbExceptionBuilder().exception(335544727).cause(ioex).toSQLException();
            }
            try {
                this.getDatabase().readResponse(null);
            }
            catch (IOException ioex) {
                throw new FbExceptionBuilder().exception(335544726).cause(ioex).toSQLException();
            }
            this.switchState(TransactionState.PREPARED);
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
        finally {
            TransactionState transactionState = this.getState();
            if (transactionState != TransactionState.PREPARED && log.isWarnEnabled()) {
                String message = "Prepare not completed, state was " + (Object)((Object)transactionState);
                if (log.isDebugEnabled()) {
                    log.warnDebug(message, new RuntimeException("Prepare not completed"));
                } else {
                    log.warn(message + "; see debug level for stacktrace");
                }
            }
        }
    }

    @Override
    public byte[] getTransactionInfo(byte[] requestItems, int maxBufferLength) throws SQLException {
        try {
            return this.getDatabase().getInfo(42, this.getHandle(), requestItems, maxBufferLength, null);
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }
}

