/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.databaseconnector;

import java.util.Objects;
import schemacrawler.tools.databaseconnector.DatabaseConnector;
import schemacrawler.tools.databaseconnector.DatabaseConnectorRegistry;
import us.fatehi.utility.Utility;
import us.fatehi.utility.datasource.DatabaseConnectionSourceBuilder;
import us.fatehi.utility.datasource.MultiUseUserCredentials;
import us.fatehi.utility.datasource.UserCredentials;
import us.fatehi.utility.ioresource.EnvironmentVariableAccessor;

public final class EnvironmentalDatabaseConnectionSourceBuilder {
    public static DatabaseConnectionSourceBuilder builder() {
        return EnvironmentalDatabaseConnectionSourceBuilder.builder(System::getenv);
    }

    public static DatabaseConnectionSourceBuilder builder(EnvironmentVariableAccessor envAccessor) {
        Objects.requireNonNull(envAccessor, "No environmental accessor provided");
        String connectionUrl = Utility.trimToEmpty((String)envAccessor.getenv("SCHCRWLR_JDBC_URL"));
        DatabaseConnectionSourceBuilder dbConnectionSourceBuilder = !Utility.isBlank((CharSequence)connectionUrl) ? EnvironmentalDatabaseConnectionSourceBuilder.builderFromUrl(connectionUrl) : EnvironmentalDatabaseConnectionSourceBuilder.builderForServer(envAccessor);
        MultiUseUserCredentials userCredentials = new MultiUseUserCredentials(Utility.trimToEmpty((String)envAccessor.getenv("SCHCRWLR_DATABASE_USER")), Utility.trimToEmpty((String)envAccessor.getenv("SCHCRWLR_DATABASE_PASSWORD")));
        dbConnectionSourceBuilder.withUserCredentials((UserCredentials)userCredentials);
        return dbConnectionSourceBuilder;
    }

    private static DatabaseConnectionSourceBuilder builderForServer(EnvironmentVariableAccessor envAccessor) {
        String databaseSystemIdentifier = Utility.trimToEmpty((String)envAccessor.getenv("SCHCRWLR_SERVER"));
        DatabaseConnectorRegistry databaseConnectorRegistry = DatabaseConnectorRegistry.getDatabaseConnectorRegistry();
        DatabaseConnector databaseConnector = databaseConnectorRegistry.findDatabaseConnectorFromDatabaseSystemIdentifier(databaseSystemIdentifier);
        DatabaseConnectionSourceBuilder dbConnectionSourceBuilder = databaseConnector.databaseConnectionSourceBuilder();
        String host = Utility.trimToEmpty((String)envAccessor.getenv("SCHCRWLR_HOST"));
        dbConnectionSourceBuilder.withHost(host);
        String port = Utility.trimToEmpty((String)envAccessor.getenv("SCHCRWLR_PORT"));
        if (EnvironmentalDatabaseConnectionSourceBuilder.isValidPort(port)) {
            dbConnectionSourceBuilder.withPort(Integer.valueOf(port));
        }
        String database = Utility.trimToEmpty((String)envAccessor.getenv("SCHCRWLR_DATABASE"));
        dbConnectionSourceBuilder.withDatabase(database);
        return dbConnectionSourceBuilder;
    }

    private static DatabaseConnectionSourceBuilder builderFromUrl(String connectionUrl) {
        DatabaseConnectionSourceBuilder dbConnectionSourceBuilder = DatabaseConnectionSourceBuilder.builder((String)connectionUrl);
        DatabaseConnectorRegistry databaseConnectorRegistry = DatabaseConnectorRegistry.getDatabaseConnectorRegistry();
        DatabaseConnector databaseConnector = databaseConnectorRegistry.findDatabaseConnectorFromUrl(connectionUrl);
        dbConnectionSourceBuilder.withConnectionInitializer(databaseConnector.databaseConnectionSourceBuilder().getConnectionInitializer());
        return dbConnectionSourceBuilder;
    }

    private static boolean isValidPort(String value) {
        if (Utility.isBlank((CharSequence)value)) {
            return false;
        }
        try {
            int port = Integer.parseInt(value);
            return port > 1023 && port < 65536;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private EnvironmentalDatabaseConnectionSourceBuilder() {
    }
}

