/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.dict;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.HashNotImplemented;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.common.EmptyStorage;
import com.oracle.graal.python.builtins.objects.common.ForeignHashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingCollectionNodes;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.DictBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.dict.DictBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.dict.DictBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.dict.DictNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.dict.PDictView;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryFunc;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryOp;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotLen;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotMpAssSubscript;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotRichCompare;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSqContains;
import com.oracle.graal.python.lib.IteratorExhausted;
import com.oracle.graal.python.lib.PyDictCheckNode;
import com.oracle.graal.python.lib.PyDictSetDefault;
import com.oracle.graal.python.lib.PyIterNextNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectSetItem;
import com.oracle.graal.python.lib.RichCmpOp;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallBinaryNode;
import com.oracle.graal.python.nodes.call.special.SpecialMethodNotFound;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PDict})
@HashNotImplemented
public final class DictBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = DictBuiltinsSlotsGen.SLOTS;

    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
    }

    protected List<NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return DictBuiltinsFactory.getFactories();
    }

    @Builtin(name="__class_getitem__", minNumOfPositionalArgs=2, isClassmethod=true)
    @GenerateNodeFactory
    public static abstract class ClassGetItemNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object classGetItem(Object cls, Object key, @Bind PythonLanguage language) {
            return PFactory.createGenericAlias(language, cls, key);
        }
    }

    @Slot(value=Slot.SlotKind.nb_inplace_or, isComplex=true)
    @GenerateNodeFactory
    static abstract class IOrNode
    extends PythonBinaryBuiltinNode {
        IOrNode() {
        }

        @Specialization
        Object or(VirtualFrame frame, Object self, Object other, @Cached DictNodes.UpdateNode updateNode) {
            updateNode.execute((Frame)frame, self, other);
            return self;
        }
    }

    @Slot(value=Slot.SlotKind.nb_or, isComplex=true)
    @ImportStatic(value={PythonBuiltinClassType.class})
    @GenerateNodeFactory
    static abstract class OrNode
    extends TpSlotBinaryOp.BinaryOpBuiltinNode {
        OrNode() {
        }

        @Specialization(guards={"isDictNode.execute(inliningTarget, self)", "isDictNode.execute(inliningTarget, other)"}, limit="1")
        static PDict or(VirtualFrame frame, Object self, Object other, @Bind Node inliningTarget, @Cached PyDictCheckNode isDictNode, @Cached DictNodes.GetDictStorageNode getStorageNode, @Cached HashingStorageNodes.HashingStorageCopy copyNode, @Cached DictNodes.UpdateNode updateNode, @Bind PythonLanguage language) {
            HashingStorage storage = getStorageNode.execute(inliningTarget, self);
            PDict merged = PFactory.createDict(language, copyNode.execute(inliningTarget, storage));
            updateNode.execute((Frame)frame, merged, other);
            return merged;
        }

        @Fallback
        static Object or(Object self, Object other) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="fromkeys", minNumOfPositionalArgs=2, parameterNames={"$cls", "iterable", "value"}, isClassmethod=true)
    @GenerateNodeFactory
    public static abstract class FromKeysNode
    extends PythonTernaryBuiltinNode {
        @Specialization(guards={"isBuiltinDict(inliningTarget, cls, isSameTypeNode)"}, limit="1")
        static Object doKeys(VirtualFrame frame, Object cls, Object iterable, Object value, @Bind Node inliningTarget, @Cached TypeNodes.IsSameTypeNode isSameTypeNode, @Cached HashingCollectionNodes.GetClonedHashingStorageNode getHashingStorageNode, @Bind PythonLanguage language) {
            HashingStorage s = getHashingStorageNode.getForDictionaries(frame, inliningTarget, iterable, value);
            return PFactory.createDict(language, s);
        }

        @Fallback
        static Object doKeys(VirtualFrame frame, Object cls, Object iterable, Object value, @Bind Node inliningTarget, @Cached PyObjectGetIter getIter, @Cached CallNode callCtor, @Cached PyObjectSetItem setItem, @Cached PyIterNextNode nextNode) {
            Object dict = callCtor.execute((Frame)frame, cls, new Object[0]);
            Object val = value == PNone.NO_VALUE ? PNone.NONE : value;
            Object it = getIter.execute((Frame)frame, inliningTarget, iterable);
            while (true) {
                Object key;
                try {
                    key = nextNode.execute((Frame)frame, inliningTarget, it);
                }
                catch (IteratorExhausted e) {
                    break;
                }
                setItem.execute((Frame)frame, inliningTarget, dict, key, val);
            }
            return dict;
        }

        protected static boolean isBuiltinDict(Node inliningTarget, Object cls, TypeNodes.IsSameTypeNode isSameTypeNode) {
            return isSameTypeNode.execute(inliningTarget, (Object)PythonBuiltinClassType.PDict, cls);
        }
    }

    @Builtin(name="update", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class UpdateNode
    extends PythonBuiltinNode {
        @Specialization(guards={"args.length == 0", "kwargs.length == 0"})
        static Object updateEmpy(VirtualFrame frame, Object self, Object[] args, PKeyword[] kwargs) {
            return PNone.NONE;
        }

        @Specialization(guards={"args.length == 1", "kwargs.length == 0"})
        static Object update(VirtualFrame frame, Object self, Object[] args, PKeyword[] kwargs, @Cached.Shared(value="updateNode") @Cached DictNodes.UpdateNode updateNode) {
            updateNode.execute((Frame)frame, self, args[0]);
            return PNone.NONE;
        }

        @Specialization(guards={"args.length <= 1", "kwargs.length > 0"})
        static Object update(VirtualFrame frame, Object self, Object[] args, PKeyword[] kwargs, @Bind Node inliningTarget, @Cached DictNodes.GetDictStorageNode getStorageNode, @Cached DictNodes.UpdateDictStorageNode updateDictStorageNode, @Cached.Shared(value="updateNode") @Cached DictNodes.UpdateNode updateNode, @Cached HashingStorage.InitNode initNode, @Cached HashingStorageNodes.HashingStorageAddAllToOther addAllToOtherNode) {
            if (args.length > 0) {
                updateNode.execute((Frame)frame, self, args[0]);
            }
            HashingStorage kwargsStorage = initNode.execute(frame, PNone.NO_VALUE, kwargs);
            HashingStorage storage = getStorageNode.execute(inliningTarget, self);
            HashingStorage newStorage = addAllToOtherNode.execute((Frame)frame, inliningTarget, kwargsStorage, storage);
            updateDictStorageNode.execute(inliningTarget, self, storage, newStorage);
            return PNone.NONE;
        }

        @Specialization(guards={"args.length > 1"})
        static Object error(Object self, Object[] args, PKeyword[] kwargs, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.EXPECTED_AT_MOST_D_ARGS_GOT_D, "update", 1, args.length);
        }
    }

    @Builtin(name="values", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ValuesNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static PDictView values(PDict self, @Bind PythonLanguage language) {
            return PFactory.createDictValuesView(language, self);
        }

        @Fallback
        static PDictView foreign(Object self, @Bind PythonLanguage language) {
            return PFactory.createDictValuesView(language, self, new ForeignHashingStorage(self));
        }
    }

    @Builtin(name="clear", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ClearNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static PNone clear(Object dict, @Bind Node inliningTarget, @Cached DictNodes.GetDictStorageNode getStorageNode, @Cached DictNodes.UpdateDictStorageNode updateStorageNode, @Cached HashingStorageNodes.HashingStorageClear clearNode) {
            HashingStorage storage = getStorageNode.execute(inliningTarget, dict);
            HashingStorage newStorage = clearNode.execute(inliningTarget, storage);
            updateStorageNode.execute(inliningTarget, dict, storage, newStorage);
            return PNone.NONE;
        }
    }

    @Builtin(name="copy", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class CopyNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static PDict copy(Object dict, @Bind Node inliningTarget, @Cached DictNodes.GetDictStorageNode getStorageNode, @Cached HashingStorageNodes.HashingStorageCopy copyNode, @Bind PythonLanguage language) {
            HashingStorage storage = getStorageNode.execute(inliningTarget, dict);
            return PFactory.createDict(language, copyNode.execute(inliningTarget, storage));
        }
    }

    @Slot(value=Slot.SlotKind.mp_length)
    @GenerateUncached
    @GenerateNodeFactory
    public static abstract class LenNode
    extends TpSlotLen.LenBuiltinNode {
        @Specialization
        static int len(Object self, @Bind Node inliningTarget, @Cached DictNodes.GetDictStorageNode getStorageNode, @Cached HashingStorageNodes.HashingStorageLen lenNode) {
            HashingStorage storage = getStorageNode.execute(inliningTarget, self);
            return lenNode.execute(inliningTarget, storage);
        }
    }

    @Slot(value=Slot.SlotKind.sq_contains, isComplex=true)
    @GenerateNodeFactory
    public static abstract class ContainsNode
    extends TpSlotSqContains.SqContainsBuiltinNode {
        @Specialization
        static boolean run(VirtualFrame frame, Object self, Object key, @Bind Node inliningTarget, @Cached DictNodes.GetDictStorageNode getStorageNode, @Cached HashingStorageNodes.HashingStorageGetItem getItem) {
            HashingStorage storage = getStorageNode.execute(inliningTarget, self);
            return getItem.hasKey((Frame)frame, inliningTarget, storage, key);
        }
    }

    @Slot(value=Slot.SlotKind.tp_richcompare, isComplex=true)
    @GenerateNodeFactory
    public static abstract class EqNode
    extends TpSlotRichCompare.RichCmpBuiltinNode {
        @Specialization(guards={"op.isEqOrNe()"})
        static Object doDictDict(VirtualFrame frame, PDict self, PDict other, RichCmpOp op, @Bind Node inliningTarget, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageEq eqNode) {
            return eqNode.execute((Frame)frame, inliningTarget, self.getDictStorage(), other.getDictStorage()) == op.isEq();
        }

        @Fallback
        static Object doGeneric(VirtualFrame frame, Object self, Object other, RichCmpOp op, @Bind Node inliningTarget, @Cached PyDictCheckNode isDictNode, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageEq eqNode, @Cached DictNodes.GetDictStorageNode getStorageNode) {
            if (op.isEqOrNe() && isDictNode.execute(inliningTarget, other)) {
                HashingStorage otherStorage;
                HashingStorage selfStorage = getStorageNode.execute(inliningTarget, self);
                return eqNode.execute((Frame)frame, inliningTarget, selfStorage, otherStorage = getStorageNode.execute(inliningTarget, other)) == op.isEq();
            }
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__reversed__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReversedNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object run(Object self, @Bind Node inliningTarget, @Cached DictNodes.GetDictStorageNode getStorageNode, @Cached HashingStorageNodes.HashingStorageLen lenNode, @Cached HashingStorageNodes.HashingStorageGetReverseIterator getReverseIterator, @Bind PythonLanguage language) {
            HashingStorage storage = getStorageNode.execute(inliningTarget, self);
            return PFactory.createDictKeyIterator(language, getReverseIterator.execute(inliningTarget, storage), storage, lenNode.execute(inliningTarget, storage));
        }
    }

    @Slot(value=Slot.SlotKind.tp_iter, isComplex=true)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object run(Object self, @Bind Node inliningTarget, @Cached DictNodes.GetDictStorageNode getStorageNode, @Cached HashingStorageNodes.HashingStorageLen lenNode, @Cached HashingStorageNodes.HashingStorageGetIterator getIterator, @Bind PythonLanguage language) {
            HashingStorage storage = getStorageNode.execute(inliningTarget, self);
            return PFactory.createDictKeyIterator(language, getIterator.execute(inliningTarget, storage), storage, lenNode.execute(inliningTarget, storage));
        }
    }

    @Slot(value=Slot.SlotKind.mp_ass_subscript, isComplex=true)
    @GenerateNodeFactory
    static abstract class SetItemNode
    extends TpSlotMpAssSubscript.MpAssSubscriptBuiltinNode {
        SetItemNode() {
        }

        @Specialization(guards={"!isNoValue(value)"})
        static void run(VirtualFrame frame, Object self, Object key, Object value, @Bind Node inliningTarget, @Cached HashingCollectionNodes.SetItemNode setItemNode) {
            setItemNode.execute((Frame)frame, inliningTarget, self, key, value);
        }

        @Specialization(guards={"isNoValue(value)"})
        static void run(VirtualFrame frame, Object self, Object key, Object value, @Bind Node inliningTarget, @Cached DictNodes.GetDictStorageNode getStorageNode, @Cached HashingStorageNodes.HashingStorageDelItem delItem, @Cached PRaiseNode raiseNode) {
            HashingStorage storage = getStorageNode.execute(inliningTarget, self);
            if (!delItem.execute((Frame)frame, inliningTarget, storage, key, self)) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.KeyError, new Object[]{key});
            }
        }
    }

    @ImportStatic(value={SpecialMethodNames.class})
    @GenerateInline(value=false)
    protected static abstract class DispatchMissingNode
    extends Node {
        protected DispatchMissingNode() {
        }

        protected abstract Object execute(VirtualFrame var1, Object var2, Object var3);

        @Specialization
        static Object missing(VirtualFrame frame, Object self, Object key, @Bind Node inliningTarget, @Cached(value="create(T___MISSING__)") LookupAndCallBinaryNode callMissing, @Cached PRaiseNode raiseNode) {
            try {
                return callMissing.executeObject(frame, self, key);
            }
            catch (SpecialMethodNotFound ignored) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.KeyError, new Object[]{key});
            }
        }
    }

    @Slot(value=Slot.SlotKind.mp_subscript, isComplex=true)
    @GenerateNodeFactory
    public static abstract class GetItemNode
    extends TpSlotBinaryFunc.MpSubscriptBuiltinNode {
        @Node.Child
        private DispatchMissingNode missing;

        @Specialization
        Object getItem(VirtualFrame frame, Object self, Object key, @Bind Node inliningTarget, @Cached DictNodes.GetDictStorageNode getStorageNode, @Cached InlinedConditionProfile notFoundProfile, @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached PRaiseNode raiseNode) {
            HashingStorage storage = getStorageNode.execute(inliningTarget, self);
            Object result = getItem.execute((Frame)frame, inliningTarget, storage, key);
            if (notFoundProfile.profile(inliningTarget, result == null)) {
                return this.handleMissing(frame, inliningTarget, self, key, raiseNode);
            }
            return result;
        }

        @HostCompilerDirectives.InliningCutoff
        private Object handleMissing(VirtualFrame frame, Node inliningTarget, Object self, Object key, PRaiseNode raiseNode) {
            PDict dict;
            if (self instanceof PDict && !PGuards.isBuiltinDict(dict = (PDict)self)) {
                if (this.missing == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.missing = (DispatchMissingNode)this.insert(DictBuiltinsFactory.DispatchMissingNodeGen.create());
                }
                return this.missing.execute(frame, dict, key);
            }
            throw raiseNode.raise(inliningTarget, PythonErrorType.KeyError, new Object[]{key});
        }
    }

    @Builtin(name="get", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=3)
    @GenerateNodeFactory
    public static abstract class GetNode
    extends PythonTernaryBuiltinNode {
        @Specialization
        static Object doWithDefault(VirtualFrame frame, Object self, Object key, Object defaultValue, @Bind Node inliningTarget, @Cached DictNodes.GetDictStorageNode getStorageNode, @Cached HashingStorageNodes.HashingStorageGetItem getItem) {
            HashingStorage storage = getStorageNode.execute(inliningTarget, self);
            Object value = getItem.execute((Frame)frame, inliningTarget, storage, key);
            return value != null ? value : (defaultValue == PNone.NO_VALUE ? PNone.NONE : defaultValue);
        }
    }

    @Builtin(name="items", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ItemsNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static PDictView items(PDict self, @Bind PythonLanguage language) {
            return PFactory.createDictItemsView(language, self);
        }

        @Fallback
        static PDictView foreign(Object self, @Bind PythonLanguage language) {
            return PFactory.createDictItemsView(language, self, new ForeignHashingStorage(self));
        }
    }

    @Builtin(name="keys", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class KeysNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static PDictView keys(PDict self, @Bind PythonLanguage language) {
            return PFactory.createDictKeysView(language, self);
        }

        @Fallback
        static PDictView foreign(Object self, @Bind PythonLanguage language) {
            return PFactory.createDictKeysView(language, self, new ForeignHashingStorage(self));
        }
    }

    @Builtin(name="popitem", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class PopItemNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object popItem(Object dict, @Bind Node inliningTarget, @Cached DictNodes.GetDictStorageNode getStorageNode, @Cached HashingStorageNodes.HashingStoragePop popNode, @Bind PythonLanguage language, @Cached PRaiseNode raiseNode) {
            HashingStorage storage = getStorageNode.execute(inliningTarget, dict);
            Object[] result = popNode.execute(inliningTarget, storage, dict);
            if (result == null) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.KeyError, ErrorMessages.IS_EMPTY, "popitem(): dictionary");
            }
            return PFactory.createTuple(language, result);
        }
    }

    @Builtin(name="pop", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=3)
    @GenerateNodeFactory
    public static abstract class PopNode
    extends PythonTernaryBuiltinNode {
        @Specialization
        static Object popDefault(VirtualFrame frame, Object dict, Object key, Object defaultValue, @Bind Node inliningTarget, @Cached DictNodes.GetDictStorageNode getStorageNode, @Cached InlinedConditionProfile hasKeyProfile, @Cached HashingStorageNodes.HashingStorageDelItem delItem, @Cached PRaiseNode raiseNode) {
            HashingStorage storage = getStorageNode.execute(inliningTarget, dict);
            Object retVal = delItem.executePop((Frame)frame, inliningTarget, storage, key, dict);
            if (hasKeyProfile.profile(inliningTarget, retVal != null)) {
                return retVal;
            }
            if (PGuards.isNoValue(defaultValue)) {
                throw raiseNode.raise(inliningTarget, PythonErrorType.KeyError, new Object[]{key});
            }
            return defaultValue;
        }
    }

    @Builtin(name="setdefault", minNumOfPositionalArgs=2, parameterNames={"self", "key", "default"})
    @ArgumentClinic(name="default", defaultValue="PNone.NONE")
    @GenerateNodeFactory
    static abstract class SetDefaultNode
    extends PythonTernaryClinicBuiltinNode {
        SetDefaultNode() {
        }

        @Specialization
        Object doIt(VirtualFrame frame, Object dict, Object key, Object defaultValue, @Bind Node inliningTarget, @Cached PyDictSetDefault setDefault) {
            return setDefault.execute((Frame)frame, inliningTarget, dict, key, defaultValue);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return DictBuiltinsClinicProviders.SetDefaultNodeClinicProviderGen.INSTANCE;
        }
    }

    @Slot(value=Slot.SlotKind.tp_init, isComplex=true)
    @Slot.SlotSignature(name="dict", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class InitNode
    extends PythonVarargsBuiltinNode {
        @Node.Child
        private HashingStorage.InitNode initNode;

        private HashingStorage.InitNode getInitNode() {
            if (this.initNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.initNode = (HashingStorage.InitNode)this.insert(HashingStorage.InitNode.create());
            }
            return this.initNode;
        }

        @Specialization(guards={"args.length == 1"})
        Object doVarargs(VirtualFrame frame, Object self, Object[] args, PKeyword[] kwargs, @Bind Node inliningTarget, @Cached.Shared @Cached DictNodes.GetDictStorageNode getStorageNode, @Cached.Shared @Cached DictNodes.UpdateDictStorageNode updateDictStorageNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageAddAllToOther addAllToOtherNode) {
            HashingStorage add = this.getInitNode().execute(frame, args[0], kwargs);
            HashingStorage storage = getStorageNode.execute(inliningTarget, self);
            HashingStorage newStorage = addAllToOtherNode.execute((Frame)frame, inliningTarget, add, storage);
            updateDictStorageNode.execute(inliningTarget, self, storage, newStorage);
            return PNone.NONE;
        }

        @Specialization(guards={"args.length == 0", "kwargs.length > 0"})
        Object doKeywords(VirtualFrame frame, Object self, Object[] args, PKeyword[] kwargs, @Bind Node inliningTarget, @Cached.Shared @Cached DictNodes.GetDictStorageNode getStorageNode, @Cached.Shared @Cached DictNodes.UpdateDictStorageNode updateDictStorageNode, @Cached.Shared @Cached HashingStorageNodes.HashingStorageAddAllToOther addAllToOtherNode) {
            HashingStorage add = this.getInitNode().execute(frame, PNone.NO_VALUE, kwargs);
            HashingStorage storage = getStorageNode.execute(inliningTarget, self);
            HashingStorage newStorage = addAllToOtherNode.execute((Frame)frame, inliningTarget, add, storage);
            updateDictStorageNode.execute(inliningTarget, self, storage, newStorage);
            return PNone.NONE;
        }

        @Specialization(guards={"args.length == 0", "kwargs.length == 0"})
        static Object doEmpty(Object self, Object[] args, PKeyword[] kwargs) {
            return PNone.NONE;
        }

        @Specialization(guards={"args.length > 1"})
        Object doGeneric(Object self, Object[] args, PKeyword[] kwargs) {
            throw PRaiseNode.raiseStatic(this, PythonErrorType.TypeError, ErrorMessages.EXPECTED_AT_MOST_D_ARGS_GOT_D, "dict", 1, args.length);
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="dict", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class DictionaryNode
    extends PythonBuiltinNode {
        @Specialization(guards={"isBuiltinDict(cls)"})
        static PDict builtinDict(Object cls, Object[] args, PKeyword[] keywordArgs, @Bind PythonLanguage language) {
            return PFactory.createDict(language);
        }

        @Specialization(replaces={"builtinDict"})
        static PDict dict(Object cls, Object[] args, PKeyword[] keywordArgs, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached InlinedConditionProfile orderedProfile, @Cached IsSubtypeNode isSubtypeNode, @Cached TypeNodes.GetInstanceShape getInstanceShape) {
            Shape shape = getInstanceShape.execute(cls);
            if (orderedProfile.profile(inliningTarget, isSubtypeNode.execute(cls, (Object)PythonBuiltinClassType.POrderedDict))) {
                return PFactory.createOrderedDict(language, cls, shape);
            }
            return PFactory.createDict(language, cls, shape, EmptyStorage.INSTANCE);
        }

        protected static boolean isBuiltinDict(Object cls) {
            return cls == PythonBuiltinClassType.PDict;
        }
    }
}

