/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.charset;

import com.oracle.graal.python.util.PythonUtils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class PythonUTF32CharsetWrapper
extends Charset {
    private final ByteOrder byteOrder;
    private final Charset delegate;

    public PythonUTF32CharsetWrapper(Charset delegate, ByteOrder byteOrder) {
        super("x-python-UTF32" + (byteOrder == ByteOrder.BIG_ENDIAN ? "BE" : "LE"), PythonUtils.EMPTY_STRING_ARRAY);
        this.byteOrder = byteOrder;
        this.delegate = delegate;
    }

    @Override
    public boolean contains(Charset cs) {
        return this.delegate.contains(cs);
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new DecoderWrapper((Charset)this, this.delegate.newDecoder(), this.byteOrder);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return this.delegate.newEncoder();
    }

    private static class DecoderWrapper
    extends CharsetDecoder {
        private final CharsetDecoder delegate;
        private final ByteOrder byteOrder;

        private DecoderWrapper(Charset charset, CharsetDecoder delegate, ByteOrder byteOrder) {
            super(charset, 4.0f, 4.0f);
            this.delegate = delegate;
            this.byteOrder = byteOrder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            ByteOrder originalByteOrder = in.order();
            int originalPosition = in.position();
            in.order(this.byteOrder);
            try {
                while (in.remaining() >= 4) {
                    int cp = in.getInt();
                    if (55296 > cp || cp > 57343) continue;
                    in.position(in.position() - 4);
                    CoderResult coderResult = CoderResult.malformedForLength(4);
                    return coderResult;
                }
            }
            finally {
                in.order(originalByteOrder);
            }
            in.position(originalPosition);
            return this.delegate.decode(in, out, false);
        }
    }
}

