/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.repository.manager;

import com.ibm.db2.cmx.runtime.internal.repository.MetadataException;
import com.ibm.db2.cmx.runtime.internal.repository.api.IncrementalDataManager;
import com.ibm.db2.cmx.runtime.internal.repository.api.IncrementalSavedDataInfo;
import com.ibm.db2.cmx.runtime.internal.repository.api.MDOutputStream;
import com.ibm.db2.cmx.runtime.internal.repository.api.exception.SizeDoesNotMatchException;
import com.ibm.db2.cmx.runtime.internal.repository.manager.MDOutputStreamImpl;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.CaptureData;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.CaptureDataReader;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.dataAccess.CaptureDataWriter;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipInputStream;

public class IncrementalDataManagerImpl
implements IncrementalDataManager {
    private Connection c = null;
    private String schema = null;

    public IncrementalDataManagerImpl(Connection connection, String string) {
        this.c = connection;
        this.schema = string;
    }

    @Override
    public MDOutputStream add(String string, String string2) throws MetadataException {
        return new MDOutputStreamImpl(this, string, string2, null);
    }

    @Override
    public MetadataException canWrite(String string) {
        Object object;
        boolean bl2;
        Logger logger = Log.getLogger();
        boolean bl3 = bl2 = logger != null && logger.isLoggable(Level.FINE);
        if (bl2) {
            object = "runtimeGroupId " + string;
            logger.logp(Level.FINE, "IncrementalDataManagerImpl", "canWrite", (String)object);
        }
        object = CaptureDataWriter.getInstance(this.schema);
        MetadataException metadataException = null;
        try {
            int n2 = ((CaptureDataWriter)object).createEntry(this.c, string, null, null, 0);
            ((CaptureDataWriter)object).removeEntry(this.c, n2, -1);
        }
        catch (MetadataException metadataException2) {
            metadataException = metadataException2;
        }
        if (bl2) {
            String string2 = "No error...write operation successful";
            if (metadataException != null) {
                string2 = "Write operation failed " + metadataException.toString();
            }
            logger.logp(Level.FINE, "IncrementalDataManagerImpl", "canWrite", string2);
        }
        return metadataException;
    }

    @Override
    public void delete(int n2, int n3) throws MetadataException, SizeDoesNotMatchException {
        CaptureDataWriter captureDataWriter = CaptureDataWriter.getInstance(this.schema);
        int n4 = captureDataWriter.removeEntry(this.c, n2, n3);
        if (n4 == 0) {
            CaptureDataReader captureDataReader = CaptureDataReader.getInstance(this.schema);
            CaptureData captureData = captureDataReader.getValue(this.c, n2);
            if (captureData != null) {
                String string = Messages.getText("ERR_CAPTURE_DATA_ENTRY_NOT_DELETED_BECAUSE_SIZE_MISMATCH", n2, captureData.getLength(), n3);
                throw new SizeDoesNotMatchException(string, null);
            }
            String string = Messages.getText("ERR_INVALID_CAPTURE_DATA_KEY", n2);
            throw new MetadataException(string, null);
        }
    }

    @Override
    public InputStream getContent(int n2) throws MetadataException {
        CaptureDataReader captureDataReader = CaptureDataReader.getInstance(this.schema);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ZipInputStream zipInputStream = null;
        try {
            captureDataReader.getContentFor(this.c, n2, byteArrayOutputStream);
            byteArrayOutputStream.close();
            zipInputStream = new ZipInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            zipInputStream.getNextEntry();
        }
        catch (IOException iOException) {
            throw new MetadataException(Messages.getText("ERR_CANNOT_READ_REPOSITORY", new Object[0]), iOException);
        }
        return zipInputStream;
    }

    @Override
    public List<IncrementalSavedDataInfo> list() throws MetadataException {
        CaptureDataReader captureDataReader = CaptureDataReader.getInstance(this.schema);
        ArrayList<IncrementalSavedDataInfo> arrayList = new ArrayList<IncrementalSavedDataInfo>();
        List<CaptureData> list = captureDataReader.getValues(this.c);
        for (CaptureData captureData : list) {
            arrayList.add(captureData);
        }
        return arrayList;
    }

    @Override
    public List<IncrementalSavedDataInfo> list(String string) throws MetadataException {
        CaptureDataReader captureDataReader = CaptureDataReader.getInstance(this.schema);
        ArrayList<IncrementalSavedDataInfo> arrayList = new ArrayList<IncrementalSavedDataInfo>();
        List<CaptureData> list = captureDataReader.getValues(this.c, string);
        for (CaptureData captureData : list) {
            arrayList.add(captureData);
        }
        return arrayList;
    }

    @Override
    public MDOutputStream replace(String string, String string2, int n2) throws MetadataException {
        return new MDOutputStreamImpl(this, string, string2, n2);
    }

    @Override
    public void updateState(int n2, String string, int n3) throws MetadataException {
        CaptureDataWriter captureDataWriter = CaptureDataWriter.getInstance(this.schema);
        int n4 = captureDataWriter.updateState(this.c, n2, string, n3);
        if (n4 == 0) {
            CaptureDataReader captureDataReader = CaptureDataReader.getInstance(this.schema);
            CaptureData captureData = captureDataReader.getValue(this.c, n2);
            if (captureData != null) {
                String string2 = Messages.getText("ERR_CAPTURE_DATA_ENTRY_NOT_UPDATED_BECAUSE_SIZE_MISMATCH", n2, captureData.getLength(), n3);
                throw new SizeDoesNotMatchException(string2, null);
            }
            String string3 = Messages.getText("ERR_INVALID_CAPTURE_DATA_KEY", n2);
            throw new MetadataException(string3, null);
        }
    }

    protected boolean updateContent(int n2, byte[] byArray, int n3) throws MetadataException {
        CaptureDataWriter captureDataWriter = CaptureDataWriter.getInstance(this.schema);
        int n4 = captureDataWriter.replaceEntry(this.c, n2, byArray, n3);
        return n4 > 0;
    }

    protected int create(String string, String string2, byte[] byArray, int n2) throws MetadataException {
        CaptureDataWriter captureDataWriter = CaptureDataWriter.getInstance(this.schema);
        int n3 = captureDataWriter.createEntry(this.c, string, string2, byArray, n2);
        return n3;
    }

    protected IncrementalSavedDataInfo getIncrementalSavedDataInfo(int n2) throws MetadataException {
        CaptureDataReader captureDataReader = CaptureDataReader.getInstance(this.schema);
        CaptureData captureData = captureDataReader.getValue(this.c, n2);
        return captureData;
    }
}

