/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.object;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.CoreLayoutFactory;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.ExtLayoutFactory;
import com.oracle.truffle.api.object.LayoutFactory;
import com.oracle.truffle.api.object.Shape;
import java.util.List;

abstract class Layout {
    public static final String OPTION_PREFIX = "truffle.object.";
    private static final Iterable<LayoutFactory> LAYOUT_FACTORIES = List.of(new CoreLayoutFactory(), new ExtLayoutFactory());
    private static final LayoutFactory LAYOUT_FACTORY = Layout.loadLayoutFactory();
    static final int INT_TO_DOUBLE_FLAG = 1;
    static final int INT_TO_LONG_FLAG = 2;

    protected Layout() {
    }

    public abstract Class<? extends DynamicObject> getType();

    protected Shape buildShape(Object dynamicType, Object sharedData, int flags, Assumption singleContextAssumption) {
        throw new UnsupportedOperationException();
    }

    protected static LayoutFactory getFactory() {
        return LAYOUT_FACTORY;
    }

    private static LayoutFactory loadLayoutFactory() {
        LayoutFactory layoutFactory = Layout.selectLayoutFactory(LAYOUT_FACTORIES);
        if (layoutFactory == null) {
            throw CompilerDirectives.shouldNotReachHere("LayoutFactory not found");
        }
        return layoutFactory;
    }

    private static LayoutFactory selectLayoutFactory(Iterable<LayoutFactory> availableLayoutFactories) {
        String layoutFactoryImplName = System.getProperty("truffle.object.LayoutFactory");
        LayoutFactory bestLayoutFactory = null;
        for (LayoutFactory currentLayoutFactory : availableLayoutFactories) {
            if (layoutFactoryImplName != null) {
                if (!currentLayoutFactory.getClass().getName().equals(layoutFactoryImplName)) continue;
                return currentLayoutFactory;
            }
            if (bestLayoutFactory == null) {
                bestLayoutFactory = currentLayoutFactory;
                continue;
            }
            if (currentLayoutFactory.getPriority() < bestLayoutFactory.getPriority()) continue;
            assert (currentLayoutFactory.getPriority() != bestLayoutFactory.getPriority());
            bestLayoutFactory = currentLayoutFactory;
        }
        return bestLayoutFactory;
    }
}

