/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.intl.GetOptionsObjectNode;
import com.oracle.truffle.js.nodes.temporal.GetTemporalCalendarIdentifierWithISODefaultNode;
import com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import com.oracle.truffle.js.nodes.temporal.TemporalYearMonthFromFieldsNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.temporal.ISODateRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDateTimeRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainYearMonth;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainYearMonthObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.util.IntlUtil;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalErrors;
import com.oracle.truffle.js.runtime.util.TemporalUtil;

public abstract class ToTemporalYearMonthNode
extends JavaScriptBaseNode {
    protected ToTemporalYearMonthNode() {
    }

    public abstract JSTemporalPlainYearMonthObject execute(Object var1, Object var2);

    @Specialization
    public JSTemporalPlainYearMonthObject toTemporalYearMonth(Object item, Object optionsParam, @Cached InlinedConditionProfile isObjectProfile, @Cached(value="create(getJSContext())") GetOptionsObjectNode getOptionsObject, @Cached InlinedBranchProfile errorBranch, @Cached IsObjectNode isObjectNode, @Cached TemporalGetOptionNode getOptionNode, @Cached GetTemporalCalendarIdentifierWithISODefaultNode getCalendarWithISODefault, @Cached TemporalYearMonthFromFieldsNode yearMonthFromFieldsNode, @Cached TruffleString.ToJavaStringNode toJavaString, @Cached TruffleString.FromJavaStringNode fromJavaString) {
        JSContext ctx = this.getJSContext();
        Object options = optionsParam;
        if (isObjectProfile.profile((Node)this, isObjectNode.executeBoolean(item))) {
            if (item instanceof JSTemporalPlainYearMonthObject) {
                JSTemporalPlainYearMonthObject yearMonth = (JSTemporalPlainYearMonthObject)((Object)item);
                Object resolvedOptions = getOptionsObject.execute(options);
                TemporalUtil.getTemporalOverflowOption(resolvedOptions, getOptionNode);
                return JSTemporalPlainYearMonth.create(ctx, this.getRealm(), yearMonth.getYear(), yearMonth.getMonth(), yearMonth.getCalendar(), yearMonth.getDay(), this, errorBranch);
            }
            TruffleString calendar = getCalendarWithISODefault.execute(item);
            JSObject fields = TemporalUtil.prepareCalendarFields(ctx, calendar, item, TemporalUtil.listMMCY, TemporalUtil.listEmpty, TemporalUtil.listEmpty);
            Object resolvedOptions = getOptionsObject.execute(options);
            TemporalUtil.Overflow overflow = TemporalUtil.getTemporalOverflowOption(resolvedOptions, getOptionNode);
            return yearMonthFromFieldsNode.execute(calendar, fields, overflow);
        }
        if (item instanceof TruffleString) {
            TruffleString string = (TruffleString)item;
            JSTemporalDateTimeRecord result = TemporalUtil.parseTemporalYearMonthString(string);
            TruffleString calendar = result.getCalendar();
            if (calendar == null) {
                calendar = TemporalConstants.ISO8601;
            } else {
                String calendarJLS = toJavaString.execute((AbstractTruffleString)calendar);
                calendar = Strings.fromJavaString(fromJavaString, IntlUtil.canonicalizeCalendar(calendarJLS));
            }
            Object resolvedOptions = getOptionsObject.execute(options);
            TemporalUtil.getTemporalOverflowOption(resolvedOptions, getOptionNode);
            ISODateRecord isoDate = TemporalUtil.createISODateRecord(result.getYear(), result.getMonth(), result.getDay());
            if (!TemporalUtil.isoYearMonthWithinLimits(isoDate.year(), isoDate.month())) {
                errorBranch.enter((Node)this);
                throw TemporalErrors.createRangeErrorMonthDayOutsideRange();
            }
            JSObject result2 = TemporalUtil.isoDateToFields(ctx, calendar, isoDate, TemporalUtil.FieldsType.YEAR_MONTH);
            return yearMonthFromFieldsNode.execute(calendar, result2, TemporalUtil.Overflow.CONSTRAIN);
        }
        errorBranch.enter((Node)this);
        throw Errors.createTypeErrorNotAString(item);
    }
}

