/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ext.javatime.deser;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.time.DateTimeException;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.core.util.VersionUtil;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.cfg.CoercionAction;
import tools.jackson.databind.cfg.CoercionInputShape;
import tools.jackson.databind.ext.javatime.deser.JSR310DeserializerBase;
import tools.jackson.databind.jsontype.TypeDeserializer;

public class JSR310StringParsableDeserializer
extends JSR310DeserializerBase<Object> {
    protected static final int TYPE_PERIOD = 1;
    protected static final int TYPE_ZONE_ID = 2;
    protected static final int TYPE_ZONE_OFFSET = 3;
    public static final ValueDeserializer<Period> PERIOD = JSR310StringParsableDeserializer.createDeserializer(Period.class, 1);
    public static final ValueDeserializer<ZoneId> ZONE_ID = JSR310StringParsableDeserializer.createDeserializer(ZoneId.class, 2);
    public static final ValueDeserializer<ZoneOffset> ZONE_OFFSET = JSR310StringParsableDeserializer.createDeserializer(ZoneOffset.class, 3);
    protected final int _typeSelector;

    protected JSR310StringParsableDeserializer(Class<?> supportedType, int typeSelector) {
        super(supportedType);
        this._typeSelector = typeSelector;
    }

    protected JSR310StringParsableDeserializer(JSR310StringParsableDeserializer base, Boolean leniency) {
        super(base, leniency);
        this._typeSelector = base._typeSelector;
    }

    protected static <T> ValueDeserializer<T> createDeserializer(Class<T> type, int typeId) {
        return new JSR310StringParsableDeserializer(type, typeId);
    }

    protected JSR310StringParsableDeserializer withLeniency(Boolean leniency) {
        if (this._isLenient == !Boolean.FALSE.equals(leniency)) {
            return this;
        }
        return new JSR310StringParsableDeserializer(this, leniency);
    }

    @Override
    public ValueDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
        Boolean leniency;
        JsonFormat.Value format = this.findFormatOverrides(ctxt, property, this.handledType());
        JSR310StringParsableDeserializer deser = this;
        if (format != null && format.hasLenient() && (leniency = format.getLenient()) != null) {
            deser = this.withLeniency(leniency);
        }
        return deser;
    }

    @Override
    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        if (p.hasToken(JsonToken.VALUE_STRING)) {
            return this._fromString(p, ctxt, p.getString());
        }
        if (p.isExpectedStartObjectToken()) {
            String str = ctxt.extractScalarFromObject(p, this, this.handledType());
            if (str != null) {
                return this._fromString(p, ctxt, str);
            }
        } else {
            if (p.hasToken(JsonToken.VALUE_EMBEDDED_OBJECT)) {
                return p.getEmbeddedObject();
            }
            if (p.isExpectedStartArrayToken()) {
                return this._deserializeFromArray(p, ctxt);
            }
        }
        throw ctxt.wrongTokenException(p, this.handledType(), JsonToken.VALUE_STRING, null);
    }

    @Override
    public Object deserializeWithType(JsonParser p, DeserializationContext context, TypeDeserializer deserializer) throws JacksonException {
        JsonToken t = p.currentToken();
        if (t != null && t.isScalarValue()) {
            return this.deserialize(p, context);
        }
        return deserializer.deserializeTypedFromAny(p, context);
    }

    protected Object _fromString(JsonParser p, DeserializationContext ctxt, String string) throws JacksonException {
        if ((string = string.trim()).length() == 0) {
            CoercionAction act = ctxt.findCoercionAction(this.logicalType(), this._valueClass, CoercionInputShape.EmptyString);
            if (act == CoercionAction.Fail) {
                ctxt.reportInputMismatch(this, "Cannot coerce empty String (\"\") to %s (but could if enabling coercion using `CoercionConfig`)", this._coercedTypeDesc());
            }
            if (!this.isLenient()) {
                return this._failForNotLenient(p, ctxt, JsonToken.VALUE_STRING);
            }
            if (act == CoercionAction.AsEmpty) {
                return this.getEmptyValue(ctxt);
            }
            return null;
        }
        try {
            switch (this._typeSelector) {
                case 1: {
                    return Period.parse(string);
                }
                case 2: {
                    return ZoneId.of(string);
                }
                case 3: {
                    return ZoneOffset.of(string);
                }
            }
        }
        catch (DateTimeException e) {
            return this._handleDateTimeFormatException(ctxt, e, null, string);
        }
        VersionUtil.throwInternal();
        return null;
    }
}

